#include "widget/DlgLCDNumber.h"
#include "widget/DlgFrame.h"

#include "prop/FramePage.h"
#include "prop/LCDNumberPage.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgLCDNumber::itsSignals;
int DlgLCDNumber::itsNextWidgetNum = 1;

DlgLCDNumber::DlgLCDNumber
(
    QWidget*		parent,
    const char*	name
)
    :
    Inherited( DlgWidget::DW_LCDNumber, parent )
{
    itsWidget = new LCDNumber( parent, CreateName( "LCDNumber", name, 
						   itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgLCDNumber::~DlgLCDNumber()
{
}


void DlgLCDNumber::GetPropertyPages
(
    QWidget*		parent,
    QList<QWidget>&	pages,
    QStrList&		labels
)
{
    pages.append( new FramePage( this, parent, "Frame" ) );
    pages.append( new LCDNumberPage( this, parent, "LCD Number" ) );

    labels.append( "Frame" );
    labels.append( "LCD Number" );
}


void DlgLCDNumber::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nLCDNumber {";
  
    DlgLCDNumber::SaveQt( stream, (const QLCDNumber *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgLCDNumber::SaveQt
(
   QTextStream &stream,
   const QLCDNumber *widget
)
{
    QString aStr;

    aStr.setNum( widget->numDigits() );
    stream << "\n\t\tDigits {" << aStr << "}";

    stream << "\n\t\tSmallDecimalPoint {"; 
    SaveBool( stream, widget->smallDecimalPoint() );
    stream << "}";

    if( widget->mode() == QLCDNumber::HEX )
	aStr = "Hex";
    else if( widget->mode() == QLCDNumber::DEC )
	aStr = "Dec";
    else if( widget->mode() == QLCDNumber::OCT )
	aStr = "Oct";
    else
	aStr = "Bin";
    stream << "\n\t\tMode {" << aStr << "}";

    stream << "\n\t\tSegmentStyle {" << 
	GuiTools::QLCDNumberSegStyleStr( widget->segmentStyle() ) << "}";

    DlgFrame::SaveQt( stream, widget );
}

bool DlgLCDNumber::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( key == "Name" )
  {
      // Update the widget number so that no duplicate names are created
      UpdateNextWidgetNumber( value, itsNextWidgetNum );
  }

  if( ! DlgLCDNumber::RestoreQt( key, value, (QLCDNumber *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgLCDNumber::RestoreQt
(
   const QString &key,
   const QString &value,
   QLCDNumber *widget
)
{
    // Compare to known keys
    if( key == "Digits" )
    {
	widget->setNumDigits( value.toInt() );
    } else if( key == "SmallDecimalPoint" )
    {
	if( value == "TRUE" )
	    widget->setSmallDecimalPoint( TRUE );
	else
	    widget->setSmallDecimalPoint( FALSE );
    } else if( key == "Mode" )
    {
	if( value == "Hex" )
	    widget->setHexMode();
	else if( value == "Dec" )
	    widget->setDecMode();
	else if( value == "Oct" )
	    widget->setOctMode();
	else
	    widget->setBinMode();
    }
    else if( key == "SegmentStyle" )
    {
	widget->setSegmentStyle( GuiTools::QLCDNumberSegStyle( value ) );
    }
    else
    {
	// Key unknown
	return DlgFrame::RestoreQt( key, value, widget );
    }
    return TRUE;
}  


void DlgLCDNumber::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgFrame::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QLCDNumber* widget = (const QLCDNumber*)dlgWidget.GetWidget();

    stream << varName << "setSmallDecimalPoint( " <<
	(widget->smallDecimalPoint() ? "TRUE" : "FALSE") << " );\n";

    stream << varName << "setNumDigits( " << widget->numDigits() << " );\n";

    QString mode;
    switch( widget->mode() )
    {
	case QLCDNumber::HEX:
	{
	    mode = "HEX";
	    break;
	}
	case QLCDNumber::OCT:
	{
	    mode = "OCT";
	    break;
	}
	case QLCDNumber::BIN:
	{
	    mode = "BIN";
	    break;
	}
	case QLCDNumber::DEC:
	default:
	{
	    mode = "DEC";
	    break;
	}
    }
    
    stream << varName << "setMode( QLCDNumber::" << mode << " );\n";

    stream << varName << "setSegmentStyle( QLCDNumber::" <<
	GuiTools::QLCDNumberSegStyleStr( widget->segmentStyle() ) << " );\n";
}


void DlgLCDNumber::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgLCDNumber::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "overflow()" );
    }

    return itsSignals;
}
