/*
 * File:	objects.h
 * Purpose:	
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

/*
 * Purpose:  Object graphics library demo for wxWindows.
 *           Defines a canvas which repaints its own graphics objects.
 */


// Define a new application
class MyApp: public wxApp
{
  public:
    wxFrame *OnInit(void);
};

// Define a new frame
class MyFrame: public wxFrame
{
  public:
    ObjectCanvas *canvas;
    MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
    Bool OnClose(void);
    void OnMenuCommand(int id);

    void LoadObject(void);
    void SaveObject(void);
};

class MyLine: public LineObject
{
 public:
  MyLine(void);
  void OnLeftClick(float x, float y, int keys = 0, int attachment = 0);
};

class MyRectangle: public RectangleObject
{
 public:
  char *label;

  MyRectangle(float width, float height);
  void OnLeftClick(float x, float y, int keys = 0, int attachment = 0);

  // N.B. You could override the OnDraw function to supply additional
  // graphic elements; call RectangleObject::OnDraw first though.
};

class MyDrawn: public DrawnObject
{
 public:
  char *label;

  MyDrawn(void);
  void OnLeftClick(float x, float y, int keys = 0, int attachment = 0);
};

class MyEllipse: public EllipseObject
{
 public:
  char *label;

  MyEllipse(float width, float height);
  void OnLeftClick(float x, float y, int keys = 0, int attachment = 0);
};

class MyComposite: public CompositeObject
{
 public:
  char *label;

  MyComposite(void);
  void OnLeftClick(float x, float y, int keys = 0, int attachment = 0);
};

// Callbacks
void GenericOk(wxButton& but, wxCommandEvent& event);

#define OBJECTS_QUIT         1
#define OBJECTS_ABOUT        2
#define OBJECTS_ELLIPSE      3
#define OBJECTS_RECTANGLE    4
#define OBJECTS_DELETE       5
#define OBJECTS_CONNECT      6
#define OBJECTS_EDIT_TEXT    7
#define OBJECTS_EDIT_SCALE   8
#define OBJECTS_TEST_BLACK   9
#define OBJECTS_TEST_WHITE   10
#define OBJECTS_TEST_ERASE   11
#define OBJECTS_DRAWN        12
#define OBJECTS_LOAD_OBJECT  13
#define OBJECTS_SAVE_OBJECT  14
#define OBJECTS_ROTATE       15
#define OBJECTS_CONTAINER    16

