/******************************************************************************
 JMMErrorPrinter.h

	Interface for the JMMErrorPrinter class.

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

 *****************************************************************************/

#ifndef _H_JMMErrorPrinter
#define _H_JMMErrorPrinter

// Superclass Header
#include <JMMMonitor.h>

#include <jTypes.h>

class JMMErrorPrinter : public JMMMonitor
{
public:

	JMMErrorPrinter();
	virtual ~JMMErrorPrinter();

	JBoolean GetPrintErrors() const;
	void     SetPrintErrors(const JBoolean print);

protected:

	virtual void HandleObjectDeletedAsArray(const JMMRecord& record);
	virtual void HandleArrayDeletedAsObject(const JMMRecord& record);

	virtual void HandleUnallocatedDeletion(const JCharacter* file, const JUInt32 line,
	                                       const JBoolean isArray);
	virtual void HandleMultipleDeletion(const JMMRecord& thisRecord,
	                                    const JCharacter* file, const JUInt32 line,
	                                    const JBoolean isArray);

	void HandleMultipleAllocation(const JMMRecord& thisRecord,
	                              const JMMRecord& firstRecord);

	void HandleNULLDeleted(const JCharacter* file, const JUInt32 line, const JBoolean isArray);

private:

	JBoolean itsPrintErrorsFlag;

private:

	// not allowed

	JMMErrorPrinter(const JMMErrorPrinter& source);
	const JMMErrorPrinter& operator=(const JMMErrorPrinter& source);
};

/******************************************************************************
 GetPrintErrors

 *****************************************************************************/

inline JBoolean
JMMErrorPrinter::GetPrintErrors() const
{
	return itsPrintErrorsFlag;
}

/******************************************************************************
 SetPrintErrors

	Sets whether error notifications will be printed.  Overrides the
	JMM_NO_PRINT_ERRORS environment variable.

 *****************************************************************************/

inline void
JMMErrorPrinter::SetPrintErrors
	(
	const JBoolean print
	)
{
	itsPrintErrorsFlag = print;
}

#endif
