/******************************************************************************
 JPrinter.h

	Copyright  1999 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JPrinter
#define _H_JPrinter

#include <JBroadcaster.h>

class JPrinter : virtual public JBroadcaster
{
public:

	JPrinter();

	virtual ~JPrinter();

private:

	// not allowed

	JPrinter(const JPrinter& source);
	const JPrinter& operator=(const JPrinter& source);

public:

	// JBroadcaster messages

	static const JCharacter* kPageSetupFinished;
	static const JCharacter* kPrintSetupFinished;

	class PageSetupFinished : public JBroadcaster::Message
		{
		public:

			PageSetupFinished(const JBoolean changed)
				:
				JBroadcaster::Message(kPageSetupFinished),
				itsChangedFlag(changed)
				{ };

			JBoolean
			Changed() const
			{
				return itsChangedFlag;
			};

		private:

			const JBoolean	itsChangedFlag;
		};

	class PrintSetupFinished : public JBroadcaster::Message
		{
		public:

			PrintSetupFinished(const JBoolean success)
				:
				JBroadcaster::Message(kPrintSetupFinished),
				itsSuccessFlag(success)
				{ };

			JBoolean
			Successful() const
			{
				return itsSuccessFlag;
			};

		private:

			const JBoolean	itsSuccessFlag;
		};
};

#endif
