/******************************************************************************
 JTEUndoTabShift.h

	Interface for the JTEUndoTabShift class.

	Copyright  1996-97 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JTEUndoTabShift
#define _H_JTEUndoTabShift

#include <JTEUndoBase.h>

class JTEUndoTabShift : public JTEUndoBase
{
public:

	JTEUndoTabShift(JTextEditor* te, const JIndex startLine);

	virtual ~JTEUndoTabShift();

	virtual void	Undo();

	void	HandleShiftLeft(const JSize tabCount);
	void	HandleShiftRight(const JSize tabCount);
	void	UpdateEndChar();

	// provides safe downcasting

	virtual JTEUndoTabShift*		CastToJTEUndoTabShift();
	virtual const JTEUndoTabShift*	CastToJTEUndoTabShift() const;

private:

	JIndex		itsStartLine;
	JIndex		itsEndChar;
	JInteger	itsShiftCount;

private:

	// not allowed

	JTEUndoTabShift(const JTEUndoTabShift& source);
	const JTEUndoTabShift& operator=(const JTEUndoTabShift& source);
};

#endif
