/******************************************************************************
 JUNIXPrefsManager.cc

	Implements functions required by JPrefsManager for JUNIXPrefsFile.

	BASE CLASS = JPrefsManager

	Copyright  1997 John Lindal. All rights reserved.

 ******************************************************************************/

#include <JUNIXPrefsManager.h>
#include <JUNIXPrefsFile.h>
#include <JString.h>
#include <jFileUtil.h>
#include <jAssert.h>

/******************************************************************************
 Constructor (protected)

 ******************************************************************************/

JUNIXPrefsManager::JUNIXPrefsManager
	(
	const JCharacter*	fileName,
	const JFileVersion	currentVersion,
	const JBoolean		eraseFileIfOpen
	)
	:
	JPrefsManager(fileName, currentVersion, eraseFileIfOpen)
{
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JUNIXPrefsManager::~JUNIXPrefsManager()
{
}

/******************************************************************************
 CreateFile (virtual protected)

 ******************************************************************************/

JError
JUNIXPrefsManager::CreateFile
	(
	const JCharacter*	fileName,
	JPrefsFile**		file
	)
	const
{
	return JUNIXPrefsFile::Create(fileName, reinterpret_cast<JUNIXPrefsFile**>(file));
}

/******************************************************************************
 DeleteFile (virtual protected)

 ******************************************************************************/

JError
JUNIXPrefsManager::DeleteFile
	(
	const JCharacter* fileName
	)
	const
{
	const JString fullName = JUNIXPrefsFile::GetFullName(fileName);
	return JRemoveFile(fullName);
}
