#ifndef _H_jNew
#define _H_jNew

#ifdef _J_ARRAY_NEW_OVERRIDABLE

/******************************************************************************
 JNew.h

	The JCore replacement for operator new.  These functions are simply an
	interface to the appropriate JMemoryManager functions.

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

		WARNING: because of the macro definition 'new' must be #undef'd in every
		file where a non-standard new is called or where a new operator new is
		defined!  Similar remarks apply to delete.  This is rarely an issue in
		practice, however.

 *****************************************************************************/

#include <stdlib.h> // For size_t
#include <jTypes.h>

	#ifdef __KCC
	void* operator new(size_t size) MSIPL_THROW_STR(std::bad_alloc);
	#else
	void* operator new(size_t size);
	#endif

	void* operator new(size_t size, const JCharacter* file, const JUInt32 line);

	#ifdef __KCC
	void* operator new[](size_t size) MSIPL_THROW_STR(std::bad_alloc);
	#else
	void* operator new[](size_t size);
	#endif

	void* operator new[](size_t size, const JCharacter* file, const JUInt32 line);

	void operator delete(void* memory);
	void operator delete[](void* memory);

	void LocateDelete(const JCharacter* file, const JUInt32 line);

/******************************************************************************
 Macros for finding new/delete locations--#undef these if you define your own
 operator new and delete or if your code calls a new with arguments, such as
 placement new!

 *****************************************************************************/

#define new new(__FILE__, __LINE__)

#define delete LocateDelete(__FILE__, __LINE__); delete

#endif	/* _J_ARRAY_NEW_OVERRIDABLE */

#endif
