/******************************************************************************
 jStreamUtil_UNIX.cc

	UNIX System routines to do what streams ought to be able to do
	in the first place.

	Copyright  1995 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <jStreamUtil.h>

/******************************************************************************
 JTellg

 ******************************************************************************/

JSize
JTellg
	(
	istream& stream
	)
{
	return stream.tellg();
}

/******************************************************************************
 JSeekg

 ******************************************************************************/

void
JSeekg
	(
	istream&	stream,
	streampos	position
	)
{
	stream.seekg(position);
}

void
JSeekg
	(
	istream&			stream,
	streamoff			offset,
	JIOStreamSeekDir	direction
	)
{
	stream.seekg(offset, direction);
}

/******************************************************************************
 JTellp

 ******************************************************************************/

JSize
JTellp
	(
	ostream& stream
	)
{
	return stream.tellp();
}

/******************************************************************************
 JSeekp

 ******************************************************************************/

void
JSeekp
	(
	ostream&	stream,
	streampos	position
	)
{
	stream.seekp(position);
}

void
JSeekp
	(
	ostream&			stream,
	streamoff			offset,
	JIOStreamSeekDir	direction
	)
{
	stream.seekp(offset, direction);
}

/******************************************************************************
 JSetState

 ******************************************************************************/

void
JSetState
	(
	ios&		stream,
	const int	flag
	)
{
#ifdef __SUNPRO_CC
	stream.clear(stream.rdstate() | flag);
#else
	stream.setstate(flag);
#endif
}
