/******************************************************************************
 JXCSFSelectPrevDirTask.cc

	BASE CLASS = JXUrgentTask

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXCSFSelectPrevDirTask.h>
#include <JXUNIXDirTable.h>
#include <JUNIXDirInfo.h>
#include <JUNIXDirEntry.h>
#include <JString.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXCSFSelectPrevDirTask::JXCSFSelectPrevDirTask
	(
	JUNIXDirInfo*		dirInfo,
	JXUNIXDirTable*		dirTable,
	const JCharacter*	dirName
	)
	:
	JXUrgentTask()
{
	itsDirInfo  = dirInfo;
	itsDirTable = dirTable;

	itsDirName = new JString(dirName);
	assert( itsDirName != NULL );
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXCSFSelectPrevDirTask::~JXCSFSelectPrevDirTask()
{
	delete itsDirName;
}

/******************************************************************************
 Perform

 ******************************************************************************/

void
JXCSFSelectPrevDirTask::Perform()
{
	JIndex index;
	if (itsDirInfo->FindEntry(*itsDirName, &index))
		{
		itsDirTable->UpdateScrollbars();
		itsDirTable->SelectSingleEntry(index);
		}
}
