/******************************************************************************
 JXChooseFontSizeDialog.cc

	BASE CLASS = JXDialogDirector

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXChooseFontSizeDialog.h>

#include <JXWindow.h>
#include <JXTextButton.h>
#include <JXIntegerInput.h>
#include <JXStaticText.h>

#include <JString.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXChooseFontSizeDialog::JXChooseFontSizeDialog
	(
	JXWindowDirector*	supervisor,
	const JSize			fontSize
	)
	:
	JXDialogDirector(supervisor, kTrue)
{
	BuildWindow(fontSize);
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXChooseFontSizeDialog::~JXChooseFontSizeDialog()
{
}

/******************************************************************************
 BuildWindow (protected)

 ******************************************************************************/

void
JXChooseFontSizeDialog::BuildWindow
	(
	const JSize fontSize
	)
{
// begin JXLayout

    JXWindow* window = new JXWindow(this, 190,90, "");
    assert( window != NULL );
    SetWindow(window);

    JXTextButton* okButton =
        new JXTextButton("OK", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 109,59, 62,22);
    assert( okButton != NULL );
    okButton->SetShortcuts("^M");

    JXTextButton* cancelButton =
        new JXTextButton("Cancel", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,60, 60,20);
    assert( cancelButton != NULL );

    itsFontSize =
        new JXIntegerInput(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 120,20, 40,20);
    assert( itsFontSize != NULL );

    JXStaticText* obj1 =
        new JXStaticText("Font size (points):", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 10,20, 110,20);
    assert( obj1 != NULL );

// end JXLayout

	window->SetTitle("Choose font size");
	SetButtons(okButton, cancelButton);

	itsFontSize->SetValue(fontSize);
	itsFontSize->SetLimits(1, 500);
}

/******************************************************************************
 GetFontSize

 ******************************************************************************/

JSize
JXChooseFontSizeDialog::GetFontSize()
	const
{
	JInteger size;
	const JBoolean ok = itsFontSize->GetValue(&size);
	assert( ok );
	return size;
}
