/******************************************************************************
 JXDisplayDirector.cc

	Director to own a hidden window containing singletons for JXDisplay.

	BASE CLASS = JXWindowDirector

	Copyright  1999 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXDisplayDirector.h>
#include <JXWindow.h>
#include <JXTextClipboard.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXDisplayDirector::JXDisplayDirector
	(
	JXDirector*			supervisor,
	JXTextClipboard**	clip
	)
	:
	JXWindowDirector(supervisor)
{
    JXWindow* window = new JXWindow(this, 10,10, "", kFalse, NULL, kTrue);
    assert( window != NULL );
    SetWindow(window);

	*clip = new JXTextClipboard(window);
	assert( *clip != NULL );
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXDisplayDirector::~JXDisplayDirector()
{
}
