/******************************************************************************
 JXEPSPrintSetupDialog.h

	Interface for the JXEPSPrintSetupDialog class

	Copyright  1997-99 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXEPSPrintSetupDialog
#define _H_JXEPSPrintSetupDialog

#include <JXDialogDirector.h>

class JXEPSPrinter;
class JXTextButton;
class JXStaticText;
class JXTextCheckbox;
class JXFileNameDisplay;

class JXEPSPrintSetupDialog : public JXDialogDirector
{
public:

	JXEPSPrintSetupDialog();

	virtual ~JXEPSPrintSetupDialog();

	void	BuildWindow(const JCharacter* fileName,
						const JBoolean printPreview, const JBoolean bw);

	void	SetParameters(JXEPSPrinter* p) const;

protected:

	void	SetObjects(JXTextButton* okButton, JXTextButton* cancelButton,
					   JXFileNameDisplay* fileNameDisplay, JXTextButton* chooseFileButton,
					   JXTextCheckbox* previewCheckbox, const JBoolean printPreview,
					   JXTextCheckbox* bwCheckbox, const JBoolean bw);

	virtual JBoolean	OKToDeactivate();
	virtual void		Receive(JBroadcaster* sender, const Message& message);

private:

    JXTextButton*	itsPrintButton;

// begin JXLayout

    JXTextButton*      itsChooseFileButton;
    JXTextCheckbox*    itsBWCheckbox;
    JXTextCheckbox*    itsPreviewCheckbox;
    JXFileNameDisplay* itsFileNameDisplay;

// end JXLayout

private:

	void	ChooseDestinationFile();

	// not allowed

	JXEPSPrintSetupDialog(const JXEPSPrintSetupDialog& source);
	const JXEPSPrintSetupDialog& operator=(const JXEPSPrintSetupDialog& source);
};

#endif
