/******************************************************************************
 JXEditHelpPrefsDialog.cc

	BASE CLASS = JXDialogDirector

	Copyright  1998 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXEditHelpPrefsDialog.h>
#include <JXWindow.h>
#include <JXTextButton.h>
#include <JXStaticText.h>
#include <JXInputField.h>
#include <JString.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXEditHelpPrefsDialog::JXEditHelpPrefsDialog
	(
	JXDirector*			supervisor,
	const JCharacter*	viewURLCmd,
	const JCharacter*	sendMailCmd
	)
	:
	JXDialogDirector(supervisor, kTrue)
{
	BuildWindow(viewURLCmd, sendMailCmd);
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXEditHelpPrefsDialog::~JXEditHelpPrefsDialog()
{
}

/******************************************************************************
 BuildWindow (protected)

 ******************************************************************************/

void
JXEditHelpPrefsDialog::BuildWindow
	(
	const JCharacter* viewURLCmd,
	const JCharacter* sendMailCmd
	)
{
// begin JXLayout

    JXWindow* window = new JXWindow(this, 450,170, "");
    assert( window != NULL );
    SetWindow(window);

    itsViewURLCmdInput =
        new JXInputField(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 170,20, 260,20);
    assert( itsViewURLCmdInput != NULL );

    itsSendMailCmdInput =
        new JXInputField(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 170,80, 260,20);
    assert( itsSendMailCmdInput != NULL );

    JXTextButton* cancelButton =
        new JXTextButton("Cancel", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 100,140, 70,20);
    assert( cancelButton != NULL );

    JXTextButton* okButton =
        new JXTextButton("OK", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 269,139, 72,22);
    assert( okButton != NULL );
    okButton->SetShortcuts("^M");

    JXStaticText* obj1 =
        new JXStaticText("(use $u in place of URL)", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 170,40, 150,20);
    assert( obj1 != NULL );

    JXStaticText* obj2 =
        new JXStaticText("Shell cmd to view URL:", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,20, 150,20);
    assert( obj2 != NULL );

    JXStaticText* obj3 =
        new JXStaticText("Shell cmd to send mail:", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,80, 150,20);
    assert( obj3 != NULL );

    JXStaticText* obj4 =
        new JXStaticText("(use $a in place of address)", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 170,100, 170,20);
    assert( obj4 != NULL );

// end JXLayout

	window->SetTitle("Help Preferences");
	SetButtons(okButton, cancelButton);

	itsViewURLCmdInput->SetText(viewURLCmd);
	itsViewURLCmdInput->SetIsRequired();

	itsSendMailCmdInput->SetText(sendMailCmd);
	itsSendMailCmdInput->SetIsRequired();
}

/******************************************************************************
 GetPrefs

 ******************************************************************************/

void
JXEditHelpPrefsDialog::GetPrefs
	(
	JString* viewURLCmd,
	JString* sendMailCmd
	)
	const
{
	*viewURLCmd  = itsViewURLCmdInput->GetText();
	*sendMailCmd = itsSendMailCmdInput->GetText();
}
