/******************************************************************************
 JXPathInput.h

	Interface for the JXPathInput class

	Copyright  1996 by Glenn W. Bach.
	Copyright  1998 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXPathInput
#define _H_JXPathInput

#include <JXInputField.h>

class JXPathInput : public JXInputField
{
public:

	JXPathInput(JXContainer* enclosure,
				const HSizingOption hSizing, const VSizingOption vSizing,
				const JCoordinate x, const JCoordinate y,
				const JCoordinate w, const JCoordinate h);

	virtual ~JXPathInput();

	virtual JBoolean	InputValid();
	JBoolean			GetPath(JString* path) const;

	const JString&	GetBasePath() const;
	void			SetBasePath(const JCharacter* path);
	void			ClearBasePath();

	JBoolean	WillAllowInvalidPath() const;
	void		ShouldAllowInvalidPath(const JBoolean allow = kTrue);

	JBoolean	WillRequireWritable() const;
	void		ShouldRequireWritable(const JBoolean require = kTrue);

	static JColorIndex	GetTextColor(const JCharacter* path, const JCharacter* base,
									 const JBoolean requireWrite, const JColormap* colormap);

protected:

	virtual void	HandleUnfocusEvent();
	virtual void	ApertureResized(const JCoordinate dw, const JCoordinate dh);
	virtual void	Receive(JBroadcaster* sender, const Message& message);

	virtual JBoolean	WillAcceptDrop(const JArray<Atom>& typeList, Atom* action,
									   const Time time, const JXWidget* source);
	virtual void		HandleDNDEnter();
	virtual void		HandleDNDHere(const JPoint& pt, const JXWidget* source);
	virtual void		HandleDNDLeave();
	virtual void		HandleDNDDrop(const JPoint& pt, const JArray<Atom>& typeList,
									  const Atom action, const Time time,
									  const JXWidget* source);

	virtual void	AdjustStylesBeforeRecalc(const JString& buffer, JRunArray<Font>* styles,
											 JIndexRange* recalcRange, JIndexRange* redrawRange,
											 const JBoolean deletion);

private:

	JString		itsBasePath;
	JBoolean	itsAllowInvalidPathFlag;
	JBoolean	itsRequireWriteFlag;
	JBoolean	itsExpectURLDropFlag;

private:

	JBoolean	GetDroppedDirectory(const Time time, JString* dirName);

	// not allowed

	JXPathInput(const JXPathInput& source);
	const JXPathInput& operator=(const JXPathInput& source);
};


/******************************************************************************
 GetBasePath

 ******************************************************************************/

inline const JString&
JXPathInput::GetBasePath()
	const
{
	return itsBasePath;
}

/******************************************************************************
 ClearBasePath

 ******************************************************************************/

inline void
JXPathInput::ClearBasePath()
{
	itsBasePath.Clear();
}

/******************************************************************************
 Allow invalid path

 ******************************************************************************/

inline JBoolean
JXPathInput::WillAllowInvalidPath()
	const
{
	return itsAllowInvalidPathFlag;
}

inline void
JXPathInput::ShouldAllowInvalidPath
	(
	const JBoolean allow
	)
{
	itsAllowInvalidPathFlag = allow;
}

/******************************************************************************
 Require writable directory

 ******************************************************************************/

inline JBoolean
JXPathInput::WillRequireWritable()
	const
{
	return itsRequireWriteFlag;
}

inline void
JXPathInput::ShouldRequireWritable
	(
	const JBoolean require
	)
{
	itsRequireWriteFlag = require;
}

#endif
