/******************************************************************************
 JXSaveFileDialog.h

	Interface for the JXSaveFileDialog class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXSaveFileDialog
#define _H_JXSaveFileDialog

#include <JXCSFDialogBase.h>

class JXSaveFileInput;
class JXDirectSaveSource;

class JXSaveFileDialog : public JXCSFDialogBase
{
public:

	JXSaveFileDialog(JXDirector* supervisor, JUNIXDirInfo* dirInfo,
					 const JCharacter* fileFilter);

	virtual ~JXSaveFileDialog();

	void	BuildWindow(const JCharacter* origName, const JCharacter* prompt,
						const JCharacter* message = NULL);

	virtual void	Activate();

	void		Save(const JCharacter* path);
	JBoolean	GetFileName(JString* name) const;

protected:

	void	SetObjects(JXScrollbarSet* scrollbarSet,
					   JXStaticText* promptLabel, const JCharacter* prompt,
					   JXSaveFileInput* fileNameInput, const JCharacter* origName,
					   JXStaticText* pathLabel, JXPathInput* pathInput,
					   JXPathHistoryMenu* pathHistory,
					   JXStaticText* filterLabel, JXInputField* filterInput,
					   JXStringHistoryMenu* filterHistory,
					   JXTextButton* saveButton, JXTextButton* cancelButton,
					   JXTextButton* upButton, JXTextButton* homeButton,
					   JXNewDirButton* newDirButton, JXTextCheckbox* showHiddenCB,
					   const JCharacter* message);

	JXInputField*	GetFileNameInput();

	virtual void	UpdateDisplay();	// must call inherited

	virtual JBoolean	OKToDeactivate();
	virtual void		Receive(JBroadcaster* sender, const Message& message);

private:

	JString*			itsFileName;
	JXDirectSaveSource*	itsXDSSource;

// begin JXLayout

    JXTextButton*    itsSaveButton;
    JXSaveFileInput* itsFileNameInput;

// end JXLayout

private:

	// not allowed

	JXSaveFileDialog(const JXSaveFileDialog& source);
	const JXSaveFileDialog& operator=(const JXSaveFileDialog& source);
};

#endif
