/* $Id: Text.h,v 1.1.1.1 2001/04/09 13:33:28 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_text_h)
#define xarm_text_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>
#include <Xm/Text.h>

class TextClass : public PrimitiveClass {
 protected:
   TextClass() {}
   virtual WidgetClass classPointer() { return xmTextWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmText"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc fp, XtPointer data = NULL)
                                     { XARM_SET_CALLBACK(XmNactivateCallback); }
   void focusCallback(XtCallbackProc fp, XtPointer data = NULL)
                                     { XARM_SET_CALLBACK(XmNfocusCallback); }
   void gainPrimaryCallback(XtCallbackProc fp, XtPointer data = NULL)
                                     { XARM_SET_CALLBACK(XmNgainPrimaryCallback); }
   void losePrimaryCallback(XtCallbackProc fp, XtPointer data = NULL)
                                     { XARM_SET_CALLBACK(XmNlosePrimaryCallback); }
   void losingFocusCallback(XtCallbackProc fp, XtPointer data = NULL)
                                     { XARM_SET_CALLBACK(XmNlosingFocusCallback); }
   void modifyVerifyCallback(XtCallbackProc fp, XtPointer data = NULL)
                                     { XARM_SET_CALLBACK(XmNmodifyVerifyCallback); }
   void modifyVerifyCallbackWcs(XtCallbackProc fp, XtPointer data = NULL)
                                     { XARM_SET_CALLBACK(XmNmodifyVerifyCallbackWcs); }
   void motionVerifyCallback(XtCallbackProc fp, XtPointer data = NULL)
                                     { XARM_SET_CALLBACK(XmNmotionVerifyCallback); }
   void valueChangedCallback(XtCallbackProc fp, XtPointer data = NULL)
                                     { XARM_SET_CALLBACK(XmNvalueChangedCallback); }

   /* convient functions */
   void clearSelection(Time time)    { XmTextClearSelection(widget(), time); }
   Boolean copy(Time t)              { return XmTextCopy(widget(), t); }
   Boolean cut(Time t)               { return XmTextCut(widget(), t); }
   void disableRedisplay()           { XmTextDisableRedisplay(widget()); }
   void enableRedisplay()            { XmTextEnableRedisplay(widget()); }
   Boolean findString(XmTextPosition start, const char *str, 
                         XmTextDirection direction, XmTextPosition *pos);
   Boolean findStringWcs(XmTextPosition start, const wchar_t *wcs, 
                         XmTextDirection direction, XmTextPosition *pos);
   int getBaseline() const                     { return XmTextGetBaseline(widget()); }
   XmTextPosition getCursorPosition() const    { return XmTextGetCursorPosition(widget()); }
   Boolean getEditable() const                 { return XmTextGetEditable(widget()); }
   XmTextPosition getInsertionPosition() const { return XmTextGetInsertionPosition(widget()); }
   XmTextPosition getLastPosition() const      { return XmTextGetLastPosition(widget()); }
   int getMaxLength() const                    { return XmTextGetMaxLength(widget()); }
   char *getSelection() const                  { return XmTextGetSelection(widget()); }
   Boolean getSelectionPosition(XmTextPosition *left, XmTextPosition *right)
                                { return XmTextGetSelectionPosition(widget(), left, right); }
   wchar_t *getSelectionWcs() const            { return XmTextGetSelectionWcs(widget()); }
   XmTextSource getSource() const              { return XmTextGetSource(widget()); }
   char *getString() const                     { return XmTextGetString(widget()); }
   wchar_t *getStringWcs() const               { return XmTextGetStringWcs(widget()); }
   int getSubstring(XmTextPosition start, int no_chars, int buf_sz, char *buf)
     { return XmTextGetSubstring(widget(), start, no_chars, buf_sz, buf); }
   int getSubstringWcs(XmTextPosition start, int no_chars, int buf_sz, wchar_t *buf)
     { return XmTextGetSubstringWcs(widget(), start, no_chars, buf_sz, buf); }
   XmTextPosition getTopCharacter() const      { return XmTextGetTopCharacter(widget()); }
   void insert(XmTextPosition pos, const char *str);
   void insertWcs(XmTextPosition pos, const wchar_t *str);
   Boolean paste() const                       { return XmTextPaste(widget()); }
   Boolean posToXY(XmTextPosition pos, Position *xpos, Position *ypos)
     { return XmTextPosToXY(widget(), pos, xpos, ypos); }
   Boolean remove()                            { return XmTextRemove(widget()); }
   void replace(XmTextPosition from, XmTextPosition to, const char *val);
   void replaceWcs(XmTextPosition from, XmTextPosition to, const wchar_t *val);
   void scroll(int lines)                      { XmTextScroll(widget(), lines); }
   void setAddMode(Boolean state)              { XmTextSetAddMode(widget(), state); }
   void setCursorPosition(const XmTextPosition pos) { XmTextSetCursorPosition(widget(), pos); }
   void setEditable(Boolean edit) { XmTextSetEditable(widget(), edit); }
   void setHighlight(XmTextPosition left, XmTextPosition right, XmHighlightMode mode)
     { XmTextSetHighlight(widget(), left, right, mode); }
   void setInsertionPosition(const XmTextPosition pos) { XmTextSetInsertionPosition(widget(), pos); }
   void setMaxLength(int max)                  { XmTextSetMaxLength(widget(), max); }
   void setSelection(XmTextPosition first, XmTextPosition last, Time t)
     { XmTextSetSelection(widget(), first, last, t); }
   void setSource(XmTextSource src, XmTextPosition top, XmTextPosition cursor)
     { XmTextSetSource(widget(), src, top, cursor); }
   void setString(const char *str);
   void setStringWcs(const wchar_t *str);
   void setTopCharacter(const XmTextPosition top) { XmTextSetTopCharacter(widget(), top); }
   void showPosition(const XmTextPosition pos) { XmTextShowPosition(widget(), pos); }
   XmTextPosition xyToPos(Position xpos, Position ypos) const
     { return XmTextXYToPos(widget(), xpos, ypos); }

   /* resources */
   void autoShowCursorPosition(Boolean val) { XARM_SET_VALUE(XmNautoShowCursorPosition); }
   Boolean autoShowCursorPosition() const { XARM_GET_VALUE(Boolean, XmNautoShowCursorPosition); }
   void blinkRate(int val)                          { XARM_SET_VALUE(XmNblinkRate); }
   int blinkRate() const                            { XARM_GET_VALUE(int, XmNblinkRate); }
   void columns(short val)                          { XARM_SET_VALUE(XmNcolumns); }
   short columns() const                            { XARM_GET_VALUE(short, XmNcolumns); }
   void cursorPosition(const XmTextPosition val)    { XARM_SET_VALUE(XmNcursorPosition); }
   XmTextPosition cursorPosition() const { XARM_GET_VALUE(XmTextPosition, XmNcursorPosition); }
   void cursorPositionVisible(Boolean val)          { XARM_SET_VALUE(XmNcursorPositionVisible); }
   Boolean cursorPositionVisible() const { XARM_GET_VALUE(Boolean, XmNcursorPositionVisible); }
   void editable(Boolean val)                       { XARM_SET_VALUE(XmNeditable); }
   Boolean editable() const                         { XARM_GET_VALUE(Boolean, XmNeditable); }
   void editMode(int val)                           { XARM_SET_VALUE(XmNeditMode); }
   int editMode() const                             { XARM_GET_VALUE(int, XmNeditMode); }
   void fontList(const XmFontList val)              { XARM_SET_VALUE(XmNfontList); }
   XmFontList fontList() const                      { XARM_GET_VALUE(XmFontList, XmNfontList); }
   void marginHeight(Dimension val)                 { XARM_SET_VALUE(XmNmarginHeight); }
   Dimension marginHeight() const                   { XARM_GET_VALUE(Dimension, XmNmarginHeight); }
   void marginWidth(Dimension val)                  { XARM_SET_VALUE(XmNmarginWidth); }
   Dimension marginWidth() const                    { XARM_GET_VALUE(Dimension, XmNmarginWidth); }
   void maxLength(int val)                          { XARM_SET_VALUE(XmNmaxLength); }
   int maxLength() const                            { XARM_GET_VALUE(int, XmNmaxLength); }
   void pendingDelete(Boolean val)                  { XARM_SET_VALUE(XmNpendingDelete); }
   Boolean pendingDelete() const                    { XARM_GET_VALUE(Boolean, XmNpendingDelete); }
   void resizeHeight(Boolean val)                   { XARM_SET_VALUE(XmNresizeHeight); }
   Boolean resizeHeight() const                     { XARM_GET_VALUE(Boolean, XmNresizeHeight); }
   void resizeWidth(Boolean val)                    { XARM_SET_VALUE(XmNresizeWidth); }
   Boolean resizeWidth() const                      { XARM_GET_VALUE(Boolean, XmNresizeWidth); }
   void rows(short val)                             { XARM_SET_VALUE(XmNrows); }
   short rows() const                               { XARM_GET_VALUE(short, XmNrows); }
   void selectionArray(const XmTextScanType *val)   { XARM_SET_VALUE(XmNselectionArray); }
   XmTextScanType *selectionArray() const { XARM_GET_VALUE(XmTextScanType *, XmNselectionArray); }
   void selectionArrayCount(int val)                { XARM_SET_VALUE(XmNselectionArrayCount); }
   int selectionArrayCount() const                  { XARM_GET_VALUE(int, XmNselectionArrayCount); }
   void selectThreshold(int val)                    { XARM_SET_VALUE(XmNselectThreshold); }
   int selectThreshold() const                      { XARM_GET_VALUE(int, XmNselectThreshold); }
   void source(XmTextSource val)                    { XARM_SET_VALUE(XmNsource); }
   XmTextSource source() const                      { XARM_GET_VALUE(XmTextSource, XmNsource); }
   void topCharacter(XmTextPosition val)            { XARM_SET_VALUE(XmNtopCharacter); }
   XmTextPosition topCharacter() const { XARM_GET_VALUE(XmTextPosition, XmNtopCharacter); }
   void value(const _XtString val)                  { XARM_SET_VALUE(XmNvalue); }
   _XtString value() const                          { XARM_GET_VALUE(_XtString, XmNvalue); }
   void valueWcs(const wchar_t *val)                { XARM_SET_VALUE(XmNvalueWcs); }
   wchar_t *valueWcs() const                        { XARM_GET_VALUE(wchar_t *, XmNvalueWcs); }
   void verifyBell(Boolean val)                     { XARM_SET_VALUE(XmNverifyBell); }
   Boolean verifyBell() const                       { XARM_GET_VALUE(Boolean, XmNverifyBell); }
   void wordWrap(Boolean val)                       { XARM_SET_VALUE(XmNwordWrap); }
   Boolean wordWrap() const                         { XARM_GET_VALUE(Boolean, XmNwordWrap); }
};

class ScrolledTextClass : public TextClass {
 protected:
   ScrolledTextClass() {}
 public:
   void scrollHorizontal(Boolean val) { XARM_SET_VALUE(XmNscrollHorizontal); }
   Boolean scrollHorizontal() const   { XARM_GET_VALUE(Boolean, XmNscrollHorizontal); }
   void scrollLeftSide(Boolean val)   { XARM_SET_VALUE(XmNscrollLeftSide); }
   Boolean scrollLeftSide() const     { XARM_GET_VALUE(Boolean, XmNscrollLeftSide); }
   void scrollTopSide(Boolean val)    { XARM_SET_VALUE(XmNscrollTopSide); }
   Boolean scrollTopSide() const      { XARM_GET_VALUE(Boolean, XmNscrollTopSide); }
   void scrollVertical(Boolean val)   { XARM_SET_VALUE(XmNscrollVertical); }
   Boolean scrollVertical() const     { XARM_GET_VALUE(Boolean, XmNscrollVertical); }
};

typedef XarmRawWidget<TextClass, true>                                Text;
typedef XarmFuncWidget<ScrolledTextClass, XmCreateScrolledText, true> ScrolledText;

#endif
