/*
 Copyright (C) 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_xarmcaption_h)
#define xarm_xarmcaption_h

#include <Xarm/Xarm.h>
#include <Xarm/Manager.h>

#ifdef XARM_HAS_XBAE

#include <Xbae/Caption.h>

#ifndef Alignment
typedef unsigned char Alignment;
#endif

class CaptionClass : public ManagerClass {

  protected:

    CaptionClass() {}

    virtual WidgetClass classPointer() { return xbaeCaptionWidgetClass; }
    virtual _XtString   className()    { return (_XtString) "XbaeCaption"; }

  public:

    /* Resources */

    void                fontList(const XmFontList val)         { XARM_SET_VALUE(XmNfontList); }
    XmFontList          fontList() const                       { XARM_GET_VALUE(XmFontList, XmNfontList); }
    void                labelAlignment(XbaeLabelAlignment val) { XARM_SET_VALUE(XmNlabelAlignment); }
    XbaeLabelAlignment  labelAlignment() const                { XARM_GET_VALUE(XbaeLabelAlignment, XmNlabelAlignment); }
    void                labelOffset(int val)                   { XARM_SET_VALUE(XmNlabelOffset); }
    int                 labelOffset() const                    { XARM_GET_VALUE(int, XmNlabelOffset); }
    void                labelPixmap(Pixmap val)                { XARM_SET_VALUE(XmNlabelPixmap); }
    Pixmap              labelPixmap() const                    { XARM_GET_VALUE(Pixmap, XmNlabelPixmap); }
    void                labelPosition(XbaeLabelPosition val)   { XARM_SET_VALUE(XmNlabelPosition); }
    XbaeLabelPosition   labelPosition() const                  { XARM_GET_VALUE(XbaeLabelPosition, XmNlabelPosition); }
    void                labelString(const char *str)           { XARM_SET_STRING(XmNlabelString); }
    char *              labelString() const                    { XARM_GET_STRING(XmNlabelString); }
    void                labelTextAlignment(Alignment val)      { XARM_SET_VALUE(XmNlabelTextAlignment); }
    Alignment           labelTextAlignment() const             { XARM_GET_VALUE(Alignment, XmNlabelTextAlignment); }
    void                labelType(unsigned char val)           { XARM_SET_VALUE(XmNlabelType); }
    unsigned char       labelType() const                      { XARM_GET_VALUE(unsigned char, XmNlabelType); }

};

typedef XarmRawWidget<CaptionClass, false> Caption;

#endif // XARM_HAS_XBAE

#endif // xarm_xarmcaption_h
