/* $Id: RootW.c,v 1.1.1.1 2001/04/09 13:37:04 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xmext/RootWP.h>

#define Unused(x) (void)(x)
static void realize(Widget w,
                    XtValueMask *value_mask,
                    XSetWindowAttributes *attributes);

/* No new resources to set for the Root Window Class */

/* Class record */
XmRootWindowClassRec xmRootWindowClassRec = {
   /* Core class part */
   {
      (WidgetClass) &widgetClassRec,          /* superclass */
      "XmRootWindow",                         /* class_name */
      sizeof(XmRootWindowRec),                /* widget_size */
      NULL,                                   /* class_initialize */
      NULL,                                   /* class_part_initialize */
      FALSE,                                  /* class_inited */
      NULL,                                   /* initialize */
      NULL,                                   /* initialize_hook */
      realize,                                /* realize */
      NULL,                                   /* actions */
      0,                                      /* num_actions */
      NULL,                                   /* resources */
      0,                                      /* num_resources */
      NULLQUARK,                              /* xrm_class */
      TRUE,                                   /* compress_motion */
      XtExposeCompressMultiple,               /* compress_exposure */
      TRUE,                                   /* compress_enterleave */
      FALSE,                                  /* visible_interest */
      NULL,                                   /* destroy */
      NULL,                                   /* resize */
      NULL,                                   /* expose */
      NULL,                                   /* set_values */
      NULL,                                   /* set_values_hook */
      XtInheritSetValuesAlmost,               /* set_values_almost */
      NULL,                                   /* get_values_hook */
      NULL,                                   /* accept_focus */
      XtVersion,                              /* version */
      NULL,                                   /* callback offsets */
      NULL,                                   /* tm_table */
      XtInheritQueryGeometry,                 /* query_geometry */
      XtInheritDisplayAccelerator,            /* display_accelerator */
      NULL                                    /* extension */ 
   },
   /* XmRootWindow class part */
   {
      NULL                                    /* extension */
   }
};

WidgetClass xmRootWindowWidgetClass = (WidgetClass) &xmRootWindowClassRec;

/* realize sets the active page & tab if not null */
static void 
realize(Widget w,
        XtValueMask *value_mask,
        XSetWindowAttributes *attributes)
{
   Screen *screen = XtScreen(w);
   w->core.window = RootWindowOfScreen(screen);

   Unused(w);
   Unused(value_mask);
   Unused(attributes);
}

Widget
XmCreateRootWindow(Widget parent, _XtString name, ArgList arglist,
                   Cardinal cnt)
{
   return XtCreateWidget(name,
                         xmRootWindowWidgetClass,
                         parent,
                         arglist,
                         cnt);
}

