/****************************************************************************/
/*   xmUsrDlg.C                                                             */
/****************************************************************************/
/*                                                                          */
/*   Copyright (c) 1992, 1993, 1994 Bernhard Strassl                        */
/*       Vienna User Interface Group                                        */
/*       Institute for Applied Computer Science and Information Systems     */
/*       University of Vienna, Austria                                      */
/*                                                                          */
/*   See file COPYRIGHT in this directory for details. If this file is      */
/*   missing please mail to xmplus@ani.univie.ac.at                         */
/****************************************************************************/

#include <stdarg.h>
#include <strstream.h>
#include <stream.h>

#include "xmObject.h"

extern "C"
{
void XtMoveWidget(Widget, int, int);
void XtResizeWidget(Widget, int, int, int);
void XtConfigureWidget(Widget, int, int, int, int, int);
#if !defined( HP ) && !defined( SGI )
int getpid();
#endif
void kill(int, int);
}

void _register_combo(XmComboBox*, bool);

#undef display
#undef screen
#undef mainWindow

#ifndef XAW
#define XmSDCS XmSTRING_DEFAULT_CHARSET
#endif

#define _freeStringList(x) \
	if(x) \
	{	for(	int _freeStringListIt = 0; \
			x[_freeStringListIt]; \
			_freeStringListIt++) \
			XtFree(x[_freeStringListIt]); \
		delete x; \
	} \
	x = NULL;

extern "C"
{
#include "xgif.h"
}
#include "default_bitmap"

char* XmImageDir = "./";
char* bmp_file_errors[] = { "open failed" , "invalid data", "no memory" };

Pixmap _createXmPixmap(char* wname, int w, int h)
{
	char* fname = new char[strlen(XmImageDir) + strlen(wname) + 1];
	Pixmap aBitmap, aPixmap = (Pixmap )NULL;
	unsigned int bmw, bmh;
	int rc;
	Display* d = App->getDisplay();

	if(w || h)
	{	if(!(w && h))
		{	cerr << "Bitmap error: invalid parameters, using default...\n";
			wname = default_bitmap_bits;
			w = default_bitmap_width;
			h = default_bitmap_height;
		}
		aPixmap = XCreatePixmapFromBitmapData(d, RootWindow(d, 0), wname, w, h, BlackPixel(d, 0), WhitePixel(d, 0), DefaultDepth(d, 0));
	}
	else
	{	strcpy(fname, XmImageDir);
		strcat(fname, wname);
		if(strstr(wname, ".gif"))
		{	theDisp = d;
			LoadGIF(fname);
			if(!loadOk || DefaultDepth(d, 0) != 8)
			{	cerr << "using default...\n";
				aPixmap = XCreatePixmapFromBitmapData(d, RootWindow(d, 0), default_bitmap_bits, default_bitmap_width, default_bitmap_height, BlackPixel(d, 0), WhitePixel(d, 0), DefaultDepth(d, 0));
			}
			else
			{	GC gc;
				int imgWidth = theImage->width;
				int imgHeight = theImage->height;
				aPixmap = XCreatePixmap(d, RootWindow(d, 0), imgWidth, imgHeight, DefaultDepth(d, 0));
#ifdef NO_GCSTRUCT_CAST
				gc = XCreateGC(d, aPixmap, (unsigned long )NULL, (XGCValues* )NULL);
#else
				gc = XCreateGC(d, aPixmap, (unsigned long )NULL, (struct XGCValues* )NULL);
#endif
				XPutImage(d, aPixmap, gc, theImage , 0, 0, 0, 0, imgWidth, imgHeight);
				XDestroyImage(theImage);
				XFreeGC(d, gc);
			}
		}
		else
		{	if((rc = XReadBitmapFile(d, RootWindow(d, 0), fname, &bmw, &bmh, &aBitmap, NULL, NULL)) != BitmapSuccess)
			{	cerr << "Bitmap file error: " << bmp_file_errors[rc - 1] << ", using default...\n";
				aPixmap = XCreatePixmapFromBitmapData(d, RootWindow(d, 0), default_bitmap_bits, default_bitmap_width, default_bitmap_height, BlackPixel(d, 0), WhitePixel(d, 0), DefaultDepth(d, 0));
			}
			else
			{	GC gc;
				aPixmap = XCreatePixmap(d, RootWindow(d, 0), bmw, bmh, DefaultDepth(d, 0));
#ifdef NO_GCSTRUCT_CAST
				gc = XCreateGC(d, aPixmap, (unsigned long )NULL, (XGCValues* )NULL);
#else
				gc = XCreateGC(d, aPixmap, (unsigned long )NULL, (struct XGCValues* )NULL);
#endif
				XCopyPlane(d, aBitmap, aPixmap, gc, 0, 0, bmw, bmh, 0, 0, 1);
				XFreePixmap(d, aBitmap);
				XFreeGC(d, gc);
			}
		}
	}
	delete fname;
	return(aPixmap);
}

#ifdef XAW
extern "C" {
#include <Form.h>
}
#else
#include <BulletinB.h>
#include <Form.h>
#endif

extern void genericCallback(Widget, XtPointer, XtPointer);

XmDialogPane::~XmDialogPane()
{
	for(int i = 0; i < controlCount; i++)
	{	controls[i]->resetParent();
		delete controls[i];
	}
}

void XmDialogPane::getFocus(Widget)
{
}

int XmDialogPane::controlIndex(XmControl* aControl)
{
	for(int i = 0; i < controlCount; i++)
	{	if(controls[i] == aControl)
			return(i);
	}
	return(-1);
}

XmControl* XmDialogPane::findControl(ctrlType t, char* n, bool warn)
{
	ctrlType ct;

	for(int i = 0; i < controlCount; i++)
	{	ct = controls[i]->controlType();
		if(!strcmp(controls[i]->wname, n))
		{	if(ct == t)
				return(controls[i]);
			cerr << "class xmDialogPane: Error - invalid control type for " << n << " !\n";
			return(NULL);
		}
		XmControl* aControl;
		if(((ct == GroupBox || ct == PaneArea) && (aControl = ((XmGroupBox* )controls[i])->findControl(t, n, FALSE))) ||
			(ct == Pane && (aControl = ((XmPane* )controls[i])->getControl(t, n))))
			return(aControl);
	}
	if(warn)	// explain the following core dump...
		cerr << "class xmDialogPane: Error - control with name " << n << " not found !\n";
	return(NULL);
}

XmGroupBox* XmDialogPane::nextGroup(int& ndx)
{
	while(ndx < controlCount)
	{	if(controls[ndx]->controlType() == GroupBox)
			return((XmGroupBox* )controls[ndx++]);
		ndx++;
	}
	return(NULL);
}

bool XmDialogPane::add(XmControl* aControl, XmObject* rec, cbProc code, void* cl_data)
{
	XmGroupBox* g;
	int ndx = 0;

	while(g = nextGroup(ndx))
	{	if(g->parentFor(aControl))
			break;
	}
	if(g)
		return(g->addAbs(aControl, rec, code, cl_data));
	else
	{	if(!aControl->isA(Pane) && !aControl->isA(PaneArea) && !aControl->isA(ToolBar))
#ifdef XAW
		{	aControl->addArg(XtNleft, XtChainLeft);
			aControl->addArg(XtNright, XtChainLeft);
			aControl->addArg(XtNtop, XtChainTop);
			aControl->addArg(XtNbottom, XtChainTop);
			aControl->addArg(XtNhorizDistance, aControl->cx);
			aControl->addArg(XtNvertDistance, aControl->cy);
		}
#else
		{	aControl->addArg(XmNleftAttachment, XmATTACH_NONE);
			aControl->addArg(XmNrightAttachment, XmATTACH_NONE);
			aControl->addArg(XmNtopAttachment, XmATTACH_NONE);
			aControl->addArg(XmNbottomAttachment, XmATTACH_NONE);
			aControl->addArg(XmNresizable, FALSE);
		}
#endif
		if(aControl->createControl(this))
			controls[controlCount++] = (XmControl* )aControl->getBase();
		else
			return(FALSE);
		if(aControl->isA(RadioButton))
		{	XmRadioButton* r = (XmRadioButton* )aControl;
			if(curRadio)
				curRadio->chainTo(r);
			curRadio = r;
		}
		if(rec && validProc(code))
			aControl->setCallback(NULL, rec, code, TRUE, cl_data);
	}
	return(TRUE);
}

bool XmDialogPane::removeControl(int ndx)
{
	if(ndx < 0 || ndx >= controlCount || !controls[ndx]->destroy())
		return(FALSE);
	controls[ndx]->resetParent();
	controlCount--;
	int i = ndx;
	while(i < controlCount)
	{	controls[i] = controls[i + 1];
		i++;
	}
	return(TRUE);
}

bool XmDialogPane::remove(char* n)
{
	int ndx = -1;

	for(int i = 0; i < controlCount; i++)
	{	if(!strcmp(controls[i]->wname, n))
		{	ndx = i;
			break;
		}
	}
	return(removeControl(i));
}

XmControl* XmDialogPane::find(char* n)
{
	for(int i = 0; i < controlCount; i++)
	{	if(!strcmp(controls[i]->wname, n))
			return(controls[i]);
	}
	return(NULL);
}


// Base class for user defined dialogs //////////////////////////


XmUserDialog::XmUserDialog(char* n, XmObject* par, xmStyle s) : XmDialog(n, par, s)
{
	initDialog(n, par, s);
}

XmUserDialog::XmUserDialog(char* n, XmObject* par, XmManager* mgr, xmStyle s) : XmDialog(n, par, s)
{
	manager = mgr;
	manager->addObject(this, DialogWindow);
	initDialog(n, par, s);
}

XmUserDialog::~XmUserDialog()
{
	if(manager)
		manager->removeObject(this);
#ifdef XAW
	parent = NULL;		// be sure to destroy the parent widget....!
#endif
}

#ifndef XAW
#include <Frame.h>
#endif

void XmUserDialog::initDialog(char* n, XmObject* par, xmStyle s)
{
	ix = iy = iw = ih = 0;
#ifdef __OLDGNU__
	delete wname;	// when using gcc only the default constr 
	delete cdptrs;	// of XmObject is called. so let's do it
	init(n, par);	// once more...
#endif
	basePtr = (XmObject* )((void* )this);		// override the base pointer !
//	debugPtr = basePtr;
#ifdef XAW
	addArg(XtNdefaultDistance, 0);
#else
	addArg(XmNunitType, App->getScreenUnitType());
	addArg(XmNhorizontalSpacing, 0);
	addArg(XmNverticalSpacing, 0);
	addArg(XmNrubberPositioning, TRUE);
	addArg(XmNresizePolicy, XmRESIZE_NONE);		// default...
#endif
	Widget aShell;
	if(par && s & XmSpopup)
	{	aShell = XtVaCreateWidget(n, overrideShellWidgetClass, par->handle(),
				XtNwidth, 100, XtNheight, 100,
				XtNallowShellResize, TRUE, NULL);
#ifdef XAW
		XtManageChild(wid = XtCreateWidget(n, formWidgetClass, aShell, wargs, wargcount));
#else
		addArg(XmNmarginWidth, 0);
		addArg(XmNmarginHeight, 0);
		XtManageChild(wid = XmCreateFrame(aShell, n, wargs, wargcount));
#endif
		wargcount = 0;
	}
#ifdef XAW
	else if(FALSE && par)	// unsolved transient shell problem...
	{	char tmpstrbuf[1024];
		ostrstream shName(tmpstrbuf, 1024);
		shName << n << "-shell"; shName.put('\0');
		aShell = XtVaCreateWidget(shName.str(), transientShellWidgetClass, par->handle(), XtNtransientFor, par->handle(), NULL);
		XtManageChild(wid = XtCreateWidget(n, formWidgetClass, aShell, wargs, wargcount));
	}
#else
	else if(par)
	{	addArg(XmNautoUnmanage, FALSE);
// args block added 941110
#ifndef LINUX
		addArg(XmNallowOverlap, TRUE);
		addArg(XmNmarginWidth, 0);
		addArg(XmNmarginHeight, 0);
		addArg(XmNhorizontalSpacing, 0);
		addArg(XmNverticalSpacing, 0);
		addArg(XmNrubberPositioning, FALSE); // TRUE);
		addArg(XmNresizePolicy, XmRESIZE_NONE);
#endif
		wid = XmCreateFormDialog(par->handle(), n, wargs, wargcount);
		if(s)
		{	long func, decor;

			dlgStyle = s;
			translateWindowStyles(s, func, decor);
			addArg(XmNtransient, FALSE);
			if(func)
				addArg(XmNmwmFunctions, func);
			if(decor)
				addArg(XmNmwmDecorations, decor);
			XtSetValues(XtParent(wid), wargs, wargcount);
		}
	}
#endif
	else
	{	aShell = App->newMainWindow(this, n, 0, 0, s);
#ifdef XAW
		XtManageChild(wid = XtCreateWidget(n, formWidgetClass, aShell, wargs, wargcount));
#else
		XtManageChild(wid = XmCreateForm(aShell, n, wargs, wargcount));
		wargcount = 0;
		// these values seem to be ignored by this @*^! dialog...
#ifndef LINUX
		addArg(XmNallowOverlap, TRUE);	// 941110
		addArg(XmNmarginWidth, 0);	// 941110
		addArg(XmNmarginHeight, 0);	// 941110
		addArg(XmNhorizontalSpacing, 0);
		addArg(XmNverticalSpacing, 0);
		addArg(XmNrubberPositioning, FALSE);	// TRUE); // 941110
#endif
		addArg(XmNresizePolicy, XmRESIZE_NONE);		// default...
		XtSetValues(wid, wargs, wargcount);
#endif
	}
	wargcount = 0;
#ifdef XAW
	setCallback(XtNdestroyCallback, this, CBK(XmUserDialog, destroyCb), TRUE, CB_XM_HANDLE);
#else
	setCallback(XmNfocusCallback, this, CBK(XmUserDialog, getFocusCb), TRUE, CB_XM_HANDLE);
	setCallback(XmNdestroyCallback, this, CBK(XmUserDialog, destroyCb), TRUE, CB_XM_HANDLE);
	XmAddTabGroup(wid);
#endif
	setLabelAndMode(n);
	destroyOnDelete();
}

void XmUserDialog::getFocusCb(void* w)
{
	getFocus((Widget )w);
}

void XmUserDialog::destroyCb(void* w)
{
	if(magic == MAGIC_OBJECT_CONST && wid == (Widget )w)
	{	wid = NULL;
		delete this;
	}
}

bool XmUserDialog::run(char*, char*)
{
// run modal, args are confirm and cancel control
	return(FALSE);
}

bool XmUserDialog::realize()
{
	if(wid)
	{	int x = 0, y = 0, w = 0, h = 0;
		if(initWindowSize(x, y, w, h))
		{	ix += x; iy += y; iw += w; ih += h;
		}
		if(ix || iy || iw || ih)
		{	if(ix) addArg(XtNx, ix);
			if(iy) addArg(XtNy, iy);
			if(iw) addArg(XtNwidth, iw);
			if(ih) addArg(XtNheight, ih);
#ifdef XAW
			XtSetValues(XtParent(wid), wargs, wargcount);
			XtRealizeWidget(XtParent(wid));
			wargcount = 0;
		}
#else
			XtSetValues(parent ? wid : XtParent(wid), wargs, wargcount);
			wargcount = 0;
		}
		if(parent)
		{	if(dlgStyle & XmSpopup)
				XtPopup(XtParent(wid), XtGrabNone);
			XtManageChild(wid);				// manage a form dialog...
		}
		else
			XtRealizeWidget(XtParent(wid));			// realize an app shell...
#endif
		return(TRUE);
	}
	return(FALSE);
}

bool XmUserDialog::hide()
{
	if(!wid)
		return(FALSE);
	if(dlgStyle & XmSpopup)
	{	XtPopdown(XtParent(wid));
		return(TRUE);
	}
	return(XmObject::hide());
}

bool XmUserDialog::show()
{
	if(!wid)
		return(FALSE);
	if(dlgStyle & XmSpopup)
	{	XtPopup(XtParent(wid), XtGrabNone);
		return(TRUE);
	}
	return(XmObject::show());
}

bool XmUserDialog::setLabel(char* txt)
{
	Arg a;

	if(!wid)
		return(FALSE);
#ifdef XAW
	XtSetArg(a, XtNlabel, txt);
#else
	XtSetArg(a, XmNtitle, txt);
#endif
	XtSetValues(XtParent(wid), &a, 1);
	return(TRUE);
}

bool XmUserDialog::setFocus(char*)			{ return(FALSE); }

bool XmUserDialog::setDefaultButton(char* bName)
{
#ifndef XAW
	XmControl* aControl = find(bName);

	if(aControl && aControl->controlType() == PushButton && wid && aControl->handle())
	{	forceArg(XmNdefaultButton, (XtArgVal )aControl->handle());
		return(TRUE);
	}
#endif
	return(FALSE); 
}

#define do_single_arg(func) \
	XmControl* aControl; \
	if(aControl = find(first)) \
		aControl-> func (); \
	return(aControl ? TRUE : FALSE);

#define do_varargs(func) \
	char* aName = first; \
	XmControl* aControl; \
	va_list ap; \
	va_start(ap, first); \
	do \
	{	if(aControl = find(aName)) \
			aControl-> func (); \
	} \
	while((aName = va_arg(ap, char *)) != (char *)0); \
	va_end(ap); \
	return(TRUE);

#define do_ptrs(func) \
	char* aName = *list; \
	XmControl* aControl; \
	while(aName = *list++) \
	{	if(aControl = find(aName)) \
			aControl-> func (); \
	} \
	return(TRUE);

bool XmDialogPane::disable(char** list)
{
	do_ptrs( disable )
}

bool XmDialogPane::disable(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( disable )
#else
	do_single_arg( disable )
#endif
}

bool XmDialogPane::enable(char** list)
{
	do_ptrs( enable )
}

bool XmDialogPane::enable(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( enable )
#else
	do_single_arg( enable )
#endif
}

bool XmDialogPane::hideAll(char** list)
{
	do_ptrs( hide )
}

bool XmDialogPane::hideAll(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( hide )
#else
	do_single_arg( hide )
#endif
}

bool XmDialogPane::showAll(char** list)
{
	do_ptrs( show )
}

bool XmDialogPane::showAll(char* first, ...)
{
#ifndef NO_VARARGS
	do_varargs( show )
#else
	do_single_arg( show )
#endif
}

// Controls /////////////////////////////////////////////

XmControl::XmControl(char* n, int x, int y, int w, int h, xmStyle s) : XmObject(n, (XmObject* )NULL)
{
	cx = x; cy = y; cw = w; ch = h;
	style = s;
#ifndef XAW
	addArg(XmNunitType, App->getScreenUnitType());
#endif
	long lx = 0, ly = 0, lw = 0, lh = 0;
	lx = x; ly = y; lw = w; lh = h;

	if(x)
		addArg(XtNx, (XtArgVal )lx);
	if(y)
		addArg(XtNy, (XtArgVal )ly);
	if(w)
		addArg(XtNwidth, (XtArgVal )lw);
	if(h)
		addArg(XtNheight, (XtArgVal )lh);
}

XmControl::~XmControl()
{
	if(parent && parent->asDialogPane())
		parent->asDialogPane()->remove(this);
}

bool XmControl::setCbFor(Widget w, char* cbName, XmObject* rec, cbProc code, bool sr, void* cl_data)
{
	if(!rec || !(cbName || defaultCallback()))
	{	cerr << "xmControl: " << wname << " - invalid callback parameters, ignoring request...\n";
		return(FALSE);
	}
	if(!cbName)
		cbName = defaultCallback();
	if(hookedCb() && !strcmp(cbName, hookedCb()) && rec != this)
	{	userData.receiver = rec->getBase();
		userData.callback = code;
		userData.client_data = (cl_data == CB_OBJ_PTR) ? this : cl_data;
	}
	else 
		XmObject::setCbFor(w, cbName, rec, code, sr, (cl_data == CB_OBJ_PTR) ? this : cl_data);
	return(TRUE);
}

void XmControl::makeRelativeTo(XmGroupBox* aGroup)
{
	cx -= aGroup->cx;
	cy -= aGroup->cy;
	if(cx >= 0)
		changeArg(XtNx, cx);
	if(cy >= 0)
		changeArg(XtNy, cy);
}

void XmControl::initTabstop(bool force)
{
#ifndef XAW
	if(wid && (style & XmStabStop || force))
		XmAddTabGroup(wid);
#endif
}

char* _control_current_label_buffer = NULL;

char* XmControl::currentLabel()
{
	char* aStr = wname;
	int argNdx;

	XtFree(_control_current_label_buffer);
	_control_current_label_buffer = NULL;

#ifdef XAW
	if((argNdx = argIndex(XtNlabel)) != -1)
	{	aStr = new char[strlen((const char* )wargs[argNdx].value) + 1];
		strcpy(aStr, (const char* )wargs[argNdx].value);
	}
#else
	if((argNdx = argIndex(XmNlabelString)) != -1)
	{	XmString xStr;
		xStr = (XmString )wargs[argNdx].value;
		// aStr = new char[XmStringLength(xStr)]; // Motif documentation bug !!!
		if(!XmStringGetLtoR(xStr, XmSDCS, &aStr))
			cerr << "xmControl: Error - something wrong with string arguments...\n";
		XmStringFree(xStr);
	}
#endif
	_control_current_label_buffer = aStr;
	return(aStr);
}

void XmControl::setLabelAndMnemonic()
{
	char mm = 0;
		
#ifdef XAW
	if(!hasArg(XtNbitmap))
	{	if(hasArg(XtNlabel))
#else
	if(!hasArg(XmNlabelPixmap))
	{	if(hasArg(XmNlabelString))
#endif
		{	char* aStr = currentLabel();
			// answers temporary allocated string, should work as long as
			// this function is called only from createControl methods...
			mm = parse(aStr);
#ifdef XAW
			changeArg(XtNlabel, aStr);
#else
			changeArg(XmNlabelString, (XtArgVal )XmStringCreateLtoR(aStr, XmSDCS));
#endif
		}
		else
		{	if(strchr(wname, '&'))
				mm = parse(wname);				// wname is also an allocated string...
			if(checkResource("labelString"))
				mm = 0;
		}
#ifndef XAW
		if(mm)
			addArg(XmNmnemonic, mm);
#endif
	}
}

XmUserDialog* XmControl::getDialog()
{
	return(parent->asDialog());
}

bool XmControl::move(int nx, int ny)
{
	cx = nx;
	cy = ny;
	if(wid)
		return(XmObject::move(cx, cy));
	else
	{	changeArg(XtNx, cx);
		changeArg(XtNy, cy);
	}
	return(TRUE);
}

bool XmControl::resize(int nw, int nh)
{
	cw = nw;
	ch = nh;
	if(wid)
		return(XmObject::resize(cw, ch));
	else
	{	changeArg(XtNwidth, cw);
		changeArg(XtNheight, ch);
	}
	return(TRUE);
}

bool XmControl::reframe(int nx, int ny, int nw, int nh)
{
	cx = nx;
	cy = ny;
	cw = nw;
	ch = nh;
	if(wid)
		return(XmObject::reframe(cx, cy, cw, ch));
	else
	{	changeArg(XtNx, cx);
		changeArg(XtNy, cy);
		changeArg(XtNwidth, cw);
		changeArg(XtNheight, ch);
	}
	return(TRUE);
}

bool XmControl::getFrame(int& fx, int& fy, int& fw, int& fh)
{
	if(wid)
		return(XmObject::getFrame(fx, fy, fw, fh));
	else
	{	fx = cx;
		fy = cy;
		fw = cw;
		fh = ch;
	}
	return(TRUE);
}

bool XmControl::updateDimensions()
{
	if(wid)
	{	Arg a[4];
		XtSetArg(a[0], XtNx, (XtArgVal )&cx);
		XtSetArg(a[1], XtNy, (XtArgVal )&cy);
		XtSetArg(a[2], XtNwidth, (XtArgVal )&cw);
		XtSetArg(a[3], XtNheight, (XtArgVal )&ch);
		XtGetValues(wid, a, 4);
		return(TRUE);
	}
	return(FALSE);
}

XmControl* XmControl::setText(char* aStr)
{
	if(wid)
	{	char mm = parse(aStr);
#ifndef XAW
		if(mm)	// no resource check, so only done after widget creation...
			addArg(XmNmnemonic, mm);
#endif
	}
#ifdef XAW
	addArg(XtNlabel, (XtArgVal )aStr);
#else
	addArg(XmNlabelString, (XtArgVal )XmStringCreateLtoR(aStr, XmSDCS));
#endif
	if(wid)
	{	XtSetValues(wid, wargs, wargcount);
		wargcount = 0;
	}
	return(this);
}

XmControl* XmControl::setFont(char* aStr)
{
	XFontStruct* font;

	if(!(font = XLoadQueryFont(App->getDisplay(), aStr)))
		cerr << "xmControl: unable to load font '" << aStr << "', using default.\n";
#ifdef XAW
	addArg(XtNfont, (XtArgVal )font);
#else
	addArg(XmNfontList, (XtArgVal )XmFontListCreate(font, XmSDCS));
#endif
	if(wid)
	{	XtSetValues(wid, wargs, wargcount);
		wargcount = 0;
	}
	return(this);
}

char* _control_get_text_buffer = NULL;

char* XmControl::getText()
{
	if(!wid)
		return(wname ? wname : "");

	XtFree(_control_get_text_buffer);
	_control_get_text_buffer = NULL;

	char* curTxt = NULL;
	Arg a;
#ifdef XAW
	XtSetArg(a, XtNlabel, &curTxt);
#else
	XmString tmpTxt;
	XtSetArg(a, XmNlabelString, &tmpTxt);
#endif
	XtGetValues(wid, &a, 1);
#ifndef XAW
	// _control_get_text_buffer = new char[XmStringLength(tmpTxt) + 1];
	if(XmStringGetLtoR(tmpTxt, XmSDCS, &_control_get_text_buffer))
		curTxt = _control_get_text_buffer;
#endif
	return(curTxt);
}

XmControl* XmControl::setImage(Pixmap aPixmap)
{
#ifdef XAW
	addArg(XtNbitmap, aPixmap);
#else
	addArg(XmNlabelType, XmPIXMAP);
	addArg(XmNlabelPixmap, (XtArgVal )aPixmap);
	addArg(XmNlabelInsensitivePixmap, (XtArgVal )aPixmap);	// missing: create a grayed copy...
#endif
	if(wid)
	{	Arg a;
		Pixmap oldImg = 0L;
#ifdef XAW
		XtSetArg(a, XtNbitmap, &oldImg);
#else
		XtSetArg(a, XmNlabelPixmap, &oldImg);
#endif
		XtGetValues(wid, &a, 1);
#ifdef XAW
		if(oldImg)
#else
		if(oldImg && oldImg != XmUNSPECIFIED_PIXMAP)
#endif
			XFreePixmap(App->getDisplay(), oldImg);
		XtSetValues(wid, wargs, wargcount);
		wargcount = 0;
	}
	return(this);
}

XmControl* XmControl::setFocus()
{
	XEvent e;
#ifndef XAW
	if(wid)
	{	// XtCallActionProc(XtParent(wid), "ManagerFocusOut", &e, NULL, 0);
		// XtCallActionProc(wid, "PrimitiveFocusIn", &e, NULL, 0);
		XmProcessTraversal(wid, XmTRAVERSE_CURRENT);
 	}
#endif
	return(this);
}

XmControl* XmControl::disable()
{
#ifdef XAW
	addArg(XtNsensitive, FALSE);
#else
	addArg(XmNsensitive, FALSE);
#endif
	if(wid)
	{	XtSetValues(wid, wargs, wargcount);
		wargcount = 0;
	}
	return(this);
}

XmControl* XmControl::enable()
{
#ifdef XAW
	addArg(XtNsensitive, TRUE);
#else
	addArg(XmNsensitive, TRUE);
#endif
	if(wid)
	{	XtSetValues(wid, wargs, wargcount);
		wargcount = 0;
	}
	return(this);
}

#ifdef XAW
extern "C" {
#include <Form.h>
#include <Label.h>
#include <Simple.h>
}
#else
#include <BulletinB.h>
#include <LabelG.h>
#endif

bool XmGroupBox::createControl(XmControlPane* par)
{
	int lNdx;

//	debugPtr = basePtr;
	parent = par->asObject();
#ifdef XAW
	addArg(XtNdefaultDistance, 0);
	if(controlType() == ComboBox)
		addArg(XtNborderWidth, 0);
	XtManageChild(wid = XtCreateWidget(wname, formWidgetClass, par->handle(), wargs, wargcount));
	if((lNdx = argIndex(XtNlabel)) != -1 || checkResource("group-label.labelString"))
#else
/*
	addArg(XmNautoUnmanage, FALSE);
	addArg(XmNdefaultPosition, FALSE);
	addArg(XmNresizePolicy, XmRESIZE_NONE);
	addArg(XmNmarginWidth, 1);
	addArg(XmNmarginHeight, 1);
*/
// replaced by the UseDialog args block 941110

	addArg(XmNallowOverlap, TRUE);
	//addArg(XmNmarginWidth, 0);
	//addArg(XmNmarginHeight, 0);
	//addArg(XmNhorizontalSpacing, 0);
	//addArg(XmNverticalSpacing, 0);
	addArg(XmNrubberPositioning, FALSE); // TRUE);
	addArg(XmNresizePolicy, XmRESIZE_NONE);

	if(controlType() != ComboBox)
	{	addArg(XmNshadowThickness, 3);
		addArg(XmNshadowType, XmSHADOW_ETCHED_IN);
	}
	if(!par->handle())
	{	cerr << "xmGroupBox: internal error - null parent handle.\n";
		kill(getpid(), 2);
	}
	XtManageChild(wid = XmCreateForm(par->handle(), wname, wargs, wargcount));
	if((lNdx = argIndex(XmNlabelString)) != -1 || checkResource("group-label.labelString"))
#endif
	{	wargcount = 0;
		addArg(XtNx, 20);
		addArg(XtNy, 2);
		if(lNdx != -1)
#ifdef XAW
			addArg(XtNlabel, wargs[lNdx].value);
		addArg(XtNborderWidth, 0);
		XtManageChild(XtCreateWidget("group-label", labelWidgetClass, wid, wargs, wargcount));
	}
	wargcount = 0;
	addArg(XtNleft, XtChainLeft);
	addArg(XtNright, XtChainLeft);
	addArg(XtNtop, XtChainTop);
	addArg(XtNbottom, XtChainTop);
	addArg(XtNwidth, 1);
	addArg(XtNheight, 1);
	addArg(XtNx, cw - 1);
	addArg(XtNy, ch - 1);
	addArg(XtNhorizDistance, cw - 1);
	addArg(XtNvertDistance, ch - 1);
	addArg(XtNborderWidth, 0);
	XtManageChild(XtCreateWidget("gb-dummy", simpleWidgetClass, wid, wargs, wargcount));

#else
			addArg(XmNlabelString, wargs[lNdx].value);
		XtManageChild(XmCreateLabelGadget(wid, "group-label", wargs, wargcount));
	}
#endif
	wargcount = 0;
#ifndef XAW
	setCallback(XmNfocusCallback, this, CBK(XmGroupBox, getFocusCb), TRUE, CB_XM_HANDLE);
	initTabstop();
#endif
	return(wid ? TRUE : FALSE);
}

void XmGroupBox::getFocusCb(void* w)
{
	getFocus((Widget )w);
}

bool XmGroupBox::parentFor(XmControl* c)
{
	if(c->cx > cx && c->cx < cx + cw && c->cy > cy && c->cy < cy + ch)
		return(TRUE);
	return(FALSE);
}

bool XmGroupBox::addAbs(XmControl* c, XmObject* rec, cbProc cb, void* cd)	
{
	c->makeRelativeTo(this);
	return(XmDialogPane::add(c, rec, cb, cd));
}

bool XmGroupBox::remove(char* n)
{
	return(XmDialogPane::remove(n));
}

#ifdef XAW
extern "C" {
#include <Form.h>
}
#else
#include <Form.h>
#endif

bool XmPane::createControl(XmControlPane* par)
{
	int lNdx;

	hLabel = NULL;

#ifdef XAW
	addArg(XtNdefaultDistance, 0);
	XtManageChild(wid = XtCreateWidget(wname, formWidgetClass, par->handle(), wargs, wargcount));
	if((lNdx = argIndex(XtNlabel)) != -1)
	{	wargcount = 0;
		addArg(XtNlabel, wargs[lNdx].value);
		XtManageChild(XtCreateWidget("pn-label", labelWidgetClass, wid, wargs, wargcount));
	}
#else
	addArg(XmNautoUnmanage, FALSE);
	XtManageChild(wid = XmCreateForm(par->handle(), wname, wargs, wargcount));
	if((lNdx = argIndex(XmNlabelString)) != -1)
	{	wargcount = 0;
		addArg(XmNlabelString, wargs[lNdx].value);
		addArg(XmNalignment, XmALIGNMENT_CENTER);
		addArg(XmNleftAttachment, XmATTACH_FORM);
		addArg(XmNrightAttachment, XmATTACH_FORM);
		addArg(XmNtopAttachment, XmATTACH_FORM);
		XtManageChild(hLabel = XmCreateLabelGadget(wid, "pn-label", wargs, wargcount));
	}
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmPane::setContents(XmControl* c, XmObject* rec, cbProc cb)	
{
	if(contents)
	{	if(!contents->destroy())
			return(FALSE);
	}
	contents = NULL;
	if(c)
	{	if(!c->createControl(this))
			return(FALSE);
		contents = c;		// (XmControl* )aControl->asObjPtr();
		if(rec && c->defaultCallback())
			c->setCallback(c->defaultCallback(), rec, cb, TRUE, (void* )c);
		c->userData.receiver = (rec) ? rec->getBase() : rec;
		c->userData.callback = cb;
		if(handle() && XtWindow(handle()))
			c->realize();
	}
	return(TRUE);
}

bool XmPane::changeLabel(char* txt)
{
	if(hLabel)
#ifdef XAW
	{	addArg(XtNlabel, (XtArgVal )txt);
#else
	{	addArg(XmNlabelString, (XtArgVal )XmStringCreateLtoR(txt, XmSDCS));
#endif
		XtSetValues(hLabel, wargs, wargcount);
		wargcount = 0;
		return(TRUE);
	}
	return(FALSE);
}


#ifdef XAW
extern "C" {
#include <Paned.h>
}
#else
#include <PanedW.h>
#endif

bool XmPaneArea::createControl(XmControlPane* par)
{
#ifdef XAW
	addArg(XtNborderWidth, 1);
	XtManageChild(wid = XtCreateWidget(wname, panedWidgetClass, par->handle(), wargs, wargcount));
#else
	addArg(XmNborderWidth, 1);
	XtManageChild(wid = XmCreatePanedWindow(par->handle(), wname, wargs, wargcount));
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

void XmPaneArea::changed(void*)
{
}

bool XmPaneArea::add(XmControl* aControl, XmObject* rec, cbProc p, void* cd)
{
	if(XmDialogPane::add(aControl, rec, p, cd))
	{	subPaneCount++;
		return(TRUE);
	}
	return(FALSE);
}

bool XmPaneArea::remove(char* name)
{
	if(!XmDialogPane::remove(name))
	{	char namebuf[100];
		XmPane* aPane;

		strcpy(namebuf, name);
		strcat(namebuf, "Pane");
		if((aPane = (XmPane* )find(namebuf)) && aPane->controlType() == Pane)
		{	if(aPane->setContents(NULL))
			{	XmDialogPane::remove(namebuf);
				delete aPane;
				subPaneCount--;
				return(TRUE);
			}
		}
		cerr << "xmPaneArea: Error - remove " << name << " failed...\n";
		return(FALSE);
	}
	subPaneCount--;
	return(TRUE);
}

bool XmPaneArea::addSubpane(XmControl* aControl, char* title, XmObject* rec, cbProc p)
{
	int nh = aControl->ch ? aControl->ch : (title ? 30 : 10);
	XmPane* aPane;

	if(aControl->controlType() == Edit)
		aControl->changeStyle(aControl->style | XmSmultiLine);	// ensure multi-line...

	if(title)
	{	char namebuf[100];
		strcpy(namebuf, aControl->getName());
		strcat(namebuf, "Pane");
		aPane = new XmPane(namebuf, 0, aControl->cy, cw, nh);
#ifdef XAW
		aPane->addArg(XtNallowResize, TRUE);
		aPane->addArg(XtNmin, nh);
#else
		aPane->addArg(XmNallowResize, TRUE);
		aPane->addArg(XmNpaneMinimum, nh);
#endif
		aPane->setText(title);
		if(add(aPane))
		{	aControl->changeArg(XtNwidth, (aControl->cw = cw - 30));
			aControl->changeArg(XtNheight, (aControl->ch = nh - 20));
#ifdef XAW
			// constraining should go here...
			aPane->forceArg(NULL, (XtArgVal )NULL);
#else
			aControl->addArg(XmNleftAttachment, XmATTACH_POSITION);
			aControl->addArg(XmNleftPosition, 1);
			aControl->addArg(XmNtopAttachment, XmATTACH_WIDGET);
			aControl->addArg(XmNtopWidget, (XtArgVal )aPane->hLabel);
			aControl->addArg(XmNrightAttachment, XmATTACH_POSITION);
			aControl->addArg(XmNrightPosition, 99);
			aControl->addArg(XmNbottomAttachment, XmATTACH_POSITION);
			aControl->addArg(XmNbottomPosition, 98);
			aPane->forceArg(NULL, (XtArgVal )NULL);
#endif
			return(aPane->setContents(aControl, rec, p));
		}
		delete aPane;
		return(FALSE);
	}
	aControl->changeArg(XtNwidth, (aControl->cw = cw));
	aControl->changeArg(XtNheight, (aControl->ch = nh));
#ifdef XAW
	aControl->addArg(XtNallowResize, TRUE);
	aControl->addArg(XtNmin, nh);
#else
	aControl->addArg(XmNallowResize, TRUE);
	aControl->addArg(XmNpaneMinimum, nh);
#endif
	if(add(aControl, rec, p))
#ifdef XAW
	{	aControl->addArg(XtNtop, XtChainTop);
		aControl->addArg(XtNleft, XtChainLeft);
		aControl->addArg(XtNright, XtChainRight);
		aControl->addArg(XtNbottom, XtChainBottom);
		aControl->forceArg(NULL, (XtArgVal )NULL);
#else
	{	aControl->forceArg(NULL, (XtArgVal )NULL);
#endif
		return(TRUE);
	}
	return(FALSE);
}

bool XmPaneArea::changeSubpaneLabel(char* name, char* txt)
{
	char namebuf[100];
	XmPane* aPane;

	strcpy(namebuf, name);
	strcat(namebuf, "Pane");
	if(((aPane = (XmPane* )find(name)) || (aPane = (XmPane* )find(namebuf))) && aPane->controlType() == Pane)
		return(aPane->changeLabel(txt));
	cerr << "xmPaneArea: change label error - no pane " << namebuf << " found (" << hex(long(aPane)) << ")\n";
	return(FALSE);
}


#ifdef XAW
extern "C" {
#include <Box.h>
#include <Label.h>
}
#else
#include <RowColumn.h>
#include <LabelG.h>
#endif

bool XmToolBar::createControl(XmControlPane* par)
{
	addArg(XtNborderWidth, 1);
#ifdef XAW
	addArg(XtNallowResize, TRUE);
	addArg(XtNorientation, (style & XmShorizontal) ? XtorientHorizontal : XtorientVertical);
	XtManageChild(wid = XtCreateManagedWidget(wname, boxWidgetClass, par->handle(), wargs, wargcount));
#else
	addArg(XmNorientation, (style & XmShorizontal) ? XmHORIZONTAL : XmVERTICAL);
	addArg(XmNadjustLast, FALSE);
	addArg(XmNadjustMargin, FALSE);
	if(rows > 1)
	{	addArg(XmNpacking, XmPACK_COLUMN);
		addArg(XmNnumColumns, rows);
	}
	addArg(XmNisAligned, FALSE);
	XtManageChild(wid = XmCreateRowColumn(par->handle(), wname, wargs, wargcount));
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmToolBar::add(XmControl* c, XmObject* rec, cbProc cb, void* cd)	
{
	if(c->isAn(Edit))
		c->changeStyle(c->getStyle() | XmStabStop);
	return(XmGroupBox::add(c, rec, cb, cd));
}

bool XmStatusBar::createControl(XmControlPane* par)
{
#ifdef XAW
	return(FALSE);		// not implemented yet... (use a bottom toolbar instead!)
#else
	addArg(XmNunitType, App->getScreenUnitType());
	addArg(XmNautoUnmanage, FALSE);
	addArg(XmNshadowThickness, 1);
	addArg(XmNhorizontalSpacing, 2);
	addArg(XmNverticalSpacing, 2);
	XtManageChild(wid = XmCreateForm(par->handle(), wname, wargs, wargcount));
	wargcount = 0;
	statusLine = new XmEdit("statusDisplay");
	statusLine->addArg(XmNleftAttachment, XmATTACH_FORM);
	statusLine->addArg(XmNrightAttachment, XmATTACH_FORM);
	statusLine->addArg(XmNtopAttachment, XmATTACH_FORM);
	statusLine->addArg(XmNtopOffset, 10);
	statusLine->addArg(XmNbottomAttachment, XmATTACH_FORM);
	statusLine->addArg(XmNbottomOffset, 10);
	XmGroupBox::add(statusLine);
	statusLine->disable();
	return(wid ? TRUE : FALSE);
#endif
}

bool XmStatusBar::add(XmControl* aControl, XmObject* anObj, cbProc aProc, void* cl_data)
{
	XmControl* lastControl = controls[controlCount - 1];

#ifdef XAW
	;
#else
	aControl->addArg(XmNrightAttachment, XmATTACH_FORM);
	if(aControl->isAn(Edit))
		aControl->changeStyle(aControl->getStyle() | XmStabStop);
	if(XmGroupBox::add(aControl, anObj, aProc, cl_data))
	{	lastControl->addArg(XmNrightAttachment, XmATTACH_WIDGET);
		lastControl->addArg(XmNrightWidget, (XtArgVal )aControl->handle());
		lastControl->forceArg(NULL, (XtArgVal )NULL);
		return(TRUE);
	}
#endif
	return(FALSE);
}

bool XmStatusBar::remove(char* aName)
{
	XmControl* prevControl, * aControl = find(aName);
	int ndx = controlIndex(aControl);

#ifdef XAW
	;
#else
	if(!aControl)
		return(FALSE);
	prevControl = controls[ndx - 1];
	if(XmGroupBox::remove(aName))
	{	if(ndx < controlCount)
			prevControl->addArg(XmNrightWidget, (XtArgVal )controls[ndx]->handle());
		else
			prevControl->addArg(XmNrightAttachment, XmATTACH_FORM);
		prevControl->forceArg(NULL, (XtArgVal )NULL);
		return(TRUE);
	}
#endif
	return(FALSE);
}

bool XmStatusBar::setMessage(char* msg)
{
	return(statusLine ? (statusLine->setText(msg) ? TRUE : FALSE) : FALSE);
}


#ifdef XAW
extern "C" {
#include <Label.h>
}
/*inline*/ XtJustify xmStyle2AwJustify(xmStyle s)
{
	if(s & XmScenter)
		return(XtJustifyCenter);
	if(s & XmSright)
		return(XtJustifyRight);
	return(XtJustifyLeft);
}
#else
#include <Label.h>
#include <LabelG.h>

#define xmStyle2XmAlignment(x) (style & XmSleft ? XmALIGNMENT_BEGINNING : (style & XmSright ? XmALIGNMENT_END : XmALIGNMENT_CENTER))

/* the above works for Motif 1.2, the following doesn't...

#define xmStyle2XmAlignment(x) (style & XmScenter ? XmALIGNMENT_CENTER : (style & XmSright ? XmALIGNMENT_END : XmALIGNMENT_BEGINNING))

 ...any idea why? I hate anon enums!! the last ressort would be...

#define addAlignmentArg(s) \
	if(s & XmScenter) addArg(XmNalignment, XmALIGNMENT_CENTER); \
	else if(s & XmSright) addArg(XmNalignment, XmALIGNMENT_END); \
	else addArg(XmNalignment, XmALIGNMENT_BEGINNING);
*/

#endif


bool XmStaticText::createControl(XmControlPane* par)
{
#ifdef XAW
	addArg(XtNborderWidth, 0);
	addArg(XtNjustify, xmStyle2AwJustify(style));
	XtManageChild(wid = XtCreateWidget(wname, labelWidgetClass, par->handle(), wargs, wargcount));
#else
	addArg(XmNrecomputeSize, cw ? FALSE : TRUE);
	addArg(XmNalignment, xmStyle2XmAlignment(style));
	XtManageChild(wid = (App->windowsForced() ? 
		XmCreateLabel(par->handle(), wname, wargs, wargcount) :
		XmCreateLabelGadget(par->handle(), wname, wargs, wargcount)));
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmStaticImage::createControl(XmControlPane* par)
{
#ifdef XAW
	if(!hasArg(XtNbitmap))
#else
	if(!hasArg(XmNlabelPixmap))
#endif
#ifndef NO_CPP_CONCAT
		setImage(getCompiledImage(default_bitmap));
#else
		setImage(getCompiledImage(default_bitmap_bits, default_bitmap_width, default_bitmap_height));
#endif
#ifdef XAW
	addArg(XtNborderWidth, 0);
	XtManageChild(wid = XtCreateWidget(wname, labelWidgetClass, par->handle(), wargs, wargcount));
#else
	XtManageChild(wid = (App->windowsForced() ? 
		XmCreateLabel(par->handle(), wname, wargs, wargcount) :
		XmCreateLabelGadget(par->handle(), wname, wargs, wargcount)));
#endif
	wargcount = 0;
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

#ifdef XAW
extern "C" {
#include <Command.h>
}
#else
#include <PushB.h>
#include <PushBG.h>
#endif

bool XmPushButton::createControl(XmControlPane* par)
{
	parent = par->asObject();
	setLabelAndMnemonic();
#ifdef XAW
	if(!hasArg(XtNbitmap))
		addArg(XtNjustify, xmStyle2AwJustify(style));
	XtManageChild(wid = XtCreateWidget(wname, commandWidgetClass, par->handle(), wargs, wargcount));
#else
	if(!hasArg(XmNlabelPixmap))
	{	addArg(XmNrecomputeSize, cw ? FALSE : TRUE);
		addArg(XmNalignment, xmStyle2XmAlignment(style));
	}
	XtManageChild(wid = (App->windowsForced() ?
		XmCreatePushButton(par->handle(), wname, wargs, wargcount) :
		XmCreatePushButtonGadget(par->handle(), wname, wargs, wargcount)));
	initTabstop();
#endif
	wargcount = 0;
	return(wid ? TRUE : FALSE);
}

#ifdef XAW
extern "C" {
#include <Toggle.h>
}
#else
#include <ToggleB.h>
#include <ToggleBG.h>
#endif

bool XmCheckBox::createControl(XmControlPane* par)
{
	parent = par->asObject();
	setLabelAndMnemonic();
#ifdef XAW
	if(!hasArg(XtNbitmap))
		addArg(XtNjustify, xmStyle2AwJustify(style));
	XtManageChild(wid = XtCreateWidget(wname, toggleWidgetClass, par->handle(), wargs, wargcount));
#else
	if(!hasArg(XmNlabelPixmap))
	{	addArg(XmNrecomputeSize, cw ? FALSE : TRUE);
		addArg(XmNalignment, xmStyle2XmAlignment(style));
	}
	XtManageChild(wid = (App->windowsForced() ?
		XmCreateToggleButton(par->handle(), wname, wargs, wargcount) :
		XmCreateToggleButtonGadget(par->handle(), wname, wargs, wargcount)));
	initTabstop();
#endif
	wargcount = 0;
	return(wid ? TRUE : FALSE);
}

bool XmCheckBox::setState(bool newState)
{
	bool oldState = getState();

	if(oldState != newState)
#ifdef XAW
	{	addArg(XtNstate, newState);
#else
	{	addArg(XmNset, newState);
#endif
		if(wid)
		{	XtSetValues(wid, wargs, wargcount);
			wargcount = 0;
		}
	}
	return(oldState);
}

bool XmCheckBox::getState()
{
	if(wid)
	{	Arg a;
		int state = 0;
#ifdef XAW
		XtSetArg(a, XtNstate, &state);
#else
		XtSetArg(a, XmNset, &state);
#endif
		XtGetValues(wid, &a, 1);
		return(state ? TRUE : FALSE);
	}
	return(FALSE);
}

bool XmRadioButton::createControl(XmControlPane* par)
{
	parent = par->asObject();
	setLabelAndMnemonic();
#ifdef XAW
	if(!hasArg(XtNbitmap))
		addArg(XtNjustify, xmStyle2AwJustify(style));
	XtManageChild(wid = XtCreateWidget(wname, toggleWidgetClass, par->handle(), wargs, wargcount));
#else
	if(!hasArg(XmNlabelPixmap))
	{	addArg(XmNrecomputeSize, cw ? FALSE : TRUE);
		addArg(XmNalignment, xmStyle2XmAlignment(style));
	}
	addArg(XmNindicatorType, XmONE_OF_MANY);
	XtManageChild(wid = (App->windowsForced() ?
		XmCreateToggleButton(par->handle(), wname, wargs, wargcount) :
		XmCreateToggleButtonGadget(par->handle(), wname, wargs, wargcount)));
	initTabstop();
#endif
	wargcount = 0;
	initTabstop();
#ifdef XAW
	setCallback(XtNcallback, this, CBK(XmRadioButton, selected), TRUE, NULL);
#else
	setCallback(XmNvalueChangedCallback, this, CBK(XmRadioButton, selected), TRUE, NULL);
#endif
	return(wid ? TRUE : FALSE);
}

void XmRadioButton::selected(void* cd)
{
	bool curState = getState();

	if(curState)
	{	if(next)
			next->reset(TRUE);
		if(prev)
			prev->reset(FALSE);
		if(userData.receiver && validProc(userData.callback))
			genericCallback(wid, (XtPointer )&userData, (XtPointer )cd);
	}
	else
		setState(TRUE);
}

void XmRadioButton::reset(bool direction)
{
	if(getState())
		setState(FALSE);
	if(direction)
	{	if(next)
			next->reset(direction);
	}
	else
	{	if(prev)
			prev->reset(direction);
	}
}

bool XmRadioButton::setState(bool newState)
{
	if(newState && !getState())
	{	if(next)
			next->reset(TRUE);
		if(prev)
			prev->reset(FALSE);
	}
	return(XmCheckBox::setState(newState));
}

XmRadioButton* XmRadioButton::getSelected()
{
	if(getState())
		return(this);
	XmRadioButton* aButton;
	if(	(next && (aButton = next->getSelected())) ||
		(prev && (aButton = prev->getSelected())))
		return(aButton);
	return(NULL);
}

#ifdef XAW
#else
#include <Scale.h>
#endif

#include <math.h>

bool XmValuator::createControl(XmControlPane* par)
{
	parent = par->asObject();
#ifdef XAW
#else
	XtManageChild(wid = XmCreateScale(par->handle(), wname, wargs, wargcount));
	initTabstop();
	wargcount = 0;
	initTabstop();
#endif
	return(wid ? TRUE : FALSE);
}

int XmValuator::f2i(float f)
{
	return(int(f * pow(10, decimals)));
}

float XmValuator::i2f(int i)
{
	float f = i;
	return(f / pow(10, decimals));
}

bool XmValuator::setOrientation(bool horiz)
{
	bool prev = (cw > ch) ? FALSE : TRUE;
#ifdef XAW
#else
	unsigned char or;
	if(wid)
	{	XtVaGetValues(wid, XmNorientation, &or, NULL);
		prev = (or == XmVERTICAL) ? FALSE : TRUE;
	}
	or = horiz ? XmHORIZONTAL : XmVERTICAL;
	setArg(XmNorientation,  or);
#endif
	return(prev);
}

bool XmValuator::setDirection(bool begToEnd)
{
	bool orient = TRUE, prev = TRUE;
#ifdef XAW
#else
	unsigned char or, pd;
	if(wid)
	{	XtVaGetValues(wid, XmNorientation, &or, XmNprocessingDirection, &pd, NULL);
		orient = (or == XmVERTICAL) ? FALSE : TRUE;
		prev = (pd == XmMAX_ON_TOP || pd == XmMAX_ON_LEFT) ? TRUE : FALSE;
	}
	pd = orient ? (begToEnd ? XmMAX_ON_LEFT : XmMAX_ON_RIGHT) :
		(begToEnd ? XmMAX_ON_TOP : XmMAX_ON_BOTTOM);
	setArg(XmNprocessingDirection,  pd);
#endif
	return(prev);
}

short XmValuator::setDecimalPoints(short d)
{
	short prev = decimals;
#ifdef XAW
#else
	if(wid)
		XtVaGetValues(wid, XmNdecimalPoints, &prev, NULL);
	setArg(XmNdecimalPoints, decimals = d);
#endif
	return(prev);
}

void XmValuator::displayValue(bool yes)
{
#ifdef XAW
#else
	setArg(XmNshowValue, yes);
#endif
}

XmControl* XmValuator::setText(char* txt)
{
#ifdef XAW
#else
	setArg(XmNtitleString, (XtArgVal )XmStringCreateLtoR(txt, XmSDCS));
#endif
	return(this);
}

XmControl* XmValuator::setRange(int from, int to)
{
#ifdef XAW
#else
	addArg(XmNminimum, from);
	setArg(XmNmaximum, to);
#endif
	return(this);
}

XmControl* XmValuator::setValue(int val)
{
#ifdef XAW
#else
	setArg(XmNvalue, val);
#endif
	return(this);
}

int XmValuator::getValue()
{
	int val = 0;
#ifdef XAW
#else
	if(wid)
		XtVaGetValues(wid, XmNvalue, &val, NULL);
#endif
	return(val);
}


#ifdef XAW
extern "C" {
#include <AsciiText.h>
}
#define EH 25
#else
#include <Text.h>
#define EH 20 // 34
#endif


XmEdit::~XmEdit()
{
	delete pasteBuffer;
	delete lastVersion;
}

#ifndef XAW

static char MULTI_LINE_TRANSLATIONS[] =
    "Shift<Key>Tab:    next-tab-group() \n\
     <Key>Return:   newline()";

#if XmVERSION == 1 && XmREVISION == 1
#define XmFontType int
#endif

typedef struct _XmFontListRec // from XmI.h
{
    XtPointer    font;
    char        *tag;
    XmFontType   type;
}
XmFontListRec;

#endif

bool XmEdit::createControl(XmControlPane* par)
{
    XtTranslations ttbl;

	multiLine = (style & XmSmultiLine ? TRUE : FALSE);
	hScroll = (style & XmSautohscroll ? TRUE : FALSE);
	vScroll = (style & XmSautovscroll ? TRUE : FALSE);

	setText("");
#ifndef XAW
	if(multiLine)
		addArg(XmNeditMode, XmMULTI_LINE_EDIT);
	if(style & XmSautoCursor)
		addArg(XmNautoShowCursorPosition, TRUE);
//	if(ch < EH)
//		changeArg(XtNheight, (ch = EH));
#endif
#ifdef XAW
	addArg(XtNeditType, XawtextEdit);
	addArg(XtNstring, (XtArgVal )"");
	addArg(XtNscrollHorizontal, (multiLine && hScroll) ? XawtextScrollWhenNeeded : XawtextScrollNever);
	addArg(XtNscrollVertical, (multiLine && vScroll) ? XawtextScrollWhenNeeded : XawtextScrollNever);
	XtManageChild(wid = XtCreateWidget(wname, asciiTextWidgetClass, par->handle(), wargs, wargcount));
#else
	if(multiLine && (hScroll || vScroll))
	{	addArg(XmNscrollHorizontal, hScroll);
		addArg(XmNscrollVertical, vScroll);
		XtManageChild(wid = XmCreateScrolledText(par->handle(), wname, wargs, wargcount));
	}
	else
	{	XtManageChild(wid = XmCreateText(par->handle(), wname, wargs, wargcount));
		XmFontListRec* f;
		Dimension highlight, shadow, frame;
		XtVaGetValues(wid, XmNfontList, &f,
				XmNhighlightThickness, &highlight,
				XmNshadowThickness, &shadow, NULL);
		frame = (highlight + shadow) * 2;
		XFontStruct* font = (XFontStruct*)f->font;
		int fontHeight = font->ascent + font->descent;

		if(ch < fontHeight + frame + 4)
			XtVaSetValues(wid, XmNmarginHeight, 2,
			  XmNheight, (ch = fontHeight + frame + 4), NULL);
		else if(!multiLine)
		{	int nmh = ((ch - fontHeight - frame) / 2) - 1;
			XtVaSetValues(wid, XmNmarginHeight, nmh, NULL);
			  //(ch - fontHeight - frame) / 2, XmNheight, ch, NULL);
		}
	}
	if(wid && multiLine)
	{	ttbl = XtParseTranslationTable(MULTI_LINE_TRANSLATIONS);
    		XtOverrideTranslations(wid, ttbl);
	}
#endif
	wargcount = 0;
	initTabstop(multiLine);
#ifdef XAW
//	setCallback(XtNcallback, this, CBK(XmEdit, changed), TRUE);
#else
	setCallback(XmNfocusCallback, this, CBK(XmEdit, changed), TRUE, (void* )111L);
	setCallback(XmNlosingFocusCallback, this, CBK(XmEdit, changed), TRUE, (void* )222L);
#endif
	parent = par->asObject();
	return(wid ? TRUE : FALSE);
}

bool XmEdit::resize(int nw, int nh)
{
#ifdef XAW
	return(XmControl::resize(nw, nh));
#else
	if(XmControl::resize(nw, nh) && (hScroll || vScroll))
	{	addArg(XmNrightAttachment, XmATTACH_SELF);
		addArg(XmNrightOffset, nw);
		addArg(XmNbottomAttachment, XmATTACH_SELF);
		addArg(XmNbottomOffset, nh);
		if(wid)
		{	XtSetValues(XtParent(wid), wargs, wargcount);
			XtSetValues(wid, wargs, wargcount);
			wargcount = 0;
		}
	}
	return(TRUE);
#endif
}

bool XmEdit::reframe(int nx, int ny, int nw, int nh)
{
#ifdef XAW
	return(XmControl::reframe(nx, ny, nw, nh));
#else
	if(XmControl::reframe(nx, ny, nw, nh) && (hScroll || vScroll))
	{	addArg(XmNleftAttachment, XmATTACH_FORM);
		addArg(XmNleftOffset, nx);
		addArg(XmNtopAttachment, XmATTACH_FORM);
		addArg(XmNtopOffset, ny);
		addArg(XmNrightAttachment, XmATTACH_SELF);
		addArg(XmNrightOffset, nw);
		addArg(XmNbottomAttachment, XmATTACH_SELF);
		addArg(XmNbottomOffset, nh);
		if(wid)
		{	XtSetValues(XtParent(wid), wargs, wargcount);
			XtSetValues(wid, wargs, wargcount);
			wargcount = 0;
		}
	}
	return(TRUE);
#endif
}

void XmEdit::changed(void* begEnd)
{
	if(begEnd == (void* )111L)
	{	char* cur = getText();
		lastVersion = strcpy(new char[strlen(cur) + 1], cur);
	}
	else
	{	if((!lastVersion || strcmp(lastVersion, getText())) && userData.receiver && validProc(userData.callback))
			genericCallback(wid, (XtPointer )&userData, (XtPointer )NULL);
		delete lastVersion;
		lastVersion = NULL;
	}
}

XmControl* XmEdit::setText(char* txt)
{
#ifdef XAW
	addArg(XtNstring, (XtArgVal )txt);
	if(wid)
	{	XtSetValues(wid, wargs, wargcount);
		wargcount = 0;
	}
#else
	if(wid)
	{	XmTextSetString(wid, txt);
		if(lastVersion)
		{	delete lastVersion;
			lastVersion = strcpy(new char[strlen(txt) + 1], txt);
		}
	}
	else
		addArg(XmNvalue, (XtArgVal )txt);
#endif
	return(this);
}

char* _edit_get_text_buffer = NULL;

char* XmEdit::getText()
{
	if(!wid)
		return((char* )NULL);
#ifdef XAW
	Arg a;
	XtSetArg(a, XtNstring, (XtArgVal )&_edit_get_text_buffer);
	XtGetValues(wid, &a, 1);
	return(_edit_get_text_buffer);
#else
	XtFree(_edit_get_text_buffer);
	return(_edit_get_text_buffer = XmTextGetString(wid));
#endif
}

bool XmEdit::setEditable(bool b)
{
#ifdef XAW
	addArg(XtNsensitive, (XtArgVal )b);
#else
	addArg(XmNeditable, (XtArgVal )b);
#endif
	if(wid)
	{	XtSetValues(wid, wargs, wargcount);
		wargcount = 0;
	}
	return(TRUE);
}

long XmEdit::getInsertPosition(int* x, int* y)
{
	long p;
	Position px, py;

	if(!wid)
		return(0);
#ifdef XAW
	return(0);
#else
	p = XmTextGetInsertionPosition(wid);
	if(x || y)
	{	XmTextPosToXY(wid, p, &px, &py);
		if(x)
			*x = px;
		if(y)
			*y = py;
	}
	return(p);
#endif
}

bool XmEdit::setInsertPosition(long offs)
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	return(FALSE);
#else
	XmTextSetInsertionPosition(wid, offs);
	return(TRUE);
#endif
}

bool XmEdit::setInsertPosition(int x, int y)
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	return(FALSE);
#else
	return(setInsertPosition(XmTextXYToPos(wid, x, y)));
#endif
}

char* lastSelectionBuffer = NULL;

char* XmEdit::getSelection()
{
	if(!wid)
		return(NULL);
#ifdef XAW
	return(NULL);
#else
	XtFree(lastSelectionBuffer);
	return(lastSelectionBuffer = XmTextGetSelection(wid));
#endif
}

bool XmEdit::getSelection(long& from, long& to)
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	return(FALSE);
#else
	return(XmTextGetSelectionPosition(wid, &from, &to) ? TRUE : FALSE);
#endif
}

bool XmEdit::setSelection(long from, long to)
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	return(FALSE);
#else
	XmTextSetSelection(wid, from, to, CurrentTime);
	return(TRUE);
#endif
}

bool XmEdit::clearSelection()
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	return(FALSE);
#else
	XmTextClearSelection(wid, CurrentTime);
	return(TRUE);
#endif
}

bool XmEdit::cut()
{
#ifdef XAW
	return(FALSE);
#else
	return(XmTextCut(wid, CurrentTime) ? TRUE : FALSE);
#endif
}

bool XmEdit::copy()
{
#ifdef XAW
	return(FALSE);
#else
	return(XmTextCopy(wid, CurrentTime) ? TRUE : FALSE);
#endif
}

bool XmEdit::paste()
{
#ifdef XAW
	return(FALSE);
#else
	return(XmTextPaste(wid) ? TRUE : FALSE);
#endif
}


#ifdef XAW
extern "C" {
#include <List.h>
#include <Viewport.h>
}
#else
#include <List.h>
#endif

bool XmListBox::createControl(XmControlPane* par)
{
#ifdef XAW
	Widget vp;
	char tmpstrbuf[1024];
	ostrstream vpname(tmpstrbuf, 1024);
	vpname << wname << "-viewport"; vpname.put('\0');
	addArg(XtNallowHoriz, TRUE);
	addArg(XtNallowVert, TRUE);
	XtManageChild(vp = XtCreateWidget(vpname.str(), viewportWidgetClass, par->handle(), wargs, wargcount));
	wargcount = 0;
	char** cont = new char*[1];
	cont[0] = NULL;
	addArg(XtNdefaultColumns, 1);
	addArg(XtNforceColumns, TRUE);
	addArg(XtNlist, (XtArgVal )cont);
	addArg(XtNnumberStrings, 0);
	XtManageChild(wid = XtCreateWidget(wname, listWidgetClass, vp, wargs, wargcount));
#else
	addArg(XmNselectionPolicy, (multiSel ? XmEXTENDED_SELECT : XmBROWSE_SELECT));
	addArg(XmNvisualPolicy, XmCONSTANT);
	XtManageChild(wid = XmCreateScrolledList(par->handle(), wname, wargs, wargcount));
	initTabstop();
#endif
	wargcount = 0;
	parent = par->asObject();
	if(wid && initialContents)
	{	addAll(initialContents);
		initialContents = NULL;
	}
	return(wid ? TRUE : FALSE);
}

void XmListBox::cleanup()
{
#ifdef XAW
	Arg a[2];
	int numStrings = 0, count = 0;
	char** cur;
	XtSetArg(a[0], XtNlist, (XtArgVal )&cur);
	XtSetArg(a[1], XtNnumberStrings, (XtArgVal )&numStrings);
	XtGetValues(wid, a, 2);

	for(int i = 0; i < numStrings; i++)
		delete cur[i];
	delete cur;
#endif
}

bool XmListBox::resize(int nw, int nh)
{
#ifdef XAW
	Widget l = wid;
	wid = XtParent(l);
	XmControl::resize(nw, nh);
	wid = l;
#else
	XmControl::resize(nw, nh);
	addArg(XmNrightAttachment, XmATTACH_SELF);
	addArg(XmNrightOffset, nw);
	addArg(XmNbottomAttachment, XmATTACH_SELF);
	addArg(XmNbottomOffset, nh);
	if(wid)
	{	XtSetValues(XtParent(wid), wargs, wargcount);
		XtSetValues(wid, wargs, wargcount);
		wargcount = 0;
	}
#endif
	return(TRUE);
}

bool XmListBox::reframe(int nx, int ny, int nw, int nh)		// a 'russian' solution...
{
#ifdef XAW
	Widget l = wid;
	wid = XtParent(l);
	XmControl::reframe(nx, ny, nw, nh);
	wid = l;
#else
	XmControl::reframe(nx, ny, nw, nh);
	addArg(XmNleftAttachment, XmATTACH_FORM);
	addArg(XmNleftOffset, nx);
	addArg(XmNtopAttachment, XmATTACH_FORM);
	addArg(XmNtopOffset, ny);
	addArg(XmNrightAttachment, XmATTACH_SELF);
	addArg(XmNrightOffset, nw);
	addArg(XmNbottomAttachment, XmATTACH_SELF);
	addArg(XmNbottomOffset, nh);
	if(wid)
	{	XtSetValues(XtParent(wid), wargs, wargcount);
		XtSetValues(wid, wargs, wargcount);
		wargcount = 0;
	}
#endif
	return(TRUE);
}

bool XmListBox::change(char*, char*)
{
	return(FALSE);		// should be implemented...!
}

bool XmListBox::change(int, char*)
{
	return(FALSE);		// should be implemented...!
}

XmListBox* XmListBox::addAll(char** list)
{
	if(!wid)
		return(this);
#ifdef XAW
	return(insertAll(-1, list));
#else
	while(*list)
		XmListAddItemUnselected(wid, XmStringCreateLtoR(*list++, XmSDCS), 0);
	return(this);
#endif
}

XmListBox* XmListBox::addAll(char* first,...)
{
	if(!wid)
		return(this);
#ifndef NO_VARARGS
	va_list ap;
	char* anItem = first;

	va_start(ap, first);
	while(anItem)
#ifdef XAW
	{	char* list[2];
		list[0] = anItem;
		list[1] = NULL;
		insertAll(-1, list);
#else
	{	XmListAddItemUnselected(wid, XmStringCreateLtoR(anItem, XmSDCS), 0);
#endif
		anItem = va_arg(ap, char*);
	}
	va_end(ap);
#else
	XmListAddItemUnselected(wid, XmStringCreateLtoR(first, XmSDCS), 0);
#endif
	return(this);
}

char* tmpListBuf[500];

XmListBox* XmListBox::insertAll(int start, char** list)
{
	if(!wid)
		return(this);
#ifdef XAW
	Arg a[2];
	int i, numStrings = 0, ndx = 0;
	char** cur;
	XtSetArg(a[0], XtNnumberStrings, (XtArgVal )&numStrings);
	XtSetArg(a[1], XtNlist, (XtArgVal )&cur);
	XtGetValues(wid, a, 2);

	if(start < 1 || start > numStrings)
		start = -1;

	if(start == -1)
	{	for(i = 0; i < numStrings; i++)
			tmpListBuf[ndx++] = cur[i];
	}
	else
	{	for(i = 0; i < numStrings && i < start - 1; i++)
			tmpListBuf[ndx++] = cur[i];
	}
	while(*list)
	{	tmpListBuf[ndx++] = strcpy((new char[strlen(*list) + 1]), *list);
		list++;
	}
	if(start != -1)
	{	for(i = start - 1; i < numStrings; i++)
			tmpListBuf[ndx++] = cur[i];
	}
	delete cur;
	cur = new char*[ndx];
	for(i = 0; i < ndx; i++)
		cur[i] = tmpListBuf[i];
	XawListChange(wid, cur, ndx, 0, TRUE);
#else
	while(*list)
		XmListAddItemUnselected(wid, XmStringCreateLtoR(*list++, XmSDCS), start++);
#endif
	return(this);
}

XmListBox* XmListBox::insertAll(int start, char* first,...)
{
	if(!wid)
		return(this);

	va_list ap;
	char* anItem = first;

	va_start(ap, first);
	while(anItem)
#ifdef XAW
	{	char* list[2];
		list[0] = anItem;
		list[1] = NULL;
		insertAll(start++, list);
#else
	{	XmListAddItemUnselected(wid, XmStringCreateLtoR(anItem, XmSDCS), start++);
#endif
		anItem = va_arg(ap, char*);
	}
	va_end(ap);
	return(this);
}

bool XmListBox::removeAll(char** list)
{
	XmString aStr;

	if(!wid)
		return(FALSE);
#ifdef XAW
	Arg a[2];
	int numStrings = 0, ndx = 0;
	char** cur;
	XtSetArg(a[0], XtNnumberStrings, (XtArgVal )&numStrings);
	XtSetArg(a[1], XtNlist, (XtArgVal )&cur);
	XtGetValues(wid, a, 2);
	bool rc = FALSE;
	if(numStrings)
	{	int* rm = new int[numStrings];
		for(int i = 0; i < numStrings; i++)
		{	int j = 0;
			while(list[j++])
			{	if(!strcmp(cur[i], list[j - 1]))
					rm[ndx++] = i + 1;
			}
		}
		if(ndx)
		{	rm[ndx] = 0;
			rc = removeAll(rm);
		}
		delete rm;
	}
	return(rc);
#else
	while(*list)
	{	XmListDeleteItem(wid, (aStr = XmStringCreateLtoR(*list++, XmSDCS)));
		XmStringFree(aStr);
	}
	return(TRUE);
#endif
}

bool XmListBox::removeAll(char* first,...)
{
	XmString aStr;

	if(!wid)
		return(FALSE);

	va_list ap;
	char* anItem = first;
	va_start(ap, first);
	while(anItem)
#ifdef XAW
	{	char* list[2];
		list[0] = anItem;
		list[1] = NULL;
		removeAll(list);
#else
	{	XmListDeleteItem(wid, (aStr = XmStringCreateLtoR(anItem, XmSDCS)));
		XmStringFree(aStr);
#endif
		anItem = va_arg(ap, char*);
	}
	va_end(ap);
	return(TRUE);
}

bool XmListBox::removeAll(int* list)
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	Arg a[2];
	int i, numStrings = 0, ndx = 0, count = 0;
	char** cur, ** nwp;
	XtSetArg(a[0], XtNnumberStrings, &numStrings);
	XtSetArg(a[1], XtNlist, (XtArgVal )&cur);
	XtGetValues(wid, a, 2);

	for(i = 0; i < numStrings; i++)
	{	if(*list && i == ((*list) - 1))
		{	delete cur[i];
			cur[i] = NULL;
			list++;
			count++;
		}
	}
	if(numStrings - count > 0)
	{	nwp = new char*[numStrings - count];
		for(i = 0; i < numStrings; i++)
		{	if(cur[i])
				nwp[ndx++] = cur[i];
		}
	}
	else
	{	nwp = new char*[1];
		nwp[0] = NULL;
	}
	delete cur;
	XawListChange(wid, nwp, ndx, 0, TRUE);
#else
	while(*list)
		XmListDeletePos(wid, *list++);
#endif
	return(TRUE);
}

bool XmListBox::removeAll(int first,...)
{
	if(!wid)
		return(FALSE);

	va_list ap;
	int anIndex = first;

	va_start(ap, first);
	while(anIndex)
#ifdef XAW
	{	int all[2];
		all[0] = anIndex;
		all[1] = 0;
		removeAll(all);
#else
	{	XmListDeletePos(wid, anIndex);
#endif
		anIndex = va_arg(ap, int);
	}
	va_end(ap);
	return(TRUE);
}

bool XmListBox::clear()
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	Arg a;
	char** cur;
	XtSetArg(a, XtNlist, (XtArgVal )&cur);
	XtGetValues(wid, &a, 1);
	delete cur;
	cur = new char*[1];
	cur[0] = NULL;
	XawListChange(wid, cur, -1, -1, TRUE);
#else
	XmListDeleteAllItems(wid);
#endif
	return(TRUE);
}	

bool XmListBox::selectText(char* anItem, bool notify)
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	Arg a[2];
	int numStrings = 0;
	char** cur;
	XtSetArg(a[0], XtNnumberStrings, (XtArgVal )&numStrings);
	XtSetArg(a[1], XtNlist, (XtArgVal )&cur);
	XtGetValues(wid, a, 2);
	bool rc = FALSE;
	if(numStrings)
	{	for(int i = 0; i < numStrings; i++)
		{	if(!strcmp(cur[i], anItem))
				rc = selectIndex(i + 1, notify);
		}
	}
	return(rc);
#else
//	XmListSelectItem(wid, XmStringCreateLtoR(anItem, XmSDCS), notify);
	return(selectIndex(XmListItemPos(wid, XmStringCreateLtoR(anItem, XmSDCS))));
#endif
}

bool XmListBox::selectIndex(int anIndex, bool notify)
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	XawListHighlight(wid, anIndex);
#else
	int lTop, lVisible;
	XtVaGetValues(wid, XmNtopItemPosition, &lTop, XmNvisibleItemCount, &lVisible, NULL);
	if(anIndex < lTop)
		XmListSetPos(wid, anIndex);
	else if(anIndex >= (lTop + lVisible))
		XmListSetBottomPos(wid, anIndex);
	XmListSelectPos(wid, anIndex, notify);
#endif
	return(TRUE);
}

bool XmListBox::deselectText(char* anItem)
{
	XmString aStr;

	if(!wid)
		return(FALSE);
#ifdef XAW
	XawListUnhighlight(wid);	// only single selection list...
#else
	XmListDeselectItem(wid, (aStr = XmStringCreateLtoR(anItem, XmSDCS)));
	XmStringFree(aStr);
#endif
	return(TRUE);
}

bool XmListBox::deselectIndex(int anIndex)
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	XawListUnhighlight(wid);	// only single selection list...
#else
	XmListDeselectPos(wid, anIndex);
#endif
	return(TRUE);
}

bool XmListBox::deselectAll()
{
	if(!wid)
		return(FALSE);
#ifdef XAW
	XawListUnhighlight(wid);
#else
	XmListDeselectAllItems(wid);
#endif
	return(TRUE);
}

bool XmListBox::setDoubleClickCallback(XmObject* rec, cbProc pr, bool sr, void* cd)
{
#ifdef XAW
	cerr << "xmListBox: sorry, double click not implemented.\n";
	return(FALSE);
#else
	return(setCallback(XmNdefaultActionCallback, rec, pr, sr, cd));
#endif
}

char** _listbox_items_ptr = NULL;

char** XmListBox::getItems()
{
	char** items;
	int count = 0;

	if(!wid)
		return(NULL);

	_freeStringList(_listbox_items_ptr);

#ifndef XAW
	XmStringTable itemStrings;

	XtVaGetValues(wid, XmNitems, &itemStrings, XmNitemCount, &count, NULL);
	wargcount = 0;
	items = new char*[count + 1];
	for(int i = 0; i < count; i++)
	{	// items[i] = new char[XmStringLength(itemStrings[i]) + 1];
		if(!XmStringGetLtoR(itemStrings[i], XmSDCS, &items[i]))
			cerr << "xmListBox: Error - cannot get string contents...\n";
	}
#else
	items = new char*[1];
#endif // XAW
	items[count] = NULL;
	_listbox_items_ptr = items;
	return(items);
}

int XmListBox::getItemCount()
{
	int count = 0;
#ifndef XAW
	XtVaGetValues(wid, XmNitemCount, &count, NULL);
#endif
	return(count);
}

int XmListBox::selectedCount()
{
	if(!wid)
		return(0);
#ifdef XAW
	return(*selectedIndices() ? 1 : 0);
#else
	getArg(XmNselectedItemCount);
	XtGetValues(wid, wargs, wargcount);
	wargcount = 0;
	return((int )wargs[0].value);
#endif
}

char** XmListBox::selectedItems()
{
	char** items = NULL;
	int count = 0;

	if(!wid)
		return(NULL);

	_freeStringList(_listbox_items_ptr);

#ifdef XAW
	XawListReturnStruct* rs = XawListShowCurrent(wid);
	if(rs->list_index != XAW_LIST_NONE)
	{	items = new char*[2];
		items[0] = strcpy(new char[strlen(rs->string) + 1], rs->string);
		count = 1;
	}
#else // XAW
	XmStringTable itemStrings;

	XtVaGetValues(wid, XmNselectedItems, &itemStrings, XmNselectedItemCount, &count, NULL);
	wargcount = 0;
	items = new char*[count + 1];
	for(int i = 0; i < count; i++)
	{	//items[i] = new char[XmStringLength(itemStrings[i]) + 1];
		if(!XmStringGetLtoR(itemStrings[i], XmSDCS, &items[i]))
			cerr << "xmListBox: Error - cannot get string contents...\n";
	}
#endif // XAW
	items[count] = NULL;
	_listbox_items_ptr = items;
	return(items);
}

extern "C" { void free(void*); }

int* _listbox_indices_ptr = NULL;

int* XmListBox::selectedIndices()
{
	int posCount = 0, * posArray, * anArray = NULL, ndx;

	delete _listbox_indices_ptr;
	_listbox_indices_ptr = NULL;

#ifdef XAW
	if(wid)
	{	XawListReturnStruct* rs = XawListShowCurrent(wid);
		if(rs->list_index != XAW_LIST_NONE)
		{	anArray = new int[2];
			anArray[0] = rs->list_index + 1;
			posCount = 1;
		}
#else
	if(wid && XmListGetSelectedPos(wid, &posArray, &posCount))
	{	anArray = new int[posCount + 1];
		for(ndx = 0; ndx < posCount; ndx++)
			anArray[ndx] = posArray[ndx];
		free(posArray);
#endif
	}
	else
		anArray = new int[1];
	anArray[posCount] = 0;		// was -1 (nonsens...!)
	_listbox_indices_ptr = anArray;
	return(anArray);
}


#ifdef XAW
#define CAW 25
#define CAH 25
#define CAS 2
#else
#define CAW 32
#define CAH 32
#define CAS 2
#endif

#ifdef COMBO_PROC_CAST
#undef CB
typedef void (XmComboBox::*comboProc)(void*);
inline cbProc makeCbProc(comboProc p)
{ cbProc px; memcpy(&px, &p, sizeof(cbProc)); return(px); }
#define CB(x) makeCbProc(&x)
#ifndef NO_PROC_CAST
#undef CBK
#define CBK(c, m) makeCbProc(& c :: m)
#else
// forget it...
#endif
#endif


static char cbxEditTr[] =
    "<Key>osfUp:	    ComboBox-Manager(up)		\n"
    "Alt<Key>osfDown:	    ComboBox-Manager(list)		\n" /* Ausklappen */
    "Meta<Key>osfDown:	    ComboBox-Manager(list)		\n" /* Ausklappen */
    "<Key>osfDown:	    ComboBox-Manager(down)		\n"
    "<Key>Return:	    ComboBox-Manager(activate) activate() " /* Return    */
    ;

static char cbxEditTrRO[] = 
    "<Key>osfBeginLine:	    ComboBox-Manager(top)		\n" /* Top       */
    "<Key>osfEndLine:	    ComboBox-Manager(bottom)		  " /* Bottom    */
    ;

static void CBoxManager(Widget w, XEvent *event, String *params, 
                        Cardinal *num_params);

static XtActionsRec actions[] = {
    { "ComboBox-Manager", CBoxManager },
    { NULL, NULL }
};

static XtTranslations ComboBoxEditTr, ComboBoxEditTrRO;

#define MAX_GLOBAL_COMBOS 300

XmComboBox* _all_combos[MAX_GLOBAL_COMBOS];
bool _all_combos_initialized = FALSE;

void _init_all_combos()
{
	for(int i = 0; i < MAX_GLOBAL_COMBOS; i++)
		_all_combos[i] = NULL;
	_all_combos_initialized = TRUE;
}

void _register_combo(XmComboBox* c, bool addOrRemove)
{
	for(int i = 0; i < MAX_GLOBAL_COMBOS; i++)
	{	if(addOrRemove && !_all_combos[i])
		{	_all_combos[i] = c;
			return;
		}
		else if(!addOrRemove && _all_combos[i] == c)
		{	_all_combos[i] = NULL;
			return;
		}
	}
	cerr << "combo box: warning - registration failed.\n";
}

XmComboBox* _get_combo(char* n)
{
	for(int i = 0; i < MAX_GLOBAL_COMBOS; i++)
	{	if(!strcmp(_all_combos[i]->getName(), n))
			return(_all_combos[i]);
	}
	return(NULL);
}
 
#include <cursorfont.h>

static Cursor ArrowCursor = 0;
 
XmComboBox::XmComboBox(char* name, int x, int y, int w, int h, xmStyle s) :
	XmGroupBox(name, x, y, w, (s & XmSsimple) ? h : CAH, s),
	XmPushButton(name, x + w - CAW, y, CAW, CAH),
	XmEdit(name, x, y, w - CAW - CAS, CAH),
	XmListBox(name, x + CAW, y + CAH, w - CAW, (h > 2 * CAH) ? h - CAH : 4 * CAH)
{
	popup = NULL;
	cbStyle = ((s & XmSdropdownlist) ? DROPDOWNLIST : ((s & XmSsimple) ? SIMPLE : DROPDOWN));
	lbMapped = FALSE;
	if(!ArrowCursor)
	{	ArrowCursor = XCreateFontCursor(App->getDisplay(), XC_left_ptr);
#ifndef XAW
		ComboBoxEditTr = XtParseTranslationTable(cbxEditTr);
		ComboBoxEditTrRO = XtParseTranslationTable(cbxEditTrRO);
		XtAppAddActions(App->getAppContext(), actions, XtNumber(actions));
#endif
	}
	if(!_all_combos_initialized)
		_init_all_combos();
	_register_combo(this, TRUE);
	ignoreSelect = FALSE;
}

XmComboBox::~XmComboBox()
{
	MEMBER(XmEdit, resetParent)();
	MEMBER(XmPushButton, resetParent)();
	MEMBER(XmListBox, resetParent)();
	if(popup)
		XtDestroyWidget(popup);
	_register_combo(this, FALSE);
}

#ifndef XAW
#include <ArrowB.h>
#include <MenuShell.h>
#endif

bool XmComboBox::createControl(XmControlPane* par)
{
	XmGroupBox::createControl(par);		// XmGroupBox:: seems to br the gnu default pointer....

	if(cbStyle == DROPDOWNLIST)
#ifdef XAW
		MEMBER(XmEdit, addArg)(XtNsensitive, FALSE);
#else // XAW
		MEMBER(XmEdit, addArg)(XmNeditable, FALSE);
#endif // XAW
	MEMBER(XmEdit, reframe)(0, 0, MEMBER(XmGroupBox, cw) - CAW - (cbStyle == DROPDOWN ? CAS : 0), CAH);
	XmEdit::createControl((XmGroupBox* )this);
	XtOverrideTranslations(MEMBER(XmEdit, wid), ComboBoxEditTr);
	if(cbStyle == DROPDOWNLIST)
		XtOverrideTranslations(MEMBER(XmEdit, wid), ComboBoxEditTrRO);
#ifndef XAW
	MEMBER(XmEdit, setCallback)((XmGroupBox* )this, CBK(XmComboBox, changeText), TRUE, NULL);
#endif
#ifdef XAW
	MEMBER(XmPushButton, addArg)(XtNlabel, (XtArgVal )"V");
	MEMBER(XmPushButton, move)(MEMBER(XmGroupBox, cw) - CAW, 0);
	MEMBER(XmPushButton, addArg)(XtNleft, XtChainLeft);
	MEMBER(XmPushButton, addArg)(XtNright, XtChainLeft);
	MEMBER(XmPushButton, addArg)(XtNtop, XtChainTop);
	MEMBER(XmPushButton, addArg)(XtNbottom, XtChainTop);
	MEMBER(XmPushButton, addArg)(XtNhorizDistance, MEMBER(XmPushButton, cx));
	MEMBER(XmPushButton, addArg)(XtNvertDistance, MEMBER(XmPushButton, cy));
	XtManageChild(MEMBER(XmPushButton, wid) = XtCreateWidget(MEMBER(XmPushButton, wname), commandWidgetClass, MEMBER(XmGroupBox, wid), MEMBER(XmPushButton, wargs), MEMBER(XmPushButton, wargcount)));
#else // XAW
	MEMBER(XmPushButton, addArg)(XmNarrowDirection, XmARROW_DOWN);
	MEMBER(XmPushButton, move)(MEMBER(XmGroupBox, cw) - CAW, 0);
	XtManageChild(MEMBER(XmPushButton, wid) = XmCreateArrowButton(MEMBER(XmGroupBox, wid), MEMBER(XmPushButton, wname), MEMBER(XmPushButton, wargs), MEMBER(XmPushButton, wargcount)));
#endif // XAW
	MEMBER(XmPushButton, wargcount) = 0;
	MEMBER(XmPushButton, parent) = (XmGroupBox* )this;
#ifdef XAW
	MEMBER(XmPushButton, setCallback)(XtNcallback, (XmGroupBox* )this, CBK(XmComboBox, selectArrow), TRUE, NULL);
#else // XAW
	MEMBER(XmPushButton, setCallback)(XmNarmCallback, (XmGroupBox* )this, CBK(XmComboBox, selectArrow), TRUE, CB_XM_DATA);
	MEMBER(XmPushButton, setCallback)(XmNactivateCallback, (XmGroupBox* )this, CBK(XmComboBox, selectArrow), TRUE, CB_XM_DATA);
#endif // XAW
	MEMBER(XmListBox, makeRelativeTo)((XmGroupBox* )this);
	if(cbStyle == SIMPLE)
	{	XtSetMappedWhenManaged(MEMBER(XmPushButton, wid), FALSE);
		XmListBox::createControl((XmGroupBox* )this);
	}
	else
	{	Arg shArgs[1];
		XtSetArg(shArgs[0], XtNallowShellResize, FALSE);
		popup = XtCreateWidget(MEMBER(XmListBox, wname), overrideShellWidgetClass, MEMBER(XmGroupBox, wid), shArgs, 1);
		MEMBER(XmListBox, changeArg)(XtNx, (XtArgVal )0);
		MEMBER(XmListBox, changeArg)(XtNy, (XtArgVal )0);
#ifndef XAW
		MEMBER(XmListBox, addArg)(XmNselectionPolicy, XmBROWSE_SELECT);
		MEMBER(XmListBox, addArg)(XmNhighlightThickness, 0);
		MEMBER(XmListBox, addArg)(XmNautomaticSelection, False);
		MEMBER(XmListBox, addArg)(XmNscrollBarDisplayPolicy, XmSTATIC);
		MEMBER(XmListBox, addArg)(XmNvisibleItemCount, 5);
#endif
#ifdef XAW
		Widget vp;
		char tmpstrbuf[1024];
		ostrstream vpname(tmpstrbuf, 1024);
		vpname << MEMBER(XmListBox, wname) << "-viewport"; vpname.put('\0');
		MEMBER(XmListBox, addArg)(XtNallowHoriz, TRUE);
		MEMBER(XmListBox, addArg)(XtNallowVert, TRUE);
		XtManageChild(vp = XtCreateWidget(vpname.str(), viewportWidgetClass, popup, MEMBER(XmListBox, wargs), MEMBER(XmListBox, wargcount)));
		MEMBER(XmListBox, wargcount) = 0;
		char** cont = new char*[1];
		cont[0] = NULL;
		MEMBER(XmListBox, addArg)(XtNdefaultColumns, 1);
		MEMBER(XmListBox, addArg)(XtNforceColumns, TRUE);
		MEMBER(XmListBox, addArg)(XtNlist, (XtArgVal )cont);
		XtManageChild(MEMBER(XmListBox, wid) = XtCreateWidget(MEMBER(XmListBox, wname), listWidgetClass, vp, MEMBER(XmListBox, wargs), MEMBER(XmListBox, wargcount)));
#else // XAW
		XtManageChild(MEMBER(XmListBox, wid) = XmCreateScrolledList(popup, MEMBER(XmListBox, wname), MEMBER(XmListBox, wargs), MEMBER(XmListBox, wargcount)));
#endif // XAW
		MEMBER(XmListBox, wargcount) = 0;
		MEMBER(XmListBox, parent) = (XmGroupBox* )this;
	}
#ifdef XAW
	MEMBER(XmListBox, setCallback)(XtNcallback, (XmGroupBox* )this, CBK(XmComboBox, selectInList), TRUE, NULL);
//	MEMBER(XmGroupBox, setCallback)(MEMBER(XmListBox, wid), XtNcallback, (XmGroupBox* )this, CBK(XmComboBox, selectInList), TRUE, NULL);
#else // XAW
	MEMBER(XmListBox, setCallback)(XmNbrowseSelectionCallback, (XmGroupBox* )this, CBK(XmComboBox, selectInList), TRUE, NULL);
	if(cbStyle != SIMPLE)
		MEMBER(XmEdit, setCallback)(XmNlosingFocusCallback, (XmGroupBox* )this, CBK(XmComboBox, cleanupCb), TRUE, NULL);
	MEMBER(XmGroupBox, initTabstop)(TRUE);
#endif
	return(MEMBER(XmGroupBox, wid) ? TRUE : FALSE);
}

void XmComboBox::makeRelativeTo(XmGroupBox* aGroup)
{
	MEMBER(XmGroupBox, makeRelativeTo)(aGroup);
	if(cbStyle != SIMPLE)
		MEMBER(XmListBox, makeRelativeTo)(aGroup);
}

void XmComboBox::showList(bool n)
{
	if(n)
	{	Position nx, ny;
		XtVaGetValues(MEMBER(XmGroupBox, wid), XtNx, &nx, XtNy, &ny, NULL);
#ifdef X_POPUP_SHELL_BUG
		if(XtClass(XtParent(MEMBER(XmGroupBox, handle)())) != boxWidgetClass)
			nx = ny = 0;	// XtTranslateCoords seems to work different on some systems...
#endif
		XtTranslateCoords(XtParent(MEMBER(XmGroupBox, wid)), nx + MEMBER(XmListBox, cx), ny + MEMBER(XmListBox, cy), &nx, &ny);
		XtVaSetValues(popup, XtNx, nx, XtNy, ny, NULL);
 		XDefineCursor(App->getDisplay(), XtWindow(popup), ArrowCursor);
		XtPopup(popup, XtGrabNone);
	}
	else
		XtPopdown(popup);
	lbMapped = n;
}

void XmComboBox::selectArrow(void* info)
{
	XmEdit::setFocus();
#ifndef XAW
	if(((XmAnyCallbackStruct*)info)->reason == XmCR_ACTIVATE)
#endif
		showList(lbMapped ? FALSE : TRUE);
}


void XmComboBox::changeText(void* cd)
{
	Entry ud = MEMBER(XmGroupBox, userData);

//	if(MEMBER(XmGroupBox, userData).receiver && validProc(MEMBER(XmGroupBox, userData).callback))
	if(ud.receiver && validProc(ud.callback))
		genericCallback(MEMBER(XmGroupBox, wid), (XtPointer )&ud, (XtPointer )cd);
}

void XmComboBox::selectInList(void*)
{
	char** aList;

	XmEdit::setText((aList = selectedItems())[0]);
/*
#ifndef XAW
	delete aList[0];	// list should contain only one item...
#endif
	delete aList;
*/
	if(!ignoreSelect && cbStyle != SIMPLE)
		showList(FALSE);
	ignoreSelect = FALSE;
//	changeText(NULL);
	Entry ud = MEMBER(XmEdit, userData);
	if(ud.receiver && validProc(ud.callback))
		genericCallback(MEMBER(XmEdit, wid), (XtPointer )&ud, NULL);
}

void XmComboBox::cleanupCb(void*)
{
#ifndef XAW	// should not happen...
	Window root, child;
	int n, rx, wx, ry, wy;
	unsigned int kb;
	XQueryPointer(App->getDisplay(), XtWindow(MEMBER(XmGroupBox, wid)), &root, &child, &rx, &ry, &wx, &wy, &kb);
	if(child == XtWindow(MEMBER(XmPushButton, wid)))
		return;
	XQueryPointer(App->getDisplay(), XtWindow(XtParent(MEMBER(XmListBox, wid))), &root, &child, &rx, &ry, &wx, &wy, &kb);
	Widget* lbxc, lbox = XtParent(MEMBER(XmListBox, wid));
	XtVaGetValues(lbox, XmNchildren, &lbxc, XmNnumChildren, &n, NULL);
	if(child == XtWindow(lbox))
		return;
	for(int i = 0; i < n; i++)
	{	if(child == XtWindow(lbxc[i]))
			return;
	}
	showList(FALSE);
#endif
}

bool XmComboBox::realize()
{
	return(MEMBER(XmGroupBox, realize)());
}

bool XmComboBox::move(int nx, int ny)
{
	if(cbStyle != SIMPLE)
	{	MEMBER(XmListBox, cx) = nx + CAW;
		MEMBER(XmListBox, cy) = ny + CAH;
		if(popup)
			XtMoveWidget(popup, MEMBER(XmListBox, cx), MEMBER(XmListBox, cy));
	}
//	return(MEMBER(XmGroupBox, move)(nx, ny));
	return(XmGroupBox::move(nx, ny));
}

bool XmComboBox::resize(int x, int y)
{
	return(MEMBER(XmGroupBox, resize)(x, y));
}

bool XmComboBox::reframe(int x, int y, int w, int h)
{
	return(MEMBER(XmGroupBox, reframe)(x, y, w, h));
}

XmControl* XmComboBox::setFocus()	{ return((XmPushButton* )this); }

XmControl* XmComboBox::disable()
{
	Widget gbh;

	gbh = MEMBER(XmGroupBox, handle)();
	if(gbh)
		XtVaSetValues(gbh, XtNsensitive, FALSE, NULL);
	return((XmGroupBox* )this);
}

XmControl* XmComboBox::enable()
{
	Widget gbh;
	Arg a;

	gbh = MEMBER(XmGroupBox, handle)();
	if(gbh)
	{	XtSetArg(a, XtNsensitive, FALSE);
		XtSetValues(gbh, &a, 1);
	}
	return((XmGroupBox* )this);
}

void CBoxManager(Widget w, XEvent *Event, String *params, Cardinal *num_params)
{
	int opt = *(params[0]);
//	XmComboBox* cbx = (XmComboBox*)((void*)App->findObject(XtName(w)));
	XmComboBox* cbx = _get_combo(XtName(w));

	if(!cbx)
	{	cerr << "combo box - internal error: cannot find object\n";
		return;
	}
	switch (opt) 
	{	case 'l':
		cbx->toggleList();
		break;
		case 'u': /* up     */
		case 'd': /* down   */
		case 't': /* top    */
		case 'b': /* bottom */ {
		int ndx = ((XmListBox*)cbx)->selectedIndex();
	    	switch(opt)
	    	{	case 'u': ndx--;			break;
			case 'd': ndx++;			break;
			case 't': ndx = 1;			break;
			case 'b': ndx = ((XmListBox*)cbx)->getItemCount();	break;
	    	}
	    	cbx->kbdSelect(ndx); }
		break;
		case 'a': /* Return */
		case 's': /* Selection */
		cbx->toggleList();
		break;
	}
}
