/* ****************************** -*-c++-*- *******************************/
/* ************************************************************************ 
 *         The Amulet User Interface Development Environment              *
 * ************************************************************************
 * This code was written as part of the Amulet project at                 *
 * Carnegie Mellon University, and has been placed in the public          *
 * domain.  If you are using this code or any part of Amulet,             *
 * please contact amulet@cs.cmu.edu to be put on the mailing list.        *
 * ************************************************************************/

/* This file contains exported interface to the gesture-recognizer.
*/

#ifndef GESTURE_H
#define GESTURE_H

#include <am_inc.h>

#include AM_IO__H
#include GDEFS__H  // to get Am_Point_List
#include VALUE_LIST__H  // to get Am_Value_List

///////////////////////////////////////////////////////
/// Am_Feature_Vector: represents a gesture example
///

class Am_Feature_Vector_Data;
  
class Am_Feature_Vector {
  Am_WRAPPER_DECL (Am_Feature_Vector)
public:
  Am_Feature_Vector (); // no points
  Am_Feature_Vector (Am_Point_List& pl);

  void Add_Point (int x, int y);

  Am_Point_List Points ();
  double StartX();
  double StartY();
  double InitialSin();
  double InitialCos();
  double Dx2();
  double Dy2();
  double MagSq2();
  double EndX();
  double EndY();
  double MinX();
  double MaxX();
  double MinY();
  double MaxY();
  double PathR();
  double PathTh();
  double AbsTh();
  double Sharpness();
  double *Vector();    /* returns feature vector for classifier (as array
			    of doubles) */
};


///////////////////////////////////////////////////////
/// Am_Gesture_Classifier: recognizes gestures
///

class Am_Gesture_Classifier_Data;
  
class Am_Gesture_Classifier {
friend ostream&  operator<< (ostream& s, Am_Gesture_Classifier& gc);
friend istream&  operator>> (istream& s, Am_Gesture_Classifier& gc);

  Am_WRAPPER_DECL (Am_Gesture_Classifier)
public:
  Am_Gesture_Classifier (); // empty classifier
  Am_Gesture_Classifier (const char *filename); // read from file

  bool Trained ();
  Am_String Classify (Am_Feature_Vector fv, double *nap = 0, double *dist = 0);
};

ostream&  operator<< (ostream& s, Am_Gesture_Classifier& gc);
istream&  operator>> (istream& s, Am_Gesture_Classifier& gc);


////////////////////////////////////////////////////////////////////////
/// Am_Gesture_Trainer:  generates a classifier from training examples
///

class Am_Gesture_Trainer_Data;
  
class Am_Gesture_Trainer {
friend ostream&  operator<< (ostream& s, Am_Gesture_Trainer& gc);
friend istream&  operator>> (istream& s, Am_Gesture_Trainer& gc);

  Am_WRAPPER_DECL (Am_Gesture_Trainer)
public:
  Am_Gesture_Trainer (); // empty Trainer
  Am_Gesture_Trainer (const char *filename); // read from file

  bool Add_Class (Am_String classname, bool unique = true);
  bool Delete_Class (Am_String classname, bool unique = true);
  bool Rename_Class (Am_String old_name, Am_String new_name, bool unique = true);
  Am_Value_List Get_Class_Names ();

  bool Add_Example (Am_String classname, Am_Feature_Vector fv, bool unique = true);
  bool Delete_Example (Am_String classname, Am_Feature_Vector fv, bool unique = true);
  Am_Value_List Get_Examples (Am_String classname);

  Am_Gesture_Classifier Train();

};

ostream&  operator<< (ostream& s, Am_Gesture_Trainer& gc);
istream&  operator>> (istream& s, Am_Gesture_Trainer& gc);



/// Global initialization routine

void Am_Gesture_Initialize (void);


#endif



