//  locale : headerfile for the free standard C++ library
//  
//  Copyright (C) 1999 by the free standard C++ Library Team
//                        see AUTHORS for more details
//
//  Homepage : http://www.inf.fu-berlin.de/~mkrueger/fscl/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either	
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  version : 0.1 last modified : 17.09.99



#ifndef __CPP_LOCALE
#define __CPP_LOCALE

#include<cstddef>
#include<clocale>
#include<new>

#include<string>
namespace std {
	
	// 22.1.1, class locale : 
	class locale
	{
	    public:
			class facet
			{
				protected:
					explicit facet(size_t refs = 0)
					{
					}
					virtual ~facet()
					{
					}
				private:
					facet(const facet&);          // not defined
					void operator=(const facet&); // not defined
			};

			class id
			{
				public:
					id()
					{
					}
				private:
					void operator=(const id&); // not defined
					id(const id&);             // not defined 
			};

			typedef int category;
			static const category
			none     = 0,
			collate  = 0x010, ctype    = 0x020,
			monetary = 0x040, numeric  = 0x080, time    = 0x100, messages = 0x200,
			all = collate | ctype | monetary | numeric | time  | messages;
			

			// construct / copy / destroy
			locale() throw()
			{
				this->name = "*";
			}
			
			locale(const locale& other) throw()
			{				
				this->name = other.name;
			}
			
			explicit locale(const char* std_name)
			{
				this->name = std_name;
			}
			
			locale(const locale& other, const char* std_name, category cat)
			{
				this->name = std_name;

			}
			
			template <class Facet> 
			locale(const locale& other, Facet* f)
			{
			}
			
			template <class Facet> 
			locale(const locale& other, const locale& one)
			{
			}
			
			locale(const locale& other, const locale& one, category)
			{
			}
			
			~locale() throw()
			{
			}
			
			const locale& operator=(const locale& other) throw()
			{
				return other;			
			}
			

			// locale operations : 
			basic_string<char>  name() const
			{
				return this->name;
			}

			bool operator==(const locale& other) const
			{
			}

			bool operator!=(const locale& other) const
			{
			}

			template <class charT, class Traits, class Allocator>
			bool operator()(const basic_string<charT,Traits,Allocator>& s1, const basic_string<charT,Traits,Allocator>& s2) const
			{
			}

			// global locale objects:
			static       locale  global(const locale&)
			{
			}
			
			static const locale& classic()
			{
			}
		private:
			basic_string<char> name;
	};
	
	template <class Facet> 
	const Facet &use_facet(const locale &loc)
	{
	/*
	1 Get a reference to a facet of a locale.
  Returns:
    a reference to the corresponding facet of loc, if present.
  Throws:
    bad_cast if has_facet<Facet>(*this) is false.
  Notes:
    The reference returned remains valid at least as long as any copy of
    loc exists.


	*/
	}

	template <class Facet> 
	bool         has_facet(const locale &loc) throw()
	{
	/*
	 Returns:
    true if the facet requested is present in loc; otherwise false
	*/
	}
	
	// 22.2.1 and 22.2.1.3, ctype :
	class ctype_base
	{
		public:
			enum mask {
				space = 1 << 0, print = 1 << 1, cntrl = 1 << 2, upper = 1 << 3, 
				lower = 1 << 4,	alpha = 1 << 5, digit = 1 << 6, punct = 1 << 7, 
				xdigit = 1 << 8, alnum = alpha | digit, graph = alnum | punct
			};
    };

	template <class charT> 
	class ctype : public locale::facet, public ctype_base 
	{
		public:
			typedef charT char_type;
			explicit ctype(size_t refs = 0);

			bool         is(mask m, charT c) const
			{
				return do_is(m,c);
			}
			const charT* is(const charT* low, const charT* high, mask* vec) const
			{
				return do_is(low,high,vec);
			}
			const charT* scan_is(mask m, const charT* low, const charT* high) const
			{
				return do_scan_is(m, low, high);
			}
			const charT* scan_not(mask m, const charT* low, const charT* high) const
			{
				return do_scan_not(m, low, high);
			}
			charT        toupper(charT c) const
			{
				return do_toupper(c);
			}
			const charT* toupper(charT* low, const charT* high) const
			{
				return do_toupper(low, high);
			}
			charT        tolower(charT c) const
			{
				return do_tolower(c);				
			}
			const charT* tolower(charT* low, const charT* high) const
			{
				return do_tolower(low, high);
			}
			charT        widen(char c) const
			{
				return do_widen(c);
			}
			const char*  widen(const char* low, const char* high, charT* to) const
			{
				return do_widen(low, high, to);
			}
			char         narrow(charT c, char dfault) const
			{
				return do_narrow(c,dfault);
			}
			const charT* narrow(const charT* low, const charT*, char dfault, char* to) const
			{
				return do_narrow(low,high,dfault,to);
			}
			static locale::id id;
		protected:
			~ctype()
			{
			}

			virtual bool         do_is(mask m, charT c) const
			{
				return false; // DEFAULT
			}

			virtual const charT* do_is(const charT* low, const charT* high, mask* vec) const
			{
				while (low != high)
					do_is(*vec++,*low++);
				return low;
			}
			
			virtual const charT* do_scan_is(mask m, const charT* low, const charT* high) const
			{
				while (low != high) {
					if (do_is(m,*low))
						break;
					low++;
				}
				return low;
			}			
			virtual const charT* do_scan_not(mask m, const charT* low, const charT* high) const
			{
				while (low != high) {
					if (!do_is(m,*low))
						break;
					low++;
				}
				return low;			
			}

			virtual charT        do_toupper(charT c) const
			{
				return c; // DEFAULT
			}
			
			virtual const charT* do_toupper(charT* low, const charT* high) const
			{
				while (low != high)
					do_toupper(*low++);
				return low;			
			}
			
			virtual charT do_tolower(charT c) const
			{
				return c;
			}

			virtual const charT* do_tolower(charT* low, const charT* high) const
			{
				while (low != high)
					do_tolower(*low++);
				return low;
			}
			
			virtual charT        do_widen(char c) const
			{
				return (charT)c;
			}

			virtual const char*  do_widen(const char* low, const char* high, charT* dest) const
			{
				while (low != high)
					*dest++ = do_widen(*low++);
				return low;		
			}
			/*
			 Effects:
				Applies the simplest reasonable transformation from a charT value or
				sequence of charT values to the corresponding char value or  values.
				For any character c in the basic source character set(_lex.charset_)
				the transformation is such that
				  do_widen(do_narrow(c),0) == c
				For any named ctype category with a ctype<char> facet  ctc  however,
				and ctype_base::mask value M,
					(is(M,c) || !ctc.is(M, do_narrow(c),dfault) )"
				is  true  (unless  do_narrow  returns dfault).  In addition, for any
				digit character c, the expression  (do_narrow(c,dfault)-'0')  evalu-
				ates  to  the  digit value of the character.  The second form trans-
				forms each character *p in the range [low, high), placing the result
				(or  dfault  if  no  simple  transformation  is readly available) in
				dest[p-low].
			  Returns:
				The first form returns the transformed value; or dfault if  no  map-
				ping is readily available.  The second form returns high.
			*/
			virtual char         do_narrow(charT c, char dfault) const
			{
				return (char)c;
			}
			virtual const charT* do_narrow(const charT* low, const charT* high, char dfault, char* dest) const
			{
				while (low != high)
					*dest++ = do_narrow(*low++, dfault);
				return low;		
			
			}
	};

	template <>
	class ctype<char> : public locale::facet, public ctype_base
	{
		public:
			typedef char char_type;
			explicit ctype(const mask* tab = 0, bool del = false, size_t refs = 0)
			{
			}
			bool is(mask m, char c) const
			{
			}
			const char* is(const char* low, const char* high, mask* vec) const
			{
			}
			const char* scan_is (mask m, const char* low, const char* high) const
			{
			}
			const char* scan_not(mask m, const char* low, const char* high) const
			{
			}
			char        toupper(char c) const
			{
			}
			const char* toupper(char* low, const char* high) const
			{
			}
			char        tolower(char c) const
			{
			}
			const char* tolower(char* low, const char* high) const
			{
			}
			char  widen(char c) const
			{
			}
			const char* widen(const char* low, const char* high, char* to) const
			{
			}
			char  narrow(char c, char dfault) const
			{
			}
			const char* narrow(const char* low, const char* high, char dfault, char* to) const
			{
			}
			
			static locale::id id;
			static const size_t table_size = 1; // IMPLEMENTATION_DEFINED
		protected:
			const mask* table() const throw();
			static const mask* classic_table() throw()
			{
			}
			virtual ~ctype()
			{
			}
			virtual char        do_toupper(char) const
			{
			}
			virtual char        do_tolower(char) const
			{
			}
	};
	


	template <class charT> 
	class ctype_byname : public ctype<charT>, public ctype_base
	{
		public:
			explicit ctype_byname(const char*, size_t refs = 0)
			{
			}
		protected:
		
			virtual ~ctype_byname()
			{
			}
			
			virtual bool         do_is(mask m, charT c) const
			{
			}
			
			virtual const charT* do_is(const charT* low, const charT* high, mask* vec) const
			{
			}
			
			virtual const char*  do_scan_is(mask m, const charT* low, const charT* high) const
			{
			}
			
			virtual const char*  do_scan_not(mask m, const charT* low, const charT* high) const
			{
			}
			
			virtual charT        do_toupper(charT) const
			{
			}
			
			virtual const charT* do_toupper(charT* low, const charT* high) const
			{
			}
			
			virtual charT        do_tolower(charT) const
			{
			}
			
			virtual const charT* do_tolower(charT* low, const charT* high) const
			{
			}
			
			virtual charT        do_widen(char) const
			{
			}
			
			virtual const char*  do_widen(const char* low, const char* high, charT* dest) const
			{
			}
			
			virtual char         do_narrow(charT, char dfault) const
			{
			}
			
			virtual const charT* do_narrow(const charT* low, const charT* high, char dfault, char* dest) const
			{
			}
	};
	
	template <>
	class ctype_byname<char> : public ctype<char>
	{
		public:
			explicit ctype_byname(const char*, size_t refs = 0);
		protected:
		
			virtual ~ctype_byname()
			{
			}
			
			virtual char        do_toupper(char) const
			{
			}
			
			virtual const char* do_toupper(char* low, const char* high) const
			{
			}
			
			virtual char        do_tolower(char) const
			{
			}
			
			virtual const char* do_tolower(char* low, const char* high) const
			{
			}
	};
	
	class codecvt_base
	{
		public:
			enum result { ok, partial, error, noconv };
    };
	
    template <class internT, class externT, class stateT>
    class codecvt : public locale::facet, public codecvt_base {
		public:
			typedef internT  intern_type;
			typedef externT  extern_type;
			typedef stateT state_type;
			explicit codecvt(size_t refs = 0);
				
			// result is int
			result out(stateT& state, const internT* from, const internT* from_end, const internT*& from_next, externT*   to,       externT* to_limit, externT*& to_next) const;
			result unshift(stateT& state, externT* to, externT* to_limit, externT*& to_next) const;
			result in(stateT& state, const externT* from, const externT* from_end, const externT*& from_next, internT*   to,       internT* to_limit,       internT*& to_next) const;

			int encoding() const throw();
			bool always_noconv() const throw();
			int length(const stateT&, const externT* from, const externT* end, size_t max) const;
			int max_length() const throw();
			static locale::id id;
		protected:
			virtual ~codecvt()
			{
			}
			
			virtual result do_out(stateT& state, const internT* from, const internT* from_end, const internT*& from_next, externT* to, externT* to_limit, externT*& to_next) const;
			virtual result do_unshift(stateT& state, externT* to, externT* to_limit, externT*& to_next) const;
			virtual result do_in(stateT& state, const externT* from, const externT* from_end, const externT*& from_next, internT* to,         internT* to_limit,       internT*& to_next) const;
			virtual int do_encoding() const throw();
			virtual bool do_always_noconv() const throw();
			virtual int do_length(const stateT&, const externT* from, const externT* end,size_t max) const;
			virtual int do_max_length() const throw();
	};
	
	template <class internT, class externT, class stateT>
	class codecvt
	{
	};
	
	template <class internT, class externT, class stateT> 
	class codecvt_byname : public codecvt<internT, externT, stateT>
	{
		public:
			explicit codecvt_byname(const char*, size_t refs = 0);
		protected:
			virtual ~codecvt_byname()
			{
			}
			
			virtual int do_out(stateT& state,const internT* from, const internT* from_end, const internT*& from_next,  externT* to, externT* to_limit, externT*& to_next) const;
			virtual int do_in(stateT& state, const externT* from, const externT* from_end, const externT*& from_next, internT* to, internT* to_limit, internT*& to_next) const;
			virtual int do_encoding() const throw();
			virtual bool do_always_noconv() const throw();
			virtual int do_length(const stateT&, const externT* from, const externT* end, size_t max) const;
			virtual int do_max_length() const throw();
	};

	// 22.2.2 and 22.2.3, numeric :
	
	template <class charT, class InputIterator>  
	class num_get : public locale::facet
	{
		public:
			typedef charT            char_type;
			typedef InputIterator    iter_type;
			explicit num_get(size_t refs = 0);
			iter_type get(iter_type in, iter_type end, ios_base&, ios_base::iostate& err, bool& v) const;
			iter_type get(iter_type in, iter_type end, ios_base&, ios_base::iostate& err, long& v) const;
			iter_type get(iter_type in, iter_type end, ios_base&, ios_base::iostate& err, unsigned short& v) const;
			iter_type get(iter_type in, iter_type end, ios_base&, ios_base::iostate& err, unsigned int& v) const;
			iter_type get(iter_type in, iter_type end, ios_base&, ios_base::iostate& err, unsigned long& v) const;
			iter_type get(iter_type in, iter_type end, ios_base&, ios_base::iostate& err, float& v) const;
			iter_type get(iter_type in, iter_type end, ios_base&, ios_base::iostate& err, double& v) const;
			iter_type get(iter_type in, iter_type end, ios_base&, ios_base::iostate& err, long double& v) const;
			iter_type get(iter_type in, iter_type end, ios_base&, ios_base::iostate& err, void*& v) const;
			static locale::id id;
		protected:
			~num_get();  // virtual
			virtual iter_type do_get(iter_type, iter_type, ios_base&, ios_base::iostate& err, bool& v) const;
			virtual iter_type do_get(iter_type, iter_type, ios_base&, ios_base::iostate& err, long& v) const;
			virtual iter_type do_get(iter_type, iter_type, ios_base&, ios_base::iostate& err, unsigned short& v) const;
			virtual iter_type do_get(iter_type, iter_type, ios_base&, ios_base::iostate& err, unsigned int& v) const;
			virtual iter_type do_get(iter_type, iter_type, ios_base&, ios_base::iostate& err, unsigned long& v) const;
			virtual iter_type do_get(iter_type, iter_type, ios_base&, ios_base::iostate& err, float& v) const;
			virtual iter_type do_get(iter_type, iter_type, ios_base&, ios_base::iostate& err, double& v) const;
			virtual iter_type do_get(iter_type, iter_type, ios_base&, ios_base::iostate& err, long double& v) const;
			virtual iter_type do_get(iter_type, iter_type, ios_base&, ios_base::iostate& err, void*& v) const;
	};
	
	template <class charT, class OutputIterator> 
	class num_put : public locale::facet 
	{
		public:
			typedef charT            char_type;
			typedef OutputIterator   iter_type;
			explicit num_put(size_t refs = 0);
			iter_type put(iter_type s, ios_base& f, char_type fill, bool v) const;
			iter_type put(iter_type s, ios_base& f, char_type fill, long v) const;
			iter_type put(iter_type s, ios_base& f, char_type fill, unsigned long v) const;
			iter_type put(iter_type s, ios_base& f, char_type fill, double v) const;
			iter_type put(iter_type s, ios_base& f, char_type fill, long double v) const;
			iter_type put(iter_type s, ios_base& f, char_type fill, void* v) const;
			static locale::id id;
		protected:
			~num_put();  // virtual
			virtual iter_type do_put(iter_type, ios_base&, char_type fill, bool v) const;
			virtual iter_type do_put(iter_type, ios_base&, char_type fill, long v) const;
			virtual iter_type do_put(iter_type, ios_base&, char_type fill, unsigned long) const;
			virtual iter_type do_put(iter_type, ios_base&, char_type fill, double v) const;
			virtual iter_type do_put(iter_type, ios_base&, char_type fill, long double v) const;
			virtual iter_type do_put(iter_type, ios_base&, char_type fill, void* v) const;
	};
	
	template <class charT>
	class numpunct : public locale::facet
	{
		public:
			typedef charT               char_type;
			typedef basic_string<charT> string_type;
			explicit numpunct(size_t refs = 0);
			char_type    decimal_point()   const;
			char_type    thousands_sep()   const;
			string       grouping()        const;
			string_type  truename()        const;
			string_type  falsename()       const;
			static locale::id id;
		protected:
			~numpunct();  // virtual
			virtual char_type    do_decimal_point() const;
			virtual char_type    do_thousands_sep() const;
			virtual string       do_grouping()      const;
			virtual string_type  do_truename()      const;
			virtual string_type  do_falsename()     const;
	};
	
	template <class charT>
	class numpunct_byname
	{	    
		public:
			explicit numpunct_byname(const char*, size_t refs = 0);
		protected:
			~numpunct_byname();  // virtual
			virtual char_type    do_decimal_point() const;
			virtual char_type    do_thousands_sep() const;
			virtual string       do_grouping()      const;
			virtual string_type  do_truename()      const;  // for bool
			virtual string_type  do_falsename()     const;  // for bool
	};

	// 22.2.4, collation:	
	template <class charT> 
	class collate
	{
		public:
			typedef charT               char_type;
			typedef basic_string<charT> string_type;
			explicit collate(size_t refs = 0);
			int compare(const charT* low1, const charT* high1, const charT* low2, const charT* high2) const;
			string_type transform(const charT* low, const charT* high) const;
			long hash(const charT* low, const charT* high) const;
			static locale::id id;
		protected:
			~collate();
			virtual int do_compare(const charT* low1, const charT* high1, const charT* low2, const charT* high2) const;
			virtual string_type do_transform(const charT* low, const charT* high) const;
			virtual long   do_hash     (const charT* low, const charT* high) const;
	};
	
	template <class charT> 
	class collate_byname : public collate<charT>
	{
		public:
			explicit collate_byname(const char*, size_t refs = 0);
		protected:
			~collate_byname();
			virtual int    do_compare(const charT* low1, const charT* high1, const charT* low2, const charT* high2) const;
			virtual string_type do_transform(const charT* low, const charT* high) const;
			virtual long   do_hash(     const charT* low, const charT* high) const; 
	};
	

	// 22.2.5, date and time :
	class time_base
	{
		public:
			enum dateorder { no_order, dmy, mdy, ymd, ydm };  
	};

	template <class charT, class InputIterator>
	class time_get : public locale::facet, public time_base
	{
		public:
			typedef charT            char_type;
			typedef InputIterator    iter_type;
			explicit time_get(size_t refs = 0);
			dateorder date_order()  const { return do_date_order(); }
			iter_type get_time(iter_type s, iter_type end, ios_base& f, ios_base::iostate& err, tm* t)  const;
			iter_type get_date(iter_type s, iter_type end, ios_base& f, ios_base::iostate& err, tm* t)  const;
			iter_type get_weekday(iter_type s, iter_type end, ios_base& f, ios_base::iostate& err, tm* t) const;
			iter_type get_monthname(iter_type s, iter_type end, ios_base& f, ios_base::iostate& err, tm* t) const;
			iter_type get_year(iter_type s, iter_type end, ios_base& f, ios_base::iostate& err, tm* t\fP) const;
			static locale::id id;
		protected:
			~time_get();  // virtual
			virtual dateorder do_date_order()  const;
			virtual iter_type do_get_time(iter_type s, iter_type end, ios_base&, ios_base::iostate& err, tm* t) const;
			virtual iter_type do_get_date(iter_type s, iter_type end, ios_base&, ios_base::iostate& err, tm* t) const;
			virtual iter_type do_get_weekday(iter_type s, iter_type end, ios_base&, ios_base::iostate& err, tm* t) const;
			virtual iter_type do_get_monthname(iter_type s, ios_base&, ios_base::iostate& err, tm* t) const;
			virtual iter_type do_get_year(iter_type s, iter_type end, ios_base&, ios_base::iostate& err, tm* t) const;
	};
	
	template <class charT, class InputIterator>  
	class time_get_byname : public time_get<charT, InputIterator> 
	{
		public:
			explicit time_get_byname(const char*, size_t refs = 0);
		protected:
			~time_get_byname();  // virtual
			virtual dateorder do_date_order()  const;
			virtual iter_type do_get_time(iter_type s, iter_type end, ios_base&, ios_base::iostate& err, tm* t) const;
			virtual iter_type do_get_date(iter_type s, iter_type end, ios_base&, ios_base::iostate& err, tm* t) const;
			virtual iter_type do_get_weekday(iter_type s, iter_type end, ios_base&, ios_base::iostate& err, tm* t) const;
			virtual iter_type do_get_monthname(iter_type s, iter_type end, ios_base&, ios_base::iostate& err, tm* t) const;
			virtual iter_type do_get_year(iter_type s, iter_type end, ios_base&, ios_base::iostate& err, tm* t) const;
	};
	
	template <class charT, class OutputIterator> 
	class time_put : public locale::facet
	{
		public:
			typedef charT            char_type;
			typedef OutputIterator   iter_type;
			explicit time_put(size_t refs = 0); 			
			iter_type put(iter_type s, ios_base& f, char_type fill, const tm* tmb, const charT* pattern, const charT* pat_end) const;
			iter_type put(iter_type s, ios_base& f, char_type fill, const tm* tmb, char format, char modifier = 0) const;
			static locale::id id;
		protected:
			~time_put();
			virtual iter_type do_put(iter_type s, ios_base&, char_type, const tm* t, char format, char modifier) const; 
	};
	
	template <class charT, class OutputIterator> 
	class time_put_byname : public time_put<charT, OutputIterator>
	{
		public:
			explicit time_put_byname(const char*, size_t refs = 0);
		protected:
			~time_put_byname();
			virtual iter_type do_put(iter_type s, ios_base&, char_type, const tm* t, char format, char modifier) const; 
	};
	

	// 22.2.6, money :
	class money_base
	{
	};
	
	template <class charT, class InputIterator>  
	class money_get
	{
		public:
			typedef charT               char_type;
			typedef InputIterator       iter_type;
			typedef basic_string<charT> string_type;
			explicit money_get(size_t refs = 0);
			iter_type get(iter_type s, iter_type end, bool intl, ios_base& f, ios_base::iostate& err, long double& units) const;
			iter_type get(iter_type s, iter_type end, bool intl, ios_base& f, ios_base::iostate& err, string_type& digits) const;
			static const bool intl = Intl;
			static locale::id id;
		protected:
			~money_get();  // virtual
			virtual iter_type do_get(iter_type, bool, iter_type, ios_base&, ios_base::iostate& err, long double& units) const;
			virtual iter_type do_get(iter_type, bool, iter_type, ios_base&, ios_base::iostate& err, string_type& digits) const;
	};
	
	template <class charT, class OutputIterator> 
	class money_put : public locale::facet
	{
		public:
			typedef charT               char_type;
			typedef OutputIterator      iter_type;
			typedef basic_string<charT> string_type;
			explicit money_put(size_t refs = 0);
			iter_type put(iter_type s, bool intl, ios_base& f, char_type fill, long double units) const;
			iter_type put(iter_type s, bool intl, ios_base& f, char_type fill, const string_type& digits) const;
			static locale::id id;
		protected:
			~money_put();  // virtual
			virtual iter_type do_put(iter_type, bool, ios_base&, char_type fill, long double units) const;
			virtual iter_type do_put(iter_type, bool, ios_base&, char_type fill, const string_type& digits) const;
	};
	
	template <class charT, bool Intl> 
	class moneypunct : public locale::facet, public money_base
	{
		public:
			typedef charT char_type;
			typedef basic_string<charT> string_type;
			explicit moneypunct(size_t refs = 0);
			charT        decimal_point() const;
			charT        thousands_sep() const;
			string       grouping()      const;
			string_type  curr_symbol()   const;
			string_type  positive_sign() const;
			string_type  negative_sign() const;
			int          frac_digits()   const;
			pattern      pos_format()    const;
			pattern      neg_format()    const;
			static locale::id id;
			static const bool intl = International;
		protected:
			~moneypunct();  // virtual
			virtual charT        do_decimal_point() const;
			virtual charT        do_thousands_sep() const;
			virtual string       do_grouping()      const;
			virtual string_type  do_curr_symbol()   const;
			virtual string_type  do_positive_sign() const;
			virtual string_type  do_negative_sign() const;
			virtual int          do_frac_digits()   const;
			virtual pattern      do_pos_format()    const;
			virtual pattern      do_neg_format()    const;
	};
	
	template <class charT, bool Intl> 
	class moneypunct_byname : public moneypunct<charT, Intl>
	{
		public:
			explicit moneypunct_byname(const char*, size_t refs = 0);
		protected:
			~moneypunct_byname();  // virtual
			virtual charT        do_decimal_point() const;
			virtual charT        do_thousands_sep() const;			
			virtual string       do_grouping()      const;
			virtual string_type  do_curr_symbol()   const;
			virtual string_type  do_positive_sign() const;
			virtual string_type  do_negative_sign() const;
			virtual int          do_frac_digits()   const;
			virtual pattern      do_pos_format()    const;
			virtual pattern      do_neg_format()    const; 	
	};
	

	// 22.2.7, message retrieval:
	class messages_base
	{	  
		public:
			typedef int catalog;
	};
	
	template <class charT> 
	class messages : public locale::facet, public messages_base
	{
		public:
			typedef charT char_type;
			typedef basic_string<charT> string_type;
			explicit messages(size_t refs = 0);
			catalog open(const basic_string<char>& fn, const locale&) const;
			string_type  get(catalog c, int set, int msgid, const string_type& dfault) const;
			void    close(catalog c) const;
			static locale::id id;
		protected:
			~messages();  // virtual
			virtual catalog do_open(const basic_string<char>&, const locale&) const;
			virtual string_type  do_get(catalog, int set, int msgid, const string_type& dfault) const;
			virtual void    do_close(catalog) const;
	};
	
	template <class charT> 
	class messages_byname : public messages<charT>
	{
		public:
			explicit messages_byname(const char*, size_t refs = 0);
		protected:
			~messages_byname();  // virtual
			virtual catalog do_open(const basic_string<char>&, const locale&) const;
			virtual string_type  do_get(catalog, int set, int msgid, const string_type& dfault) const;
			virtual void    do_close(catalog) const;
	};

	// 22.1.3, convenience interfaces :
	template <class charT> 
	bool isspace (charT c, const locale& loc)
	{
		return use_facet< ctype<charT> >(loc).is(ctype_base::space, c);
	}

	template <class charT> 
	bool isprint (charT c, const locale& loc)
	{
		return use_facet< ctype<charT> >(loc).is(ctype_base::print, c);
	}

	template <class charT> 
	bool iscntrl (charT c, const locale& loc)
	{
		return use_facet< ctype<charT> >(loc).is(ctype_base::cntrl, c);
	}

	template <class charT> 
	bool isupper (charT c, const locale& loc)
	{
		return use_facet< ctype<charT> >(loc).is(ctype_base::upper, c);
	}

	template <class charT> 
	bool islower (charT c, const locale& loc)
	{
		return use_facet< ctype<charT> >(loc).is(ctype_base::lower, c);
	}

	template <class charT> 
	bool isalpha (charT c, const locale& loc)
	{
		return use_facet< ctype<charT> >(loc).is(ctype_base::alpha, c);
	}

	template <class charT> 
	bool isdigit (charT c, const locale& loc)
	{
		return use_facet< ctype<charT> >(loc).is(ctype_base::digit, c);
	}

	template <class charT> 
	bool ispunct (charT c, const locale& loc)
	{
		return use_facet< ctype<charT> >(loc).is(ctype_base::punct, c);
	}
	
	template <class charT> 
	bool isxdigit(charT c, const locale& loc)
	{
		return use_facet< ctype<charT> >(loc).is(ctype_base::xdigit, c);
	}

	template <class charT> 
	bool isalnum (charT c, const locale& loc)
	{	
		return use_facet< ctype<charT> >(loc).is(ctype_base::alnum, c);
	}
	
	template <class charT> 
	bool isgraph (charT c, const locale& loc)
	{		
		return use_facet< ctype<charT> >(loc).is(ctype_base::graph, c);
	}

	template <class charT> 
	charT toupper(charT c, const locale& loc)
	{
		return use_facet<ctype<charT> >(loc).toupper(c);
	}

	template <class charT> 
	charT tolower(charT c, const locale& loc)
	{
		return use_facet<ctype<charT> >(loc).tolower(c);
	}
}

#endif
