#include <qcombo.h>
#include <qfont.h>
#include <qlcdnum.h>
#include <qlined.h>
#include <qlistbox.h>
#include <qslider.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qwidget.h>

class GuiTools
{
public:

    GuiTools();
    ~GuiTools();
    // the ctor and dtor are declared but never implemented

    //
    // QWidget
    //

    static void SetVisible( QWidget*	widget,
		       bool	visible );
    // show or hide the widget

    static QRect GetGlobalGeometry
    (
	const QWidget*	widget
    );
    // get the geometry rect of the widget in world coordinates
    

    //
    // QListBox
    //

    static void TransferListBox( const QListBox*	source,
				 QListBox*		dest );
    // transfer list from the source list box to the destination


    //
    // QComboBox
    //

    static void TransferListFromCombo( const QComboBox*	source,
				       QListBox*	dest );
    // transfer list from the source combo box to the list box

    static void TransferListToCombo( QComboBox*		dest,
				     const QListBox*	source );
    // transfer list from the source list box to the combo box


    //
    // QLCDNumber
    //

    static QString QLCDNumberSegStyleStr( QLCDNumber::SegmentStyle style );
    // return a string value for the style enumeration

    static QLCDNumber::SegmentStyle QLCDNumberSegStyle( QString	str );
    // return a segment style for the string, default to Outline


    //
    // QLineEdit
    //

    static QString QLineEditEchoModeStr( QLineEdit::EchoMode	mode );
    // return a string value for the echo mode enumeration

    static QLineEdit::EchoMode QLineEditEchoMode( QString	str );
    // return a echo mode for the string, default to Normal


    //
    // QSlider
    //

    static QString QSliderTickSettingStr( QSlider::Orientation	orient,
					  QSlider::TickSetting	tick );
    // return a string value for the tick setting

    static QSlider::TickSetting QSliderTickSetting( QString	str );
    // return a tick setting for the string, default to NoMarks


    //
    // QDialog
    //
    
    static const QStrList& GetQDialogSlots( void );
    // Return a list of slots that are defined by a QDialog


    //
    // QFont
    //

    static QString QFontStyleHintStr( QFont::StyleHint	hint );
    // return a string value for the enumeration

    static QFont::StyleHint QFontStyleHint( QString	str );
    // return the style hint for the string, default to Helvetica

    static QString QFontWeightStr( int	weight );
    // return a string value for the wieght

    static QString QFontCharSetStr( QFont::CharSet	set );
    // return a string value for the set

    static QFont::CharSet QFontCharSet( QString		set );
    // return the char set for the string, default to Latin1


    //
    // QStrList
    //

    static void QStrListAppendAll( QStrList&		dest,
				   const QStrList&	source );
    // append all the items in the source to the destination


private:

    GuiTools( const GuiTools& );
    const GuiTools& operator = ( const GuiTools& );
    
    // no one should ever declare a GuiTools, just use static members

    static QStrList	itsQDialogSlots;
    // slots defined by a QDialog
};
