// $Id: ObjectList.h,v 1.3 1997/11/02 23:00:33 jharris Exp $

#ifndef ObjectList_included
#define ObjectList_included

#include <qlistbox.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qpopmenu.h>

class ProjectWnd;
class Project;
class DlgObject;

class ObjectListItem : public QListBoxItem
{
public:
  ObjectListItem( DlgObject * );

  int height( const QListBox * ) const;
  int width( const QListBox * ) const;

  DlgObject *GetObject();
  void       SetObject( DlgObject * );

  void ToBeSaved( bool );

  bool IsProject(); 
  bool IsInProject(); 

  void ProjectView( bool );
  // Show or hide all objects inside a project

  void ObjectClosed( bool = TRUE );
  // A dialog inside a project is closed, change menu

  bool IsObjectClosed();
  // Is this dialog inside a project closed ?

private:
  void Initialize();

  void paint( QPainter * );

  DlgObject *obj;

  int wItem;
  int hItem;

  static QPixmap *toBeSaved;
  bool saveItem;

  static QPixmap *projectFolded;
  static QPixmap *projectUnfolded;

  bool objAreShown;

  bool objClosed;
};

inline int ObjectListItem::height( const QListBox *lb ) const
{
  lb = lb;
  return hItem;
}

inline int ObjectListItem::width( const QListBox *lb ) const
{
  lb = lb;
  return -1;
}

inline DlgObject *ObjectListItem::GetObject()
{
  return obj;
}

inline void ObjectListItem::SetObject( DlgObject *o )
{
  obj = o;
}

inline void ObjectListItem::ToBeSaved( bool b )
{
  saveItem = b;
}

inline void ObjectListItem::ProjectView( bool s )
{
  objAreShown = s;
}

inline void ObjectListItem::ObjectClosed( bool c )
{
  objClosed = c;
}

inline bool ObjectListItem::IsObjectClosed( )
{
  return objClosed;
}

class ObjectList : public QListBox
{
  Q_OBJECT

public:
  ObjectList( ProjectWnd *, const char * );

  ~ObjectList();

  void Append( DlgObject * );
  // Append a new Object

  void Remove( DlgObject * );
  // Remove an object

  DlgObject *CurrentItem();
  // returns the current item
     
  void AddObjectToProject( Project *prj, DlgObject *obj );
  // Append the object to the list of objects of the project

  void RemoveObjectFromProject( Project *prj, DlgObject *obj );
  // Remove the dialog from the list of dialogs of the project
     
  void ShowChange( bool = TRUE );

  int Contains( const QString& objName );
  // does the list contain a object with this name

  ObjectListItem *GetCurrentListItem();
  ObjectListItem *GetObjectListItem( DlgObject *, Project * = 0 );
  // Various ways to get a ObjectListItem

public slots:
  void Update( DlgObject * );
  // Update a row

  void Saved( DlgObject* );
  // a xxx has been saved

  void ToggleView( Project * );
  // Show or hide the dialogs

private: // Methods
  int FindItem( DlgObject * );

  DlgObject *UnderMouse( int );
  // Get object under mouse (y coordinate)

  void mousePressEvent( QMouseEvent * );
  void mouseReleaseEvent( QMouseEvent * );
  void mouseDoubleClickEvent( QMouseEvent * );
  void mouseMoveEvent( QMouseEvent * );

private: // Attributes
  ProjectWnd *theProjectWnd;
  // Pointer to the surrounding ProjectWnd

  bool showChange;
  // true: Show toBeSaved icon

  DlgObject *objectDragged;
  // used in mouseReleaseEvent to detect if the user dragged an object

  QCursor *dragCursor;
  // Cursor shown when dragging an object
};

inline void ObjectList::ShowChange( bool s )
{
  showChange = s;
}

#endif
