#include "StatusBar.h"

#define Inherited QFrame

StatusBar::StatusBar
(
    int		wndHeight,
    QWidget*	parent,
    const char*	name
)
    :
    Inherited( parent, name ),
    itsHeight( wndHeight )
{
    itsLabelList.setAutoDelete( FALSE );
    
    resize( 1, itsHeight );

    itsLayout = new QBoxLayout( this, QBoxLayout::LeftToRight );
}


StatusBar::~StatusBar()
{
}


uint StatusBar::InsertTextRegion
(
    int		stretch,
    const char*	text
)
{
    QLabel* label = new QLabel( text, this );
    label->setFrameStyle( WinPanel | Sunken );
    label->adjustSize();
    itsLayout->addWidget( label, stretch );
    itsLabelList.append( label );

    if( stretch == 0 )
    {
	label->setFixedSize( label->width(), itsHeight );
    }	

    itsLayout->activate();

    adjustSize();
    
    return itsLabelList.count() - 1;
}


void StatusBar::SetText
(
    uint		region,
    const QString&	text
)
{
    QLabel* label = itsLabelList.at( region );
    if( label )
    {
	label->setText( text );
    }
}


