#include <qchkbox.h> 

#include "CheckBoxPage.h"

#include "widget/DlgWidget.h"

#define Inherited CheckBoxPageData

CheckBoxPage::CheckBoxPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    const QCheckBox* button = (const QCheckBox*)widget->GetWidget();
	
    itsText->setText( button->text() );
    isAutoRepeat->setChecked( button->autoRepeat() );
    isAutoResize->setChecked( button->autoResize() );
    isChecked->setChecked( button->isChecked() );
}


CheckBoxPage::~CheckBoxPage()
{
}


void CheckBoxPage::Apply( DlgWidget*	widget )
{
    QCheckBox* button = (QCheckBox*)widget->GetWidget();
    
    button->setText( itsText->text() );
    button->setAutoRepeat( isAutoRepeat->isChecked() );
    button->setAutoResize( isAutoResize->isChecked() );
    button->setChecked( isChecked->isChecked() );
}
