#include <qradiobt.h> 

#include "RadioButtonPage.h"

#include "widget/DlgWidget.h"

#define Inherited RadioButtonPageData

RadioButtonPage::RadioButtonPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    const QRadioButton* button = (const QRadioButton*)widget->GetWidget();
	
    itsText->setText( button->text() );
    isAutoRepeat->setChecked( button->autoRepeat() );
    isAutoResize->setChecked( button->autoResize() );
    isChecked->setChecked( button->isChecked() );
}


RadioButtonPage::~RadioButtonPage()
{
}


void RadioButtonPage::Apply( DlgWidget*	widget )
{
    QRadioButton* button = (QRadioButton*)widget->GetWidget();
    
    button->setText( itsText->text() );
    button->setAutoRepeat( isAutoRepeat->isChecked() );
    button->setAutoResize( isAutoResize->isChecked() );
    button->setChecked( isChecked->isChecked() );
}


