#ifndef WidgetVarMapPage_included
#define WidgetVarMapPage_included

#include <qlist.h>
#include <qstrlist.h>

#include "widget/DlgWidget.h"

#include "WidgetVarMapPageData.h"

class DlgWidget;
class SignalConnection;

class WidgetVarMapPage : public WidgetVarMapPageData
{
    Q_OBJECT

public:

    WidgetVarMapPage
    (
	DlgWidget* widget,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~WidgetVarMapPage();

    void Apply( DlgWidget*	widget );
    // apply changes to the widget

private slots:

    void Update();
    // update dialog after an event occurs

    void SignalChanged(int);

    void SignalSelected(int);

    void AddSignal();
    void ModifySignal();
    void DeleteSignal();
    
    
private:

    QStrList	itsSignals;
    // list of possible signals that can be connected

};
#endif // WidgetVarMapPage_included
