#include "widget/DlgCheckBox.h"
#include "widget/DlgButton.h"

#include "prop/CheckBoxPage.h"

#include "GuiTools.h"

#define Inherited DlgWidget

int DlgCheckBox::itsNextWidgetNum = 1;

DlgCheckBox::DlgCheckBox
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_CheckBox, parent )
{
    itsWidget = new CheckBox( parent, CreateName( "CheckBox", name, 
						  itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgCheckBox::~DlgCheckBox()
{
}


void DlgCheckBox::GetPropertyPages
(
    QWidget*		parent,
    QList<QWidget>&	pages,
    QStrList&		labels
)
{
    pages.append( new CheckBoxPage( this, parent, "Check Box" ) );
    
    labels.append( "Check Box" );
}


void DlgCheckBox::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nCheckBox {";
  
    DlgCheckBox::SaveQt( stream, (const QCheckBox *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgCheckBox::SaveQt
(
   QTextStream &stream,
   const QCheckBox *widget
)
{
    stream << "\n\t\tChecked {";
    SaveBool( stream, widget->isChecked() );
    stream << "}";

    DlgButton::SaveQt( stream, widget );
}

bool DlgCheckBox::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( key == "Name" )
  {
      // Update the widget number so that no duplicate names are created
      UpdateNextWidgetNumber( value, itsNextWidgetNum );
  }

  if( ! DlgCheckBox::RestoreQt( key, value, (QCheckBox *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgCheckBox::RestoreQt
(
   const QString &key,
   const QString &value,
   QCheckBox *widget
)
{
    bool ret = TRUE;

    if( key == "Checked" )
    {
	widget->setChecked( (value == "TRUE") );
    }
    else
    {
	ret = DlgButton::RestoreQt( key, value, widget );
    }
    
    return ret;
}  


void DlgCheckBox::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgButton::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QCheckBox* check = (const QCheckBox*)dlgWidget.GetWidget();
    
    if( check->isChecked() )
    {
	stream << varName << "setChecked( TRUE );\n";
    }
}


void DlgCheckBox::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, DlgButton::GetSignalList() );
}









