#ifndef DlgPushButton_included
#define DlgPushButton_included

#include <qstring.h>

#include "widget/DlgWidget.h"
#include "widget/PushButton.h"

class DlgPushButton : public DlgWidget
{

public:

    DlgPushButton
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgPushButton();
    
    virtual QWidget* GetWidget( void ) const;
    // return the DlgPushButton's widget

    virtual void GetPropertyPages
    (
	QWidget*		parent,
	QList<QWidget>&		pages,
	QStrList&		labels
    );
    // Get the property pages and their labels for the widget

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QPushButton *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QPushButton *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes. varName already
    // has a leading tab and the correct dereferencer

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source


    virtual void AddSignalsToList( QStrList&	signalList ) const;
    // add signals specific to a particular widget type to the list
    
private:

    PushButton*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgPushButton::GetWidget( void ) const
{
    return itsWidget;
}


inline QString DlgPushButton::GetHeaderFilename() const
{
    return "<qpushbt.h>";
}

inline QString DlgPushButton::GetWidgetClass() const
{
    return "QPushButton";
}

inline void DlgPushButton::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}



#endif // DlgPushButton_included
