#include <qapp.h>
#include <qpalette.h>
#include <qregexp.h>

#include "widget/DlgWidget.h"
#include "widget/DlgButton.h"
#include "widget/DlgButtonGroup.h"
#include "widget/DlgCheckBox.h"
#include "widget/DlgComboBox.h"
#include "widget/DlgFrame.h"
#include "widget/DlgGroupBox.h"
#include "widget/DlgLCDNumber.h"
#include "widget/DlgLabel.h"
#include "widget/DlgLineEdit.h"
#include "widget/DlgListBox.h"
#include "widget/DlgMenuBar.h"
#include "widget/DlgMultiLineEdit.h"
#include "widget/DlgProgressBar.h"
#include "widget/DlgPushButton.h"
#include "widget/DlgRadioButton.h"
#include "widget/DlgScrollBar.h"
#include "widget/DlgSlider.h"
#include "widget/DlgUser.h"

#include "prop/WidgetPropDialog.h"

DlgWidget::DlgWidget
(
    Type	type,
    QWidget*	origParent	
)
    :
    itsType( type ),
    itsLayoutStatus( NoLayout ),
    itsOriginalParent( origParent )
{
    itsConnectedSignalList.setAutoDelete( TRUE );
}


DlgWidget::~DlgWidget()
{
    itsConnectedSignalList.clear();
}

DlgWidget *DlgWidget::NewDlgWidget( QWidget *parent,
				    DlgWidget::Type type,
				    const QString *name )
{
    DlgWidget *newWidget = NULL;

    const char *theName = NULL;

    if( name )
	theName = *name;

    switch( type )
    {
	case DlgWidget::DW_Button:
	{
	    newWidget = new DlgButton( parent, theName );
	    break;
	}
	case DlgWidget::DW_ButtonGroup:
	{
	    newWidget = new DlgButtonGroup( parent, theName );
	    break;
	}
	case DlgWidget::DW_CheckBox:
	{
	    newWidget = new DlgCheckBox( parent, theName );
	    break;
	}
	case DlgWidget::DW_ComboBox:
	{
	    newWidget = new DlgComboBox( parent, theName );
	    break;
	}
	case DlgWidget::DW_Frame:
	{
	    newWidget = new DlgFrame( parent, theName );
	    break;
	}
	case DlgWidget::DW_GroupBox:
	{
	    newWidget = new DlgGroupBox( parent, theName );
	    break;
	}
	case DlgWidget::DW_LCDNumber:
	{
	    newWidget = new DlgLCDNumber( parent, theName );
	    break;
	}
	case DlgWidget::DW_Label:
	{
	    newWidget = new DlgLabel( parent, theName );
	    break;
	}
	case DlgWidget::DW_LineEdit:
	{
	    newWidget = new DlgLineEdit( parent, theName );
	    break;
	}
	case DlgWidget::DW_ListBox:
	{
	    newWidget = new DlgListBox( parent, theName );
	    break;
	}
	case DlgWidget::DW_MenuBar:
	{
	    newWidget = new DlgMenuBar( parent, theName );
	    break;
	}
	case DlgWidget::DW_MultiLineEdit:
	{
	    newWidget = new DlgMultiLineEdit( parent, theName );
	    break;
	}	
	case DlgWidget::DW_ProgressBar:
	{
	    newWidget = new DlgProgressBar( parent, theName );
	    break;
	}
	case DlgWidget::DW_PushButton:
	{
	    newWidget = new DlgPushButton( parent, theName );
	    break;
	}
	case DlgWidget::DW_RadioButton:
	{
	    newWidget = new DlgRadioButton( parent, theName );
	    break;
	}
	case DlgWidget::DW_ScrollBar:
	{
	    newWidget = new DlgScrollBar( parent, theName );
	    break;
	}
	case DlgWidget::DW_Slider:
	{
	    newWidget = new DlgSlider( parent, theName );
	    break;
	}
	case DlgWidget::DW_User:
	{
	    newWidget = new DlgUser( parent, theName );
	    break;
	}
	case DlgWidget::DW_None:
	{
	    break;
	}
    }

    return newWidget;
}

DlgWidget *DlgWidget::NewDlgWidget( QWidget *parent, 
				    const QString &type, 
				    const QString *name )
{
    DlgWidget *newWidget = NULL;

    const char *theName = NULL;

    if( name )
	theName = *name;

    if( type == "Button" )
	newWidget = new DlgButton( parent, theName );
    else if( type == "ButtonGroup" )
	newWidget = new DlgButtonGroup( parent, theName );
    else if( type == "CheckBox" )
	newWidget = new DlgCheckBox( parent, theName );
    else if( type == "ComboBox" )
	newWidget = new DlgComboBox( parent, theName );
    else if( type == "Frame" )
	newWidget = new DlgFrame( parent, theName );
    else if( type == "GroupBox" )
	newWidget = new DlgGroupBox( parent, theName );
    else if( type == "LCDNumber" )
	newWidget = new DlgLCDNumber( parent, theName );
    else if( type == "Label" )
	newWidget = new DlgLabel( parent, theName );
    else if( type == "LineEdit" )
	newWidget = new DlgLineEdit( parent, theName );
    else if( type == "ListBox" )
	newWidget = new DlgListBox( parent, theName );
    else if( type == "MenuBar" )
	newWidget = new DlgMenuBar( parent, theName );
    else if( type == "MultiLineEdit" )
	newWidget = new DlgMultiLineEdit( parent, theName );
    else if( type == "ProgressBar" )
	newWidget = new DlgProgressBar( parent, theName );
    else if( type == "PushButton" )
	newWidget = new DlgPushButton( parent, theName );
    else if( type == "RadioButton" )
	newWidget = new DlgRadioButton( parent, theName );
    else if( type == "ScrollBar" )
	newWidget = new DlgScrollBar( parent, theName );
    else if( type == "Slider" )
	newWidget = new DlgSlider( parent, theName );
    else if( type == "User" )
	newWidget = new DlgUser( parent, theName );

    return newWidget;
}


QPoint DlgWidget::GetPos( void ) const
{
    QWidget* widget = GetWidget();
    return itsOriginalParent->mapFromGlobal(widget->mapToGlobal(QPoint(0,0)));
}


int DlgWidget::DoPropertyDialog
(
    BoxLayout*	layout
)
{
    WidgetPropDialog dlg( this, layout, NULL /*GetWidget()*/, "Properties" );
    
    int rc = dlg.exec();
    
    GetWidget()->update();
    
    return rc;
}


QString DlgWidget::GetGeneratedVarName( void ) const
{
    QString str = "dlgedit_";
    
    if( IsVariableMapped() )
    {
	str = GetVariableName();
    }
    else
    {
	str += GetWidgetName();
    }

    return str;
}


void DlgWidget::SetInLayout
(
    QWidget*	newParent,
    bool	isMenuBar
)
{
    if( isMenuBar )
    {
	itsLayoutStatus = LayoutMenuBar;
    }
    else
    {
	itsLayoutStatus = InLayout;
    }
    
    GetWidget()->recreate( newParent, 0, QPoint( 0,0 ), TRUE );
}


void DlgWidget::RemoveFromLayout( void )
{
    itsLayoutStatus = NoLayout;
    
    QWidget* widget = GetWidget();
    QPoint pos = 
	itsOriginalParent->mapFromGlobal( widget->mapToGlobal( QPoint(0,0) ) );
    
    widget->recreate( itsOriginalParent, 0, pos, TRUE );

    widget->setMinimumSize( 0,0 );
    widget->setMaximumSize( QCOORD_MAX,QCOORD_MAX );
}


void DlgWidget::SaveContents(	QTextStream&	stream )
{
  QWidget *theWidget = GetWidget();
    
  if( ! theWidget )
    return;

  // No superclasses here
  SaveQt( stream, theWidget );
}



bool DlgWidget::RestoreKeyValue( QString &key, QString &value )
{
  // No superclasses here
  DlgWidget::RestoreQt( key, value, GetWidget() );

  // For now we say ok to everything.
  // XXXX Should be fixed soon
  return TRUE;
}

void DlgWidget::SaveQt( QTextStream &stream, const QWidget *widget )
{
    stream << "\n\t\tRect {" << widget->geometry() << "}";
    stream << "\n\t\tName {" << widget->name() << "}";

    if( IsVariableMapped() )
    {
	stream << "\n\t\tVariable {" << itsVariableName << "}";
    }

    // user changed palette
    const QPalette palette = widget->palette();
    if( palette != *QApplication::palette() )
    {
	stream << "\n\t\tPalette {" << palette << "}";
    }

    // user changed font
    const QFont font = widget->font();
    if( font != *QApplication::font() )
    {
	stream << "\n\t\tFont {" << font << "}";
    }

    QListIterator<SignalConnection> iter( itsConnectedSignalList );
    SignalConnection* sig;
    
    while( (sig = iter()) )
    {
	stream << "\n\t\tSignal {" << sig->ToString() << "}";
    }

    stream << "\n\t\tLayoutStatus {";
    switch( itsLayoutStatus )
    {
	case NoLayout:
	{
	    stream << "NoLayout";
	    break;
	}
	case InLayout:
	{
	    stream << "InLayout";
	    break;
	}
	case LayoutMenuBar:
	{
	    stream << "LayoutMenuBar";
	    break;
	}
    }
    stream << "}";

    stream << "\n\t\tMinimumSize {" << widget->minimumSize() << "}";
    stream << "\n\t\tMaximumSize {" << widget->maximumSize() << "}";    
}

bool DlgWidget::RestoreQt
( 
 const QString &key, 
 const QString &value,
 QWidget *widget
 )
{
    bool rc = TRUE;

    QTextStream read( value, IO_ReadOnly );

    if( key == "Name" )
    {
	widget->setName( value );
    } 
    else if( key == "Rect" )
    {
	QRect aRect;
	read >> aRect;
	widget->setGeometry( aRect );
    } 
    else if( key == "Variable" )
    {
	itsVariableName = value;
    }
    else if( key == "Palette" )
    {
	QPalette palette;
	read >> palette;
	widget->setPalette( palette );
    }
    else if( key == "Font" )
    {
	QFont font;
	read >> font;
	widget->setFont( font );
    }
    else if( key == "Signal" )
    {
	SignalConnection* sig = new SignalConnection;
	sig->FromString( value );
	
	itsConnectedSignalList.append( sig );
    }
    else if( key == "LayoutStatus" )
    {
	if( value == "NoLayout" )
	{
	    itsLayoutStatus = NoLayout;
	}
	else if( value == "InLayout" )
	{
	    itsLayoutStatus = InLayout;
	}
	else if( value == "LayoutMenuBar" )
	{
	    itsLayoutStatus = LayoutMenuBar;
	}
	else
	{
	    rc = FALSE;
	}
	
    }
    else if( key == "MinimumSize" )
    {
	QSize size;
	read >> size;
	widget->setMinimumSize( size );
    }
    else if( key == "MaximumSize" )
    {
	QSize size;
	read >> size;
	widget->setMaximumSize( size );
    }
    else
    {
	// Key unknown
	rc = FALSE;
    }
    
    return rc;
}


void DlgWidget::GenerateCtor
(
    QTextStream&	stream,
    const QString&	varName
)
{
    QString name;
    const char* cp = GetWidget()->name();
    if( cp )
    {
	name = "\"";
	name += cp;
	name += "\"";
    }
    else
    {
	name = "NULL";
    }

//     if( IsVariableMapped() )
//     {
// 	stream << '\t' << varName << "( parent, " << name << " )";
//     }
//     else
    {
	stream << '\t' << varName << " = new " << GetWidgetClass() <<
	    "( this, " << name << " );\n";
    }
}


void DlgWidget::GenerateExtraSource( QTextStream&		,//stream,
				     const QString&		,//varName,
				     const QList<DlgWidget>&	)//zOrdering )
{
    // do nothing
}


void DlgWidget::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	//zOrdering
)
{
    const QWidget* widget = dlgWidget.GetWidget();

    stream << varName << "setGeometry( " << 
	widget->x() << ", " << widget->y() << ", " << widget->width() << 
	", " << widget->height() << " );\n";

    QSize size = widget->minimumSize();
    stream << varName << "setMinimumSize( " << size.width() << ", " << 
	size.height() << " );\n";
	
    size = widget->maximumSize();
    stream << varName << "setMaximumSize( " << size.width() << ", " <<
	size.height() << " );\n";

    const QPalette palette = widget->palette();
    if( palette != *QApplication::palette() )
    {
	stream << "\t{\n";
	stream << "\t\tQColorGroup normal( "
	    "QColor( QRgb(" << palette.normal().foreground().rgb() << ") ), "
	    "QColor( QRgb(" << palette.normal().background().rgb() << ") ), "
	    "QColor( QRgb(" << palette.normal().light().rgb() << ") ), "
	    "QColor( QRgb(" << palette.normal().dark().rgb() << ") ), "
	    "QColor( QRgb(" << palette.normal().mid().rgb() << ") ), "
	    "QColor( QRgb(" << palette.normal().text().rgb() << ") ), "
	    "QColor( QRgb(" << palette.normal().base().rgb() << ") ) );\n";
	stream << "\t\tQColorGroup disabled( "
	    "QColor( QRgb(" << palette.disabled().foreground().rgb() << ") ), "
	    "QColor( QRgb(" << palette.disabled().background().rgb() << ") ), "
	    "QColor( QRgb(" << palette.disabled().light().rgb() << ") ), "
	    "QColor( QRgb(" << palette.disabled().dark().rgb() << ") ), "
	    "QColor( QRgb(" << palette.disabled().mid().rgb() << ") ), "
	    "QColor( QRgb(" << palette.disabled().text().rgb() << ") ), "
	    "QColor( QRgb(" << palette.disabled().base().rgb() << ") ) );\n";
	stream << "\t\tQColorGroup active( "
	    "QColor( QRgb(" << palette.active().foreground().rgb() << ") ), "
	    "QColor( QRgb(" << palette.active().background().rgb() << ") ), "
	    "QColor( QRgb(" << palette.active().light().rgb() << ") ), "
	    "QColor( QRgb(" << palette.active().dark().rgb() << ") ), "
	    "QColor( QRgb(" << palette.active().mid().rgb() << ") ), "
	    "QColor( QRgb(" << palette.active().text().rgb() << ") ), "
	    "QColor( QRgb(" << palette.active().base().rgb() << ") ) );\n";
	stream << "\t\tQPalette palette( normal, disabled, active );\n";
	stream << "\t" << varName << "setPalette( palette );\n";
	stream << "\t}\n";
    }

    const QFont font = widget->font();
    if( font != *QApplication::font() )
    {
	stream << "\t{\n";
	stream << "\t\tQFont font( \"" << 
	    font.family() << "\", " <<
	    font.pointSize() << ", " <<
	    font.weight() << ", " <<
	    font.italic() << " );\n";
	if( font.underline() )
	{
	    stream << "\t\tfont.setUnderline( TRUE );\n";
	}
	if( font.strikeOut() )
	{
	    stream << "\t\tfont.setStrikeOut( TRUE );\n";
	}
	if( font.fixedPitch() )
	{
	    stream << "\t\tfont.setFixedPitch( TRUE );\n";
	}
	stream << "\t\tfont.setStyleHint( (QFont::StyleHint)" << 
	    font.styleHint() << " );\n";
	stream << "\t\tfont.setCharSet( (QFont::CharSet)" << 
	    font.charSet() << " );\n";
	stream << "\t" << varName << "setFont( font );\n";
	stream << "\t}\n";
    }

    QListIterator<SignalConnection> iter( dlgWidget.GetConnectedSignalList() );
    SignalConnection* sig;
    QString dot = dlgWidget.Dot();

    // remove the initial tab and the . or -> from the variable name to use 
    // in the connect statement
    QString name = varName.right( varName.length() - 1 );
    name = name.left( name.length() - dot.length() );
    
    while( (sig = iter()) )
    {
	stream << "\tconnect( " << name << ", "
	    "SIGNAL(" << sig->GetSignal() << "), "
	    "SLOT(" << sig->GetSlot() << ") );\n";
    }
}

QString DlgWidget::CreateName( QString className, 
                               const char *name, 
                               int &number )
{
  QString tmp;

  if( ! name )
  {
    tmp.setNum( number );
    tmp = className + QString( "_" ) + tmp;
    number++;
  } else
  {
    tmp = name;
  }

  return tmp;
}


void DlgWidget::UpdateNextWidgetNumber( const QString&	widgetName,
					int&		nextWidgetNum ) const
{
    int pos = widgetName.findRev( '_' );

    if( pos >= 0 )
    {
	QString numStr = widgetName.mid( pos + 1, 
					 widgetName.length() - pos - 1 );

	int num = numStr.toInt();
	if( num >= nextWidgetNum )
	{
	    nextWidgetNum = num + 1;
	}
    }    
}


const char* DlgWidget::Dot() const
{
    // all variables are now dynamically created
    //return IsVariableMapped() ? "." : "->";
    return "->";
}


void DlgWidget::GetSignalList( QStrList& signalList ) const
{
    signalList.clear();
    
    AddSignalsToList( signalList );
}


void DlgWidget::AddSignalsToList
( 
    QStrList&	// signalList
) const 
{
}


QTextStream& operator <<( QTextStream&	ostream,
			  const QSize&	size )
{
    ostream << size.width() << ' ' << size.height();
    
    return ostream;
}


QTextStream& operator >>( QTextStream&	istream,
			  QSize&	size )
{
    istream >> size.rwidth() >> size.rheight();
    
    return istream;
}


QTextStream& operator <<( QTextStream&	ostream,
			  const QPoint&	point )
{
    ostream << point.x() << ' ' << point.y();
    
    return ostream;
}


QTextStream& operator >>( QTextStream&	istream,
			  QPoint&	point )
{
    istream >> point.rx() >> point.ry();
    
    return istream;
}


QTextStream& operator <<
(
    QTextStream&	ostream,
    const QRect&	rect
 )
{
    ostream << rect.left() << ' ' << rect.top() << ' ' <<
    rect.width() << ' ' << rect.height();
    
    return ostream;
}


QTextStream& operator >>
(
    QTextStream&	istream,
    QRect&		rect
)
{
    int left, top, width, height;
    
    istream >> left;
    istream >> top;
    istream >> width;
    istream >> height;
    
    rect.setRect( left, top, width, height );
    
    return istream;
}


// write palette to text stream
QTextStream& operator <<
(
    QTextStream&	ostream,
    const QPalette&	palette
)
{
    ostream << 
	palette.normal() << ' ' <<
	palette.disabled() << ' ' <<
	palette.active();
    
    return ostream;
}


// read palette from stream
QTextStream& operator >>
(
    QTextStream&	istream,
    QPalette&		palette
)
{
    QColorGroup normal, disabled, active;
    
    istream >> normal >> disabled >> active;
    
    palette.setNormal( normal );
    palette.setDisabled( disabled );
    palette.setActive( active );

    return istream;
}


QTextStream& operator <<
(
    QTextStream&	ostream,
    const QColorGroup&	group
)
{
    ostream << 
	group.foreground().rgb() << ' ' <<
	group.background().rgb() << ' ' <<
	group.light().rgb() << ' ' <<
	group.dark().rgb() << ' ' <<
	group.mid().rgb() << ' ' <<
	group.text().rgb() << ' ' <<
	group.base().rgb();
    
    return ostream;
}


QTextStream& operator >>
(
    QTextStream&	istream,
    QColorGroup&	group
)
{
    QRgb fore, back, light, dark, mid, text, base;
    
    istream >> fore >> back >> light >> dark >> mid >> text >> base;
    
    QColor foreColor(fore);
    QColor backColor(back);
    QColor lightColor(light);
    QColor darkColor(dark);
    QColor midColor(mid);
    QColor textColor(text);
    QColor baseColor(base);
    
    QColorGroup newcg( foreColor, backColor, lightColor, darkColor,
		       midColor, textColor, baseColor );

    group = newcg;
    
    return istream;
}
  

QTextStream& operator <<
(
    QTextStream&	ostream,
    const QFont&	font
)
{
    ostream << '\"' << font.family() << "\" " <<
	font.pointSize() << ' ' <<
	font.weight() << ' ' <<
	(int)font.italic() << ' ' <<
	(int)font.underline() << ' ' <<
	(int)font.strikeOut() << ' ' <<
	(int)font.fixedPitch() << ' ' <<
	(int)font.styleHint() << ' ' <<
	(int)font.charSet();

    return ostream;
}


QTextStream& operator >>
(
    QTextStream&	istream,
    QFont&		font
)
{
    QString family, str;
    
    // since family name might have spaces in it, loop until you get the 
    // closing quote which encloses the name
    do
    {
	istream >> str;
	family += str;
    } while( str[str.length() - 1] != '\"' );
    
    // remove leading and trailing "'s
    family = family.mid( 1, family.length()-2 );
    
    font.setFamily( family );

    int n;
    
    istream >> n;
    font.setPointSize( n );
    
    istream >> n;
    font.setWeight( n );
    
    istream >> n;
    font.setItalic( n );
    
    istream >> n;
    font.setUnderline( n );

    istream >> n;
    font.setStrikeOut( n );
    
    istream >> n;
    font.setFixedPitch( n );
    
    istream >> n;
    font.setStyleHint( (QFont::StyleHint)n );
    
    istream >> n;
    font.setCharSet( (QFont::CharSet)n );

    return istream;
}


void SaveBool
(
 QTextStream&	ostream,
 const bool&	b
 )
{
  ostream << (b ? "TRUE" : "FALSE");
}


void RestoreBool
(
    QTextStream&	istream,
    bool&		b
)
{
  QString aStr;

  istream >> aStr;
  if( aStr == "TRUE" )
    b = TRUE;
  else
    b = FALSE;
}
