#include "figure.hh"
#include "pencil.hh"
#include <cmath>

void 
TFigCircle::paint(TPencil &pen, bool)
{
	pen.SetLineColor(line_color);
	if (!filled) {
		pen.DrawCircle(x,y,w,h);
	} else {
		pen.SetFillColor(fill_color);
		pen.FillCircle(x,y,w,h);
	}
}

double 
TFigCircle::distance(double mx, double my)
{
	double rx = 0.5*w;
	double ry = 0.5*h;
	double cx = (double)x+rx;
	double cy = (double)y+ry;
	double dx = (double)mx - cx;
	double dy = (double)my - cy;
	
	double phi = atan( (dy*rx) / (dx*ry) );
	if (dx<0.0)
		phi=phi+M_PI;
	double ex = rx*cos(phi);
	double ey = ry*sin(phi);
	if (filled) {
		double d = sqrt(dx*dx+dy*dy)-sqrt(ex*ex+ey*ey);
		if (d<0.0)
			return INSIDE;
		return d;
	}
	dx -= ex;
	dy -= ey;
	return sqrt(dx*dx+dy*dy);
}
