/*
 * TPaint -- a simple bitmap editor
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <toad/toad.hh>
#include <toad/dragndrop.hh>
#include <toad/dialog.hh>
#include <toad/pushbutton.hh>
#include <toad/textfield.hh>
#include <toad/scrollbar.hh>

#include "ColorEditor.hh"

extern TColor color[1];

TColorEditor::TColorEditor(TWindow *p,const string &t)
	:super(p,t)
{
	#warning "had to modify bShell to enabled DnD in MDI child"
	/*
		the problem is that the DnD information isn't move forward to the
		top level window when TColorEditor loses it's bShellFlag
	*/
	bShell=false;

	TDropSiteColor *dsc = new TDropSiteColor(this, TRectangle(70,40,80,80));
	CONNECT(dsc->sigDrop, this, dropColor);

	bFocusManager = true;
	SetBackground(TColor::DIALOG);

	color.r=0;
	color.g=0;
	color.b=0;
    SetSize(220,160);

	TPushButton *btn;
	btn = new TPushButton(this,"Apply",ID_APPLY);
		OLD_CONNECT(this,sigApply, btn,btn->sigActivate);

	TScrollBar *wnd;
	TTextField *tf;

	wnd = new TVScrollBar(this, "R", &color.r);
		OLD_CONNECT(this,changed, wnd,wnd->sigValueChanged);
		wnd->SetRange(0,255);
		wnd->SetVisible(1);
		wnd->SetDirect(true);

	wnd = new TVScrollBar(this, "G", &color.g);
		OLD_CONNECT(this,changed, wnd,wnd->sigValueChanged);
		wnd->SetRange(0,255);
		wnd->SetVisible(1);
		wnd->SetDirect(true);

	wnd = new TVScrollBar(this, "B", &color.b);
		OLD_CONNECT(this,changed, wnd,wnd->sigValueChanged);
		wnd->SetRange(0,255);
		wnd->SetVisible(1);
		wnd->SetDirect(true);

	tf = new TTextField(this,"red.tf", &color.r);
		tf->SetDirect(true);
	tf = new TTextField(this,"green.tf", &color.g);
		tf->SetDirect(true);
	tf = new TTextField(this,"blue.tf", &color.b);
		tf->SetDirect(true);
		
	DoLayout("TColorEditor");
}

void TColorEditor::mouseMDown(int,int,unsigned m)
{
	StartDrag(new TDnDColor(color), m);
}

void TColorEditor::dropColor(PDnDColor dc)
{
	color = dc->rgb;
	TPen pen(this);

	pen.SetColorMode(TColor::DITHER);
	pen.SetColor(color.r,color.g,color.b);
	pen.FillRectangle(70,40,80,80);

	TDataManipulator::Assimilate(&color.r);
	TDataManipulator::Assimilate(&color.g);
	TDataManipulator::Assimilate(&color.b);
}

void TColorEditor::paint()
{
	super::paint();
	TPen pen(this);

	pen.SetColorMode(TColor::DITHER125);
	pen.SetColor(color.r,color.g,color.b);
	pen.FillRectangle(70,40,80,80);
}

void TColorEditor::changed()
{
	Invalidate(false);
}

void TColorEditor::sigApply()
{
	::color[0]=color;
}
