/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996,97 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TButtonBase
#define TButtonBase TButtonBase

#include <toad/labelowner.hh>

class TButtonBase: public TLabelOwner
{
		typedef TLabelOwner super;
	public:
		TButtonBase(TWindow *p, const string &t);
		~TButtonBase();
		virtual void SetDown(bool down=true);
		bool IsDown();
		bool LoadBitmap(const string&);
		TSignal sigActivate;
		TSignal sigArm, sigDisarm;

	protected:
		TBitmap *bitmap;
		bool bDown,bInside;
		void DrawShadow(TPen&,bool);
		void DrawText(TPen&,const string&,bool,bool bEnabled=true);
};

inline bool TButtonBase::IsDown(){return bDown;}

#endif
