/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-98 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/datainterface.hh>
#include <toad/datastorage.hh>

#include <cstdio>
#include <cstdlib>

void* TDataInterface::_global = NULL;

// string interface
//---------------------------------------------------------------------------

class TDI_string_string:
	public TStringInterface, public TStringStorage
{
	public:
		TDI_string_string(string *data) {
			_data = data;
		}
	protected:
		void Write(const string &data, void* ptr) {
			*safe_cast(ptr) = data;
		}
		string Read(const void* ptr) const {
			return *safe_cast(ptr);
		}
};

TStringInterface* NewStringInterface(string *d) {
	return new TDI_string_string(d);
}

class TDI_string_int:
	public TStringInterface, public TIntStorage
{
	public:
		TDI_string_int(int *data) {
			_data = data;
		}
	protected:
		void Write(const string &data, void* ptr) {
			*safe_cast(ptr) = atoi(data.c_str());
		}
		string Read(const void* ptr) const {
			char buffer[255];
			sprintf(buffer, "%i", *safe_cast(ptr));
			return buffer;
		}
};

TStringInterface* NewStringInterface(int *d) {
	return new TDI_string_int(d);
}

class TDI_string_unsigned:
	public TStringInterface, public TUnsignedStorage
{
	public:
		TDI_string_unsigned(unsigned *data) {
			_data = data;
		}
	protected:
		void Write(const string &data, void* ptr) {
			*safe_cast(ptr) = atol(data.c_str());
		}
		string Read(const void* ptr) const {
			char buffer[255];
			sprintf(buffer, "%u", *safe_cast(ptr));
			return buffer;
		}
};

TStringInterface* NewStringInterface(unsigned *d) {
	return new TDI_string_unsigned(d);
}

class TDI_string_unsignedchar:
	public TStringInterface, public TUnsignedCharStorage
{
	public:
		TDI_string_unsignedchar(unsigned char *data) {
			_data = data;
		}
	protected:
		void Write(const string &data, void* ptr) {
			*safe_cast(ptr) = atol(data.c_str());
		}
		string Read(const void* ptr) const {
			char buffer[255];
			sprintf(buffer, "%u", (unsigned)*safe_cast(ptr));
			return buffer;
		}
};

TStringInterface* NewStringInterface(unsigned char *d) {
	return new TDI_string_unsignedchar(d);
}

class TDI_string_double:
	public TStringInterface, public TDoubleStorage
{
	public:
		TDI_string_double(double *data) {
			_data = data;
		}
	protected:
		void Write(const string &data, void* ptr) {
			sscanf(data.c_str(), "%lf", safe_cast(ptr));
		}
		string Read(const void* ptr) const {
			char buffer[255];
			sprintf(buffer, "%f", *safe_cast(ptr));
			return buffer;
		}
};

TStringInterface* NewStringInterface(double *d) {
	return new TDI_string_double(d);
}

// int
//---------------------------------------------------------------------------

class TDI_int_int:
	public TIntInterface, public TIntStorage
{
	public:
		TDI_int_int(int *data) {
			_data = data;
		}
	protected:
		void Write(const int &data, void* ptr) {
			*safe_cast(ptr) = data;
		}
		int Read(const void* ptr) const {
			return *safe_cast(ptr);
		}
};

TIntInterface* NewIntInterface(int *d)
{
	return new TDI_int_int(d);
}

class TDI_int_unsignedchar:
	public TIntInterface, public TUnsignedCharStorage
{
	public:
		TDI_int_unsignedchar(unsigned char *data) {
			_data = data;
		}
	protected:
		void Write(const int &data, void* ptr) {
			*safe_cast(ptr) = data;
		}
		int Read(const void* ptr) const {
			return *safe_cast(ptr);
		}
};

TIntInterface* NewIntInterface(unsigned char *d)
{
	return new TDI_int_unsignedchar(d);
}

// bool
//---------------------------------------------------------------------------

class TDI_bool_bool:
	public TBoolInterface, public TBoolStorage
{
	public:
		TDI_bool_bool(bool *data) {
			_data = data;
		}
	protected:
		void Write(const bool &data, void* ptr) {
			*safe_cast(ptr) = data;
		}
		bool Read(const void* ptr) const {
			return *safe_cast(ptr);
		}
};

TBoolInterface* NewBoolInterface(bool *d)
{
	return new TDI_bool_bool(d);
}
