/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-2000 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toad.hh>
#include <toad/dialog.hh>
#include <toad/dialogeditor.hh>

#include <toad/fatcheckbutton.hh>
#include <toad/fatradiobutton.hh>
#include <toad/pushbutton.hh>
#include <toad/checkbox.hh>
#include <toad/textarea.hh>
#include <toad/textfield.hh>

#include <toad/dialogeditor/simpledlgeditor.hh>
#include <toad/gadget.hh>
#include <toad/gadget/line.hh>
#include <toad/gadgetwindow.hh>
#include <toad/gadgeteditor.hh>

class TDECtrl:
	public TDialog
{
	public:
		TDECtrl(TGadgetEditor*);
		
		TGadgetEditor *gedit;
		
		void editModeChanged();
		void selectionChanged();
		
		void applyLabel();
		
		TGText *wnd_title;
		TTextArea *wnd_label;
		
		TLabelOwner *label_owner;
		
		// `Dialog' frame
		//----------------
		TDialog *current_dlg;
		unsigned dlg_width, dlg_height;
		bool dlg_draw_focus;

		void NewDialog(TDialog*);
		void ApplyDialog();
		GSignal1P<bool> sigEnableDialogGroup;
};


// Simple Dialog Editor
//---------------------------------------------------------------------------
TSimpleDlgEditor::TSimpleDlgEditor()
{
//	cout << __PRETTY_FUNCTION__ << endl;
	gedit = new TGadgetEditor();
	
	ctrl = new TDECtrl(gedit);
	SetCtrlWindow(ctrl);
#if 1
	ctrl->Create();
#else
	ctrl->DoModeless();
#endif
}

TSimpleDlgEditor::~TSimpleDlgEditor()
{
//	cout << __PRETTY_FUNCTION__ << endl;
}

void TSimpleDlgEditor::windowChanged(TWindow *wold, TWindow *wnew)
{
//	cout << __PRETTY_FUNCTION__ << endl;

	TGadgetWindow *gw;

	gedit->ClearSelection();

	// move the modifications to the old window and restore its parameters
	if (wold) {
		wold->SetHasBackground(true);
		gw = dynamic_cast<TGadgetWindow*>(wold);
		if (gw) {
			gw->gadgets.insert(
				gw->gadgets.begin(),
				gedit->gadgets.begin(), gedit->gadgets.end());
			gedit->gadgets.clear();
		}
	}
	
	gedit->DeleteAll();

	if (wnew) {
		wnew->SetHasBackground(false);
		gw = dynamic_cast<TGadgetWindow*>(wnew);
		if (gw) {
			gedit->gadgets.insert(
				gedit->gadgets.begin(),
				gw->gadgets.begin(), gw->gadgets.end());
			gw->gadgets.clear();
		}
		TDialog *dlg = dynamic_cast<TDialog*>(wnew);
		ctrl->NewDialog(dlg);
	} else {
		ctrl->NewDialog(NULL);
	}
	gedit->SetWindow(wnew);
}

void TSimpleDlgEditor::paint()
{
//	cout << __PRETTY_FUNCTION__ << endl;
	gedit->paint();
}

void TSimpleDlgEditor::mouseLDown(int x, int y, unsigned m)
{
//	cout << __PRETTY_FUNCTION__ << endl;
	gedit->mouseLDown(x, y, m);
}

void TSimpleDlgEditor::mouseLUp(int x, int y, unsigned m)
{
//	cout << __PRETTY_FUNCTION__ << endl;
	gedit->mouseLUp(x, y, m);
}

void TSimpleDlgEditor::mouseMove(int x,int y,unsigned m)
{
//	cout << __PRETTY_FUNCTION__ << endl;
	gedit->mouseMove(x, y, m);
}

void TSimpleDlgEditor::keyDown(TKey key, char *str, unsigned m)
{
//	cout << __PRETTY_FUNCTION__ << endl;
	gedit->keyDown(key, str, m);
}

// TDECtrl
//---------------------------------------------------------------------------
TDECtrl::TDECtrl(TGadgetEditor *ge):
	TDialog(NULL, "Dialog Editor")
{
	static TGFrame gframe;
	static TGRectangle grect;
	static TGCircle gcirc;
	static TGText gtext;
	static TGLine gline;
	
	gedit = ge;

	CONNECT(gedit->sigSelectionChanged, this, selectionChanged);

	int x,y,w,h;
	x = 5;
	y = 5;
	w = 64;
	h = 25;

	TFatCheckButton *fcb;
	
	fcb = new TFatCheckButton(this, "Edit", &TDialogEditor::enabled);
	CONNECT(fcb->sigValueChanged, this, editModeChanged);
	fcb->SetDirect(true);
	fcb->SetShape(x,y,w,h);
	y+=h;
	y+=5;

	TRadioState *state = new TRadioState();
	TFatRadioButton *rb = NULL;
	for(unsigned i=0; i<=5; i++) {
		switch(i) {
			case 0:
				rb = new TFatRadioButton(this, "Select", state, i);
				CONNECT(rb->sigActivate, gedit, SetOperation, TGadgetEditor::OP_SELECT);
				rb->SetDown(true);
				break;
			case 1:
				rb = new TFatRadioButton(this, "Frame", state, i);
				CONNECT(rb->sigActivate, gedit, SetCreate, &gframe);
				break;
			case 2:
				rb = new TFatRadioButton(this, "Line", state, i);
				CONNECT(rb->sigActivate, gedit, SetCreate, &gline);
				break;
			case 3:
				rb = new TFatRadioButton(this, "Rect", state, i);
				CONNECT(rb->sigActivate, gedit, SetCreate, &grect);
				break;
			case 4:
				rb = new TFatRadioButton(this, "Circle", state, i);
				CONNECT(rb->sigActivate, gedit, SetCreate, &gcirc);
				break;
			case 5:
				rb = new TFatRadioButton(this, "Text", state, i);
				CONNECT(rb->sigActivate, gedit, SetCreate, &gtext);
				break;
		}
		rb->SetShape(x,y,w,h);
		y+=h-1;
	}

	y+=5;

	TPushButton *pb = NULL;
	for(unsigned i=0; i<=5; i++) {
		switch(i) {
			case 0:
				pb = new TPushButton(this, "Top");
				CONNECT(pb->sigActivate, gedit, Selection2Top);
				break;
			case 1:
				pb = new TPushButton(this, "Up");
				CONNECT(pb->sigActivate, gedit, SelectionUp);
				break;
			case 2:
				pb = new TPushButton(this, "Down");
				CONNECT(pb->sigActivate, gedit, SelectionDown);
				break;
			case 3:
				pb = new TPushButton(this, "Bottom");
				CONNECT(pb->sigActivate, gedit, Selection2Bottom);
				break;
			case 4:
				y+=5;
				pb = new TPushButton(this, "Group");
				CONNECT(pb->sigActivate, gedit, Group);
				break;
			case 5:
				pb = new TPushButton(this, "Ungroup");
				CONNECT(pb->sigActivate, gedit, Ungroup);
				break;
		}
		pb->SetShape(x,y,w,h);
		y+=h-1;
	}
	SetSize(320, y+5);

	x+=w+5;
	y=5;
	w=Width()-x-5;
	int fh = DefaultFont().Height();

	TGFrame *rect1;
	TGText *text;
	text = new TGText(this, x,y, "Beware: Under Construction");
	text->line_color.Set(255,0,0);
	y+=fh+fh;

	// `Dialog' group
	//-----------------------------------------------------------------
	rect1 = new TGFrame(this, x, y+fh/2, w, 50, "Dialog");
	
	y+=fh+5;
	x+=5;
	w-=10;
	
	int x2=x;
	text = new TGText(this, x2,y+2, "Size:");

	dlg_width = 0;
	TTextField *tf = new TTextField(this, "width", &dlg_width);
	CONNECT(sigEnableDialogGroup, tf, SetEnabled);
	x2+=text->p2.x-text->p1.x+1;
		tf->SetShape(x2, y,50,tf->Height());
	x2+=50+2;

	text = new TGText(this, x2, y+2, "");
	x2+=text->p2.x-text->p1.x+1+2;

	dlg_height = 0;
	tf = new TTextField(this, "height", &dlg_height);
		CONNECT(sigEnableDialogGroup, tf, SetEnabled);
		tf->SetShape(x2, y,50,tf->Height());
	y+=fh;
	
	y+=8;
	
	TCheckBox *cb = new TCheckBox(this, "draw focus frame", &dlg_draw_focus);
		CONNECT(sigEnableDialogGroup, cb, SetEnabled);
		cb->SetShape(x,y, w, fh);
	y+=fh;

	y+=5;
	
	pb = new TPushButton(this, "Apply");
		pb->SetShape(x,y,80,fh+6);
		CONNECT(pb->sigActivate, this, ApplyDialog);
		CONNECT(sigEnableDialogGroup, pb, SetEnabled);
	y+=fh+6;

	y+=5;

	rect1->p2.y = y;
	

	// `Controller' group
	//-----------------------------------------------------------------
	y+=5;
	rect1 = new TGFrame(this, x-5, y+fh/2, w+10, Height()-(y+fh/2)-5+1, "Controller");
	y+=fh;

	text = new TGText(this, x,y, "Window Title:");
	y+=fh;

	wnd_title = new TGText(this, x, y, "");
	y+=fh+5;

	text = new TGText(this, x,y, "Label:");
	y+=fh;

	wnd_label = new TTextArea(this, "label");
	wnd_label->SetDirect(true);
	wnd_label->SetEnabled(false);
	wnd_label->SetShape(x,y,w,fh*5);
	y+=fh*5;

	y+=2;
	pb = new TPushButton(this, "Apply");
	CONNECT(pb->sigActivate, this, applyLabel);
	pb->SetShape(x,y,80,22);

	y+=5;

	text = new TGText(this, x,y, "Color:");
	y+=fh;

	y+=5;
	text = new TGText(this, x,y, "Font:");
	y+=fh;

	y+=5;
	text = new TGText(this, x,y, "Grid:");
	y+=fh;

	y+=5;
	text = new TGText(this, x,y, "Traversal Order:");
	y+=fh;
	
	NewDialog(NULL);
}

void TDECtrl::NewDialog(TDialog *dlg)
{
	current_dlg = dlg;
	if (dlg) {
		dlg_width = dlg->Width();
		TDataManipulator::Assimilate(&dlg_width);
		dlg_height= dlg->Height();
		TDataManipulator::Assimilate(&dlg_height);
		dlg_draw_focus = dlg->bDrawFocus;
		TDataManipulator::Assimilate(&dlg_draw_focus);
		sigEnableDialogGroup(true);
	} else {
		sigEnableDialogGroup(false);
	}
}

void TDECtrl::ApplyDialog()
{
	if (current_dlg) {
		Apply();					// copy controller values to attributes
		current_dlg->SetSize(dlg_width, dlg_height);
		current_dlg->bDrawFocus = dlg_draw_focus;
	}
}

void TDECtrl::editModeChanged()
{
	if (!TDialogEditor::enabled) {
		TDialogEditor::SetEditWindow(NULL);
	}
}

void TDECtrl::selectionChanged()
{
	wnd_title->SetText("");
	if (gedit->selection.size()==1) {
		TGWindow *gw = dynamic_cast<TGWindow*>(*gedit->selection.begin());
		if (gw) {
			wnd_title->SetText(gw->window->Title());
			label_owner = dynamic_cast<TLabelOwner*>(gw->window);
			if (label_owner) {
				wnd_label->SetValue(label_owner->_label);
				wnd_label->SetEnabled(true);
			} else {
				wnd_label->SetValue("");
				wnd_label->SetEnabled(false);
			}
		}
	} else {
		label_owner = NULL;
		wnd_label->SetValue("");
		wnd_label->SetEnabled(false);
	}
	Invalidate();
}

void TDECtrl::applyLabel()
{
	if (label_owner)
		label_owner->SetLabel(wnd_label->Value());
}

