/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/gadget/line.hh>
#include <toad/gadgeteditor.hh>

TGLine::TGLine()
{
	p1.x = p1.y = p2.x = p1.y = 0;
}

TGLine::TGLine(TGadgetWindow *parent, int x1, int y1, int x2, int y2)
{
	p1.x = x1; p1.y = y1;
	p2.x = x2; p2.y = y2;
	parent->Add(this);
}

void 
TGLine::paint(TPen &pen, EPaintType)
{
	pen.SetLineColor(line_color);
	pen.DrawLine(p1, p2);
}

void 
TGLine::getShape(TRectangle &r)
{
	r.Set(p1, p2);
}

double 
TGLine::distance(int mx, int my)
{
	return Distance2Line(mx, my, p1.x, p1.y, p2.x, p2.y);
}

bool
TGLine::getHandle(unsigned handle, TPoint& p)
{
	switch(handle) {
		case 0:
			p=p1;
			return true;
		case 1:
			p=p2;
			return true;
	}
	return false;
}

void 
TGLine::translate(int dx, int dy)
{
	p1.x+=dx;
	p1.y+=dy;
	
	p2.x+=dx;
	p2.y+=dy;
}

void 
TGLine::translateHandle(unsigned h, int x, int y)
{
	switch(h) {
		case 0:
			p1.Set(x,y);
			break;
		case 1:
			p2.Set(x,y);
			break;
	}
}

unsigned
TGLine::mouseLDown(TGadgetEditor *e, int x, int y, unsigned)
{
	if (e->state == TGadgetEditor::STATE_START_CREATE) {
		e->InvalidateFigure(this);
		p1.Set(x,y);
		p2.Set(x,y);
		e->InvalidateFigure(this);
		return CONTINUE;
	}
	return NOTHING;
}

unsigned
TGLine::mouseMove(TGadgetEditor *e, int x, int y, unsigned)
{
	if (e->state == TGadgetEditor::STATE_CREATE) {
		e->InvalidateFigure(this);
		p2.Set(x,y);
		e->InvalidateFigure(this);
		return CONTINUE;
	}
	return NOTHING;
}

unsigned
TGLine::mouseLUp(TGadgetEditor *e, int x, int y, unsigned)
{
	if (e->state == TGadgetEditor::STATE_CREATE) {
		p2.Set(x,y);
		if (p1.x==p2.x && p1.y==p2.y)
			return STOP|DELETE;
		return STOP;
	}
	return NOTHING;
}

void 
TGLine::store(TOutObjectStream &file, ulong)
{
	file.WriteByte(line_color.r);
	file.WriteByte(line_color.g);
	file.WriteByte(line_color.b);
	
	file.WriteSWord(p1.x);
	file.WriteSWord(p1.y);
	file.WriteSWord(p2.x);
	file.WriteSWord(p2.y);
}

void 
TGLine::restore(TInObjectStream &file, ulong)
{
	line_color.r = file.ReadByte();
	line_color.g = file.ReadByte();
	line_color.b = file.ReadByte();

	p1.x = file.ReadSWord();
	p1.y = file.ReadSWord();
	p2.x = file.ReadSWord();
	p2.y = file.ReadSWord();
}
