/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-2000 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/gadget.hh>
#include <toad/gadgeteditor.hh>
#include <toad/labelowner.hh>

// avoid problems on AIX, IRIX, ...
#define exception c_exception
#include <cmath>
#undef exception

TGWindow::TGWindow()
{
	window = NULL;
	taborder = 0;
	removeable = false;
}

void 
TGWindow::paint(TPen&, EPaintType)
{
}

double
TGWindow::distance(int x, int y)
{
	filled = true;
	return super::distance(x,y);
}

void
TGWindow::translate(int dx, int dy)
{
	super::translate(dx, dy);
	TRectangle r;
	getShape(r);
	window->SetShape(r);
}

void
TGWindow::translateHandle(unsigned handle, int mx, int my)
{
	super::translateHandle(handle, mx, my);
	TRectangle r;
	getShape(r);
	window->SetShape(r);
}

void 
TGWindow::store(TOutObjectStream &file, ulong version)
{
	if (window!=NULL)
		cerr << "toad warning: TGWindow.window==NULL : " << title << endl;

	unsigned subversion=0;
	if (version>=3) {
		subversion=1;
		file.WriteWord(subversion);
		file.WriteByte(window!=NULL ? 1 : 0);
	}

	TRectangle r(p1,p2);
	file.WriteSWord(r.x);
	file.WriteSWord(r.y);
	file.WriteWord(r.w);
	file.WriteWord(r.h);

	file.WriteWord(title.size());
	file.WriteString(title.c_str(), title.size());

	bool flag = true;
	if (window) {
		TLabelOwner *lo = dynamic_cast<TLabelOwner*>(window);
		if (lo) {
			file.WriteWord(lo->_label.size());
			file.WriteString(lo->_label.c_str(), lo->_label.size());
			flag = false;
		}
	}
	if (flag)
		file.WriteWord(0);

	if (window!=NULL && subversion>1) {
		file.WriteWord(window->taborder);
		file.WriteWord(0);
		file.WriteWord(0);
		file.WriteWord(0);
		file.WriteWord(0);
	}
}

// the data fetched during restore will be copied by `ArrangeHelper(...)'
// in `dialog.cc' to the window
void 
TGWindow::restore(TInObjectStream &file, ulong version)
{
	unsigned subversion = 0;
	bool has_window = false;
	if (version>=3) {
		subversion = file.ReadWord();
		has_window = file.ReadByte()>0;
	}

	TRectangle r;
	r.x = file.ReadSWord();
	r.y = file.ReadSWord();
	r.w = file.ReadWord();
	r.h = file.ReadWord();
	SetShape(r.x, r.y, r.w, r.h);
	{	
		unsigned l = file.ReadWord();
		char buffer[l+1];
		file.ReadString(buffer,l);
		buffer[l]=0;
		title = buffer;
	}
	
	{
		unsigned l = file.ReadWord();
		char buffer[l+1];
		file.ReadString(buffer,l);
		buffer[l]=0;
		label = buffer;
	}
	
	if (has_window && subversion>1) {
		taborder = file.ReadWord();
		file.ReadWord();
		file.ReadWord();
		file.ReadWord();
		file.ReadWord();
	}
}
