/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TLBA_STLVectorCString
#define TLBA_STLVectorCString TLBA_STLVectorCString

#include <vector>

class TLBA_STLVectorCString: public TLBAdapter
{
		vector<const char*> *vec;
	public:
		TLBA_STLVectorCString(vector<const char*> *v){vec=v;}
		TLBA_STLVectorCString(vector<char*> *v){vec=reinterpret_cast<vector<const char*>*>(v);}
		unsigned ItemHeight();
		unsigned ItemCount();
		void PrintItem(int x,int y,unsigned item,TPen &);
		string GetItemAsString(unsigned item);
};

inline unsigned TLBA_STLVectorCString::ItemHeight()
{
	return TOADBase::DefaultFont().Height();
}

inline unsigned TLBA_STLVectorCString::ItemCount()
{
	return vec->size();
}

inline void TLBA_STLVectorCString::PrintItem(int x,int y,unsigned item,TPen &pen)
{
	if (item>=vec->size()) return;
	pen.DrawString(x,y,(*vec)[item]);
}

inline string TLBA_STLVectorCString::GetItemAsString(unsigned item)
{
	if (item>=vec->size()) return "";
	return (*vec)[item];
}

#endif
