/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-98 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toadbase.hh>
#include <toad/pen.hh>
#include <toad/window.hh>
#include <toad/radiobutton.hh>

//! TRadioButton
//. See <A HREF="TRadioState.html">TRadioState</A> for code examples.

// Constructor
//----------------------------------------------------------------------------
TRadioButton::TRadioButton(TWindow *parent, const string &title, int group, int value)
	:super(parent, title, group, value)
{
	SetBackground(TColor::DIALOG);
	SetBorder(false);
}

TRadioButton::TRadioButton(TWindow *parent, const string &title, TRadioState *state, int value)
	:super(parent, title, state, value)
{
	SetBackground(TColor::DIALOG);
	SetBorder(false);
}
           
// paint
//---------------------------------------------------------------------------
void TRadioButton::paint()
{
	TPen pen(this);
	// draw text
	int y = ( (Height()-pen.Height()) >> 1 );

	pen.SetColor(255,255,255);
	pen.FillCircle(1,1,11,11);
	pen.SetColor(128,128,128);
	pen.DrawCircle(0,0,11,11);
	pen.DrawCircle(1,1,10,10);
	pen.SetColor(  0,  0,  0);
	pen.DrawArc(1,1,11,11, 90, 180);
	if (IsDown())
		pen.FillCircle(3,3, 6,6);
		
	pen.DrawString(20,y, Label());
	
	if (IsFocus()) {
		pen.SetLineStyle(TPen::DOT);
		pen.DrawRectangle(18,0,Width()-18,Height());
	}
}
