/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toadbase.hh>
#include <toad/pen.hh>
#include <toad/window.hh>
#include <toad/textfield.hh>
// #include <toad/dragndrop.hh>

#include <cstring>

TTextField::TTextField(TWindow *parent, const string &title)
	:super(parent,title)
{
	_Init();
}

TTextField::~TTextField()
{
}

void TTextField::_Init()
{
	SetBorder(false);
	bPassword = false;
	cx=0;
	left=0;
	ml=mr=0;
	SetBackground(TColor::TEXTEDIT);
	SetSize(320, DefaultFont().Height()+4);
#if 0	
	// register text field for drag & drop
	//-------------------------------------
	TDropString *dc = new TDropString(this);
		OLD_CONNECT(this,dropInsert, dc,dc->sigDrop);
#endif
}

#if 0
void TTextField::dropInsert(TDropString *dc)
{
	if (!Enabled())
		return;
	SetValue(dc->Value());
}


void TTextField::mouseMDown(int,int,unsigned)
{
	StartDrag(new TDragString(_data));
}
#endif

void TTextField::valueChanged()
{
	cx=left=0;
	Invalidate();
}

void TTextField::paint()
{
	TPen pen(this);
	pen.Draw3DRectangle(0,0,Width(),Height());
	pen.SetColor(TColor::DIALOGTEXT);
	
	if (!Enabled())	{
		pen.DrawString(4, ( (_h-pen.Height()) >> 1 ), _data);
		return;
	}

	// draw text
	//-----------
	int y = ( (_h-pen.Height()) >> 1 );
	if (!bPassword)	{
		pen.DrawString(4,y, _data.substr(left).c_str() );
		// invert the selection
		if (mr!=ml && mr>left) {
			int x,w;
			if (ml>=left)	{
				x = pen.TextWidth(_data.substr(left,ml-left));
				w = pen.TextWidth(_data.substr(ml-left,mr-ml));
			} else {
				x = 0;
				w = pen.TextWidth(_data.substr(left,mr-left));
			}
			pen.SetMode(TPen::XOR);
			pen.SetColor(255,255,255);
			pen.FillRectangle(4+x,y, w,pen.Height());
			pen.SetColor(0,0,0);
			pen.SetMode(TPen::NORMAL);
		}
	}
	
	if (IsFocus()) {
		// draw cursor
		int x = 4+pen.TextWidth(_data.substr(left,cx-left).c_str());
		pen.DrawLine(x,y, x,y+pen.Height());
		pen.DrawLine(x-2,y, x+2,y );
		pen.DrawLine(x-2,y+pen.Height(), x+2,y+pen.Height());

		pen.DrawRectangle(0,0, _w, _h);
	}
}

void TTextField::focus()
{
	if (!IsFocus())
		cx=left=0;
	Invalidate();
}

void TTextField::enabled()
{
	if (Enabled()) {
		SetBackground(TColor::TEXTEDIT);
	} else {
		SetBackground(TColor::DIALOG);
	}
	TControl::enabled();
}


void TTextField::mouseLDown(int x,int,unsigned)
{
	if (!Enabled())
		return;
	SetFocus();

	unsigned p=left;
	while(x>4+DefaultFont().TextWidth(_data.substr(left,p-left)) && p<_data.size())
		p++;
	cx = p;
	Invalidate();
}

static string clipboard_dummy;

void TTextField::keyDown(TKey key, char* str, unsigned modifier)
{
	if (!Enabled())
		return;
	bool bNeedUpdate;
	if (modifier & MK_CONTROL) {
		switch(key)	{
			case 'x':case 'X':
				clipboard_dummy = _data.substr(ml,mr-ml);
				key = TK_DELETE;
				break;
			case 'c':case 'C':
				clipboard_dummy = _data.substr(ml,mr-ml);
				return;
			case 'v':case 'V':
				if (ml!=mr)	{
					_data.erase(ml,mr-ml);
					cx=ml;
					if (cx<left)
						cx=left;
					ml=mr=0;
				}
 				_data.insert(cx,clipboard_dummy);
				cx+=clipboard_dummy.size();
				while( DefaultFont().TextWidth(_data.substr(left,cx-left).c_str())+8 > _w )
					left++;
				Invalidate();
				ValueChanged();
				return;
		}
	}
	switch(key)
	{
		case TK_RIGHT:
			if (cx<_data.length()) {
				cx++;
				while( DefaultFont().TextWidth(_data.substr(left,cx-left).c_str())+8 > _w )
					left++;
				if (modifier & MK_SHIFT) {
					if (mr==ml)	{
						ml=cx-1;
						mr=cx;
					} else {
						if (cx>mr)
							mr=cx;
						else
							ml=cx;
					}
				}	else {
					ml=mr=0;
				}
				Invalidate();
			}
			break;
		case TK_LEFT:
			if (cx>0) {
				cx--;
				if (cx<left)
					left--;
				if (modifier & MK_SHIFT) {
					if (mr==ml)	{
						ml=cx;
						mr=cx+1;
					} else {
						if (cx<ml)
							ml=cx;
						else
							mr=cx;
					}
				}
				else
					ml=mr=0;
				Invalidate();
			}
			break;
		case TK_HOME:
			if (cx!=0) {
				if (modifier & MK_SHIFT) {
					if (mr==ml)
						mr=cx;
					else if (cx==_data.length())
						mr=ml;
					ml=0;
				}
				else
					ml=mr=0;
				cx=0;left=0;
				Invalidate();
			}
			break;
		case TK_END:
			if (cx!=_data.length()) {	// If the cursor is not at the texts end...
				if (modifier & MK_SHIFT) {
					if (ml==mr)
						ml = cx;
					else if (cx==0)
						ml = mr;
					mr = _data.length();
				}	else {
					ml=mr=0;
				}
				cx=_data.length();	// ...move it to the end...
				left=cx;						// ...and find first char to display on the left.
				do {
					if (left==0) {
						left--;
						break;
					}
					left--;
				}while(	DefaultFont().TextWidth(_data.substr(left,cx-left).c_str())+8 < _w );
				left++;
				Invalidate();
 			}
 			break;
 		case TK_DELETE:
			if (_data.length()>0) {
				if (ml!=mr)	{	// remove selection
					_data.erase(ml,mr-ml);
					cx = ml;
					if (cx<left)
						cx=left;
					ml=mr=0;
				}	else {
					_data.erase(cx,1);
				}
				if (left>=_data.size())
					left=_data.size();
				Invalidate();
 			}
 			break;
 		case TK_BACKSPACE:
 			bNeedUpdate=false;
			if (ml!=mr)	{
				_data.erase(ml,mr-ml);
				cx=ml;
				if (cx<left)
					cx=left;
				ml=mr=0;
				bNeedUpdate=true;
			}	else {
				if (cx>0 && _data.length()>0) {
					cx--;
					if (cx<left)
						left--;
					_data.erase(cx,1);
					bNeedUpdate=true;
 				}
 			}
 			if (bNeedUpdate)
 				Invalidate();
 			break;
 		case TK_RETURN:
 			sigActivate();
 			break;
 		default:
 			if (((unsigned char)*str)>=32) {
				if (ml!=mr)	{
					_data.erase(ml,mr-ml);
					cx=ml;
					if (cx<left)
						cx=left;
					ml=mr=0;
				}
 				_data.insert(cx,str,1);
				cx++;
				while( DefaultFont().TextWidth(_data.substr(left,cx-left).c_str())+8 > _w )
					left++;
				Invalidate();
 			}
	}
	ValueChanged();
}
