/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <errno.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define _TOAD_PRIVATE

#include <toad/toad.hh>
#include <toad/dialogeditor/simpledlgeditor.hh>

#ifdef DEBUG_MEMORY
	#include <mcheck.h>
#endif

// main
//----------------------------------------------------------------------------
int main(int argc, char *argv[], char *envv[])
{
#ifdef DEBUG_MEMORY
	mtrace();
	mcheck(NULL);
#endif

	// this is something other OO languages call class initialisation
	TOADBase::Init(argc,argv,envv);

	if (TDialogEditor::running)
		TDialogEditor::SetDialogEditor(new TSimpleDlgEditor());

	int result = ToadMain();

	// remove dialog editor (if any)
	//----------------------------------------
	TDialogEditor::SetDialogEditor(NULL);
	
	TOADBase::Close();

	return result;
}
