/*
 * Borland helpfile viewer for WWW v1.0
 *
 * search engine: Tomi Leppikangas <tomilepp@paju.oulu.fi>
 * www interface: Erik Bos <erik@xs4all.nl>
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>

#define EXAMPLE 	1
#define LINK		2
#define NOT_FOUND	-1

#define SWAP(a) a=( ((a & 0xff) << 8) | ((unsigned short)(a) >> 8) )

/* Define LIT_END if machine is little endian (sparc is)*/
#ifdef __sparc__
#define LIT_END
#endif

char *query_data, conv_table[14], *fname;
int n_words;

typedef struct
{
   char *keyword;
   unsigned short link;
}

dir_type;

dir_type *directory;

void
die (char *text)
{
   printf ("<h1>AAAARGH!</h1><br>Error: %s<br>", text);
   exit (1);
}

void
trim (char *s)
{
   int x, y;

   for (x = 0; !isalpha (s[x]) && s[x]; x++)
      /* NOTHING */ ;

   for (y = strlen (s); !isalpha (s[y]) && y != x; y--)
      /* NOTHING */ ;

   s[++y] = 0;
   strcpy (s, s + x);
}

/***************************************************************************
 * cgi-interface functions
 */

char *
get_var (char *name)
{
   int length, length2;
   char *ptr, *ret;

   if ((ptr = strstr (query_data, name)) == NULL)
      return NULL;

   length = strlen (name);
   if (*(ptr + length) == '=')
   {
      length2 = strchr (ptr + length + 1, '&') ?
	 strchr (ptr + length + 1, '&') - ptr - length - 1 :
	 strlen (ptr + length + 1);
      ret = malloc (length2 + 1);
      strncpy (ret, ptr + length + 1, length2);
      ret[length2] = 0;

      return ret;
   }
   else
      return NULL;
}

int
ind (char *s, char c)
{
   register int x;

   for (x = 0; s[x]; x++)
      if (s[x] == c)
	 return x;

   return -1;
}

char
x2c (char *what)
{
   char digit;

   digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A') + 10 : (what[0] - '0'));
   digit *= 16;
   digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A') + 10 : (what[1] - '0'));

   return digit;
}

void
unescape_url (char *url)
{
   int x, y;

   for (x = 0; url[x]; x++)
      if (url[x] == '+')
	 url[x] = ' ';

   for (x = 0, y = 0; url[y]; x++, y++)
      if ((url[x] = url[y]) == '%')
      {
	 url[x] = x2c (url + y + 1);
	 y += 2;
      }
   url[x] = 0;
}

void
escape_url (char *url)
{
   register int x, y;
   char *copy;

   copy = strdup (url);

   for (x = 0, y = 0; copy[x]; x++, y++)
   {
      if (ind ("% ?+&", url[y] = copy[x]) != -1)
      {
	 sprintf (url + y, "%%%2x", copy[x]);
	 y += 2;
      }
   }
   url[y] = '\0';
   free (copy);
}

void
print_as_html (unsigned char *s, unsigned short *links)
{
   int link_count = 0, example = 0, link = 0;

   while (*s)
   {
      switch (*s)
      {
      case '<':
	 printf ("&lt;");
	 break;

      case '>':
	 printf ("&gt;");
	 break;

      case '&':		/* Is this needed? */
	 printf ("&amp;");
	 break;

      case 0xfe:		/* list item */
	 putchar ('*');
	 break;
	 /* german Umlaute necessary in mosaic version 2.2,
	  * higher version ones (i don't know due to a lack of no
	  * other version handy yet)
	  *				J"org Abke
	  */
      case 0x94:
	 printf ("&ouml;");	/* "o */
	 break;
      case 0x99:
	 printf ("&Ouml;");	/* "O */
	 break;
      case 0x81:
	 printf ("&uuml;");	/* "u */
	 break;
      case 0x9a:
	 printf ("&Uuml;");	/* "U */
	 break;
      case 0x84:
	 printf ("&auml;");	/* "a */
	 break;
      case 0x8e:
	 printf ("&Auml;");	/* "A */
	 break;
      case 0xe1:		/* "s */
	 printf ("&szlig;");
	 break;
	 /* ibm-pc characters */
      case 0xc9:
      case 0xd1:
      case 0xbb:
      case 0xc8:
      case 0xcf:
      case 0xbc:
      case 0xda:
      case 0xbf:
      case 0xc3:
      case 0xb4:
      case 0xc0:
      case 0xd9:
      case 0xd8:
      case 0xc5:
      case 0xc2:
      case 0xd7:
      case 0xc1:
	 putchar ('+');
	 break;

      case 0xba:
      case 0xb3:
      case 0xdd:
      case 0xde:
	 putchar ('|');
	 break;

      case 0xcd:
      case 0xc4:
      case 0xdf:
      case 0xdc:
	 putchar ('-');
	 break;

      case EXAMPLE:
	 example ^= 1;
	 if (example)
	    printf ("<code>");
	 else
	    printf ("</code>");
	 break;

      case LINK:
	 link ^= 1;
	 if (link)
	 {
#ifdef LIT_END
            SWAP(links[link_count]);
#endif
	    printf ("<a href=\"" MY_NAME "?file=%s&link=%u\">",
		    fname, links[link_count++]);
	 }
	 else
	    printf ("</a>");
	 break;
      default:
	 putchar (*s);
      }
      s++;
   }
}

void
print_directory ()
{
   int count;
   char *s, *r, line[80];
   for (count = 0; count < n_words; count++)
   {
      s = directory[count].keyword;
      r = line;
      while (*s)
      {
	 switch (*s)
	 {
	 case '<':
	    *r++ = '&';
	    *r++ = 'l';
	    *r++ = 't';
	    *r++ = ';';
	    *r = 0;
	    break;

	 case '>':
	    *r++ = '&';
	    *r++ = 'g';
	    *r++ = 't';
	    *r++ = ';';
	    *r = 0;
	    break;

	 case '&':
	    *r++ = '&';
	    *r++ = 'a';
	    *r++ = 'm';
	    *r++ = 'p';
	    *r++ = ';';
	    *r = 0;
	    break;
	 default:
	    *r++ = *s;
	    *r = 0;
	 }
	 s++;
      }


#ifdef FRAMES
      printf ("<a href=\"" MY_NAME "?file=%s&link=%u\" TARGET=\"helppage\">%s</a>\n",
#else
      printf ("<a href=\"" MY_NAME "?file=%s&link=%u\">%s</a>\n",
#endif
	      fname, directory[count].link, line);

   }
}


/***************************************************************************
 * help-file functions
 */

void
check_head (int in)
{
   char head[5];
   read (in, (void *) head, 5);
   if (memcmp ((void *) head, "TURBO", 5))
      die ("Wrong filetype\n");
}

void
find_eof (int in)
{
   char c;
   do
      read (in, (void *) &c, 1);
   while (c != 0x1a);
}

void
read_conv_table (int in)
{
   int i;

   lseek (in, 0x1f, SEEK_CUR);	/* Goto conv_table  */
   read (in, conv_table, 14);
   for (i = 0; i < 14; i++)	/* Change nil to newline */
      if (conv_table[i] == '\0')
	 conv_table[i] = '\n';
}

int
wordcmp (unsigned char *p1, unsigned char *p2)
{
   int ret;
   unsigned char c1;
   /*  if (p1 == p2)    return 0;*/
   for (; !(ret = (c1 = tolower (*p1)) - tolower (*p2)); p1++, p2++)
      if (c1 == '\0')
	 break;
   return ret;
}

int
find_word (char *word)
{
   int beg = 0, end = n_words, half, cmp;
   while (beg <= end)
   {
      half = (beg + end + 1) / 2;

      cmp = wordcmp (word, directory[half].keyword);

      if (!cmp)
	 return directory[half].link;
      if (cmp > 0)
	 beg = half + 1;
      else
	 end = half - 1;	/* -1 */
   }
   return NOT_FOUND;
}


void
decomp_dir (unsigned char array[])
{
   int a, len, copy_bytes;
   int current, unpack, here;
   unsigned short size;
   unsigned char byte;

   size = *(unsigned short *) array;	/* First two bytes are size */
#ifdef LIT_END
   SWAP(size);
#endif
   n_words = size;
   array += 2;
   /* Alloc memory for directory */
   directory = calloc (size, sizeof (dir_type));

   current = unpack = here = 0;
   for (a = 0; a < size; a++)
   {
      byte = array[current++];
      len = byte & 0x1f;	/* Lower 5 bits are lenght */
      copy_bytes = byte / 32;	/* Upper 3 bits are copy len */

      if ((directory[here].keyword = malloc (len + copy_bytes + 1)) == NULL)
	 die ("Malloc error\n");
      if (copy_bytes)		/* Copy if needed */
	 memcpy (directory[here].keyword,
		 directory[here - 1].keyword, copy_bytes);
      unpack = copy_bytes;
      while (len--)
	 directory[here].keyword[unpack++] = array[current++];
      directory[here].keyword[unpack] = '\0';
      directory[here].link = array[current++];
      directory[here].link += array[current++]<<8;
      here++;
   }

}

#define NODE ((which^=1) ? (*current) & 0x0f : (*current++) >>4)

void
uncompress_page (unsigned char *array, unsigned char *links)
{
   unsigned char n, c, *current, *page, *point;
   int which = 0, end = 1, counter = 0, link_count = 0;

   current = array;
   point = page = malloc (10000); /* 10k should be en.. Segmentation fault  */

   while (end)
   {
      if ((n = NODE) == 0x0f)	/* Is packed */
      {
	 c = NODE;
	 c += NODE << 4;
	 switch (c)
	 {
	 case 0x01:		/* End mark */
	    end = 0;
	    *point = 0;
	    break;
	 case 0x05:		/* Example */
	    *point++ = EXAMPLE;
	    break;
	 case 0x02:		/* Link */
	    *point++ = LINK;
	    link_count++;	/* counted twise for every link */
	    break;
	 default:		/* Store */
	    do
	    {
	       *point++ = c;
	    }
	    while (counter--);
	    counter = 0;
	 }
      }
      else if (n == 0x0e)	/* Is counter */
	 counter = NODE + 1;
      else
      {
	 do
	 {
	    *point++ = conv_table[n];
	 }
	 while (counter--);
	 counter = 0;
      }
   }
   /* Check that we have right link table */
   links += 4;			/* Skip 4 zeros */
   if (( (*links) + (*(links+1)<<8) ) != link_count / 2)
      puts ("Link count doesn't matc!!\n");
   links += 2;
   print_as_html (page, (short *) links);
}

int
main (int argc, char **argv)
{
   int in, index = 0;
   unsigned short size, dir_size, links_size, links_count;
   unsigned char test, *array, *links;
   char *keyword, *link;
   long page;

   printf ("Content-Type: text/html%c%c", 10, 10);

   if (strcmp (getenv ("REQUEST_METHOD"), "GET") != 0)
   {
      printf ("HTTP method must be GET !\n");
      exit (1);
   }
   query_data = strdup (getenv ("QUERY_STRING"));
   unescape_url (query_data);

   if (((fname = get_var ("file")) == NULL))
   {
      printf ("Put also filename!\n");
      exit (1);
   }

   /* printf ("##%s##<br>\n", query_data);
      printf ("Filename = %s\n", fname);
   */

   if ((in = open (fname, O_RDONLY)) == -1)
   {
      die ("Can't open help file.");
   }
   check_head (in);
   find_eof (in);
   read_conv_table (in);

   lseek (in, 1, SEEK_CUR);	/* Skip one char */
   read (in, (void *) &links_size, 2);	/* Read links */
#ifdef LIT_END
   SWAP(links_size);
#endif
   read (in, (void *) &links_count, 2);	/* Read links */
#ifdef LIT_END
   SWAP(links_count);
#endif

   if (!(links = malloc (links_size)))
      die ("Malloc error 1\n");

   read (in, links, links_size - 2);	/* 1 link = 3 bytes */


   keyword = get_var ("keyword");
   link = get_var ("link");
   /*
     if(keyword)
        printf("Keyword=%s<br>\n", keyword);
     if(link)
        printf("Link=%s<br>\n", link);
   */
   printf ("<pre>\n");

   if (((keyword == NULL) ||(*keyword == '\0'))  && (link == NULL))
   {
      read (in, (void *) &test, 1);
      if (test != 0x04)
	 printf ("Found 0x%02x, should be 0x03\n", test);
      read (in, (void *) &dir_size, 2);	/* Read directory */
#ifdef LIT_END
      SWAP(dir_size);
#endif
      if (!(array = malloc (dir_size)))
	 die ("Malloc error 2\n");
      read (in, array, dir_size);
      decomp_dir (array);
      print_directory ();
      free (array);
      free (links);
   }
   else
   {
      if (link!=NULL) 
         index = atoi (link);
      if (keyword!=NULL)
      {
	 read (in, (void *) &test, 1);
	 if (test != 0x04)
	    printf ("Found 0x%02x, should be 0x03\n", test);
	 read (in, (void *) &dir_size, 2);	/* Read directory */
#ifdef LIT_END
         SWAP(dir_size);
#endif
	 if (!(array = malloc (dir_size)))
	    die ("Malloc error 2\n");
	 read (in, array, dir_size);
	 decomp_dir (array);
	 if ((index = find_word (keyword)) == NOT_FOUND)
	    die ("Not found\n");
	 free (array);
      }

      page  = *(links + (index) * 3);
      page += *(links + (index) * 3+1)<< 8;
      page += *(links + (index) * 3+2)<<16;

      free (links);

      lseek (in, page + 1, SEEK_SET);	/* Move to page */
      read (in, (void *) &size, 2);	/* Read page */
#ifdef LIT_END
      SWAP(size);
#endif
      /* printf ("size=%i\n", size); */
      if (!(array = malloc (size)))
	 die ("Malloc error 3\n");
      read (in, array, size);

      read (in, (void *) &test, 1);
      if (test != 0x03)
	 printf ("Found 0x%02x, should be 0x03\n", test);
      read (in, (void *) &size, 2);	/* Read page-links */
#ifdef LIT_END
      SWAP(size);
#endif
      /* printf ("size=%i\n", size); */
      if (!(links = malloc (size)))
	 die ("Malloc error 3\n");
      read (in, links, size);

      uncompress_page (array, links);
   }
   printf ("</pre></html>");
   close (in);

   return 0;
}
