/* vmanpg 1.1 - svgalib pager for man pages.
 * Copyright (C) 1998,2000 Russell Marks. See vmanpg.c for license details.
 *
 * font.c - font stuff, largely a simplified version of font.c from zgv.
 *	It also contains all the graphics routines (vmode_*).
 */

#include <stdio.h>
#include <string.h>
#include <vga.h>
#include "font.h"
#include "fontbmps.h"
#include "config.h"

#define TABSIZE  56   /* size of a tab, in pixels */


static unsigned char vmemcopy[640*480/8];

static int point_size=14;

int invert=0;		/* 1 if we should invert screen */


/* the copyright/license for the bitmap fonts says that all
 * copies of the fonts must contain the copyright. Since a copy
 * was embedded in the program above (`fontbmps.h'), we'd
 * best have this:
 */
static char *bitmap_fonts_copyright=
"The bitmap fonts used are: \
Copyright 1984-1989, 1994 Adobe Systems Incorporated. \
Copyright 1988, 1994 Digital Equipment Corporation.";


/* unused dummy routine to stop -Wall complaining about the copyright
 * message not being used.
 */
static inline void its_too_damn_picky_sometimes()
{
printf(bitmap_fonts_copyright);
}


/* Most drawing is done to an in-memory buffer (vmemcopy[]), with
 * this only copied to the video memory when needed. This speeds things
 * up, and means redraws are pretty much instant.
 */


void vmode_start()
{
vga_setmode(G640x480x2);
vmode_clear();
vmode_refresh();
}


void vmode_clear()
{
memset(vmemcopy,invert?0:0xff,640*480/8);
}


void vmode_clearlines(int y1,int y2)
{
int f;

for(f=y1;f<=y2;f++)
  memset(vmemcopy+80*f,invert?0:0xff,80);
}


inline void vmode_drawpixel(int x,int y)
{
unsigned char *ptr=vmemcopy+y*80+(x>>3);

if(invert)
  *ptr|=(0x0080>>(x&7));
else
  *ptr&=(0xff7f>>(x&7));
}


void vmode_refresh()
{
int f;

/* this isn't exactly ideal but does at least appear to work :-) */
for(f=0;f<480;f++)
  vga_drawscanline(f,vmemcopy+f*80);
}



int get_font_height()
{
/* normal/bold/italic are the same. Well, ok, they're not really, but
 * they *almost* are, so... :-)
 */
if(point_size==12) return(font12_1fh);
if(point_size==18) return(font18_1fh);
return(font14_1fh);
}



/* 1 if size is ok, else 0 */
int set_point_size(int ps)
{
if(ps==12 || ps==14 || ps==18)
  {
  point_size=ps;
  return(1);
  }

return(0);  
}



int vmode_drawtext(int xpos,int ypos,int attr,char *str)
{
int f,c,x,y;
int initxpos=xpos;
signed char *ptr,*fontdat;
int ox,oy,w,h,dw;
int yst;
int *fonttbl;
int fontyofs,fontfh,fontoy;
int widthadd=0;

/* pick font to match attr.
 * It would be nicer if these were in a struct or something...! (XXX)
 * (That's really a problem with bdf2h.c rather than this, though.)
 */
switch(attr)
  {
  case 1:	/* normal */
    switch(point_size)
      {
      case 12:
        fontdat=font12_1dat; fonttbl=font12_1tbl;
        fontyofs=font12_1yofs; fontfh=font12_1fh; fontoy=font12_1oy; break;
      case 18:
        fontdat=font18_1dat; fonttbl=font18_1tbl;
        fontyofs=font18_1yofs; fontfh=font18_1fh; fontoy=font18_1oy; break;
      default:
        fontdat=font14_1dat; fonttbl=font14_1tbl;
        fontyofs=font14_1yofs; fontfh=font14_1fh; fontoy=font14_1oy;
      }
    break;

  case 2:	/* bold */
    switch(point_size)
      {
      case 12:
        fontdat=font12_2dat; fonttbl=font12_2tbl;
        fontyofs=font12_2yofs; fontfh=font12_2fh; fontoy=font12_2oy; break;
      case 18:
        fontdat=font18_2dat; fonttbl=font18_2tbl;
        fontyofs=font18_2yofs; fontfh=font18_2fh; fontoy=font18_2oy; break;
      default:
        fontdat=font14_2dat; fonttbl=font14_2tbl;
        fontyofs=font14_2yofs; fontfh=font14_2fh; fontoy=font14_2oy;
      }
    break;

  case 3:	/* italic */
    switch(point_size)
      {
      case 12:
        fontdat=font12_3dat; fonttbl=font12_3tbl;
        fontyofs=font12_3yofs; fontfh=font12_3fh; fontoy=font12_3oy; break;
      case 18:
        fontdat=font18_3dat; fonttbl=font18_3tbl;
        fontyofs=font18_3yofs; fontfh=font18_3fh; fontoy=font18_3oy; break;
      default:
        fontdat=font14_3dat; fonttbl=font14_3tbl;
        fontyofs=font14_3yofs; fontfh=font14_3fh; fontoy=font14_3oy;
      }
    break;
  
  case 0:	/* `system' font */
    fontdat=fontsysdat; fonttbl=fontsystbl;
    fontyofs=fontsysyofs; fontfh=fontsysfh; fontoy=fontsysoy;
    break;
  
  default:
    /* this is deliberately brutal as this should be a can't-happen bug */
    fprintf(stderr,"unsupported text type - shouldn't happen\n");
    exit(1);
  }

for(f=0;f<strlen(str);f++)
  {
  c=str[f];
  if(c=='\t')
    {
    xpos=X_MARGIN+(((xpos-X_MARGIN)/TABSIZE)+1)*TABSIZE;
    continue;
    }
  if(c<32 || c>126) c='_';
  ptr=fontdat+fonttbl[c-32];
  ox=*ptr++; oy=*ptr++;
  w =*ptr++; h =*ptr++;
  dw=*ptr++;
  yst=fontfh-(oy-fontoy)-fontyofs-h;
  
  for(y=ypos+yst;y<ypos+yst+h;y++)
    for(x=xpos+ox;x<xpos+ox+w;x++)
      if(*ptr++) vmode_drawpixel(x,y);
  
  xpos+=dw+widthadd;
  }

return(xpos-initxpos);
}
