	{ Ce schema decrit la presentation utilisee pour le Courrier

	  I. Vatton					Octobre 88 }

{ Variables utilisees : PAGE, WithLOGO, ENGLISH, US_PAPER }
PRESENTATION Lettre;
VIEWS Vue_Unique;

#ifdef PAGE
PRINT Vue_Unique;
#endif

COUNTERS
#ifdef PAGE
   CptPageCorps: Rank of Page;
#endif
   CptNote: Rank of Note;

VAR

   NumNote : Text '('  Value(CptNote,Arabic) Text ')';

DEFAULT

   BEGIN
   HorizRef : Enclosed . HRef ;
   VertRef : Enclosed . VRef ;
   Width : Enclosed . Width;
   Height : Enclosed . Height;
   VertPos : Top = Previous . Bottom;
   HorizPos : Left = Enclosing . Left;
   Justify : Enclosing =;
   Visibility: Enclosing =;
   Font : Enclosing =;
   Style : Enclosing =;
   Size : Enclosing =;
   Adjust : Enclosing =;
   Indent : Enclosing =;
   LineSpacing : Enclosing =;
   Depth : 0;
   UnderLine: Enclosing =;
   Thickness: Enclosing =;
   LineStyle: Enclosing =;
   LineWeight: Enclosing =;
   Background: Enclosing =;
   Foreground: Enclosing =;
   END;

BOXES

#ifdef WithLOGO
   Logo :
	BEGIN
	Content: Picture 'logo.xbm';
	Width : Enclosed . Width;
	VertPos: Top = Enclosing . Top + 0.7 cm;
	HorizPos : Left = Enclosing . Left;
	END;

   BtIMAG :
	BEGIN
	Content: Text 'Informatique et de Math\351matiques Appliqu\351es de Grenoble';
	Font: Helvetica;
	Style: Roman;
	Size : 16 pt;
	VertPos: Top = Enclosing . Top + 1.2 cm;
	HorizPos : Left = Logo . Right + 0.7 cm;
	END;

   BtINRIA :
	BEGIN
	Content: Text 'Institut National de Recherche en Informatique et en Automatique';
	Font: Helvetica;
	Style: Roman;
	Size : 16 pt;
	VertPos: Top = Enclosing . Top + 1.2 cm;
	HorizPos : Left = Logo . Right + 0.7 cm;
	END;

   BtCNRS :
	BEGIN
	Content: Text 'Centre National de la Recherche Scientifique';
	Font: Helvetica;
	Style: Roman;
	Size : 16 pt;
	VertPos: Top = Enclosing . Top + 1.2 cm;
	HorizPos : Left = Logo . Right + 0.7 cm;
	END;

   BAdresse :
	BEGIN
	Content: Text '2 avenue de Vignate, 38610 GIERES';
	Font: Helvetica;
	Style: Roman;
	Size : 11 pt;
	VertPos: Top = Previous . Bottom;
	HorizPos : Left = Previous . Left;
	END;

   France :
	BEGIN
	Content: Text 'France';
	Font: Helvetica;
	Style: Roman;
	Size : 11 pt;
	VertPos: Top = Previous . Bottom;
	HorizPos : Left = Previous . Left;
	END;

   Tel :
	BEGIN
	Content: Text 't\351l. (33)76.63.48.48';
	Font: Helvetica;
	Style: Roman;
	Size : 11 pt;
	VertPos: Top = France . Bottom;
	HorizPos : Left = Previous . Left;
	END;
#endif

#ifndef ENGLISH
   BoiteMrMme1 :
	BEGIN
	Content: Text 'Veuillez agr\351er, ';
	VertPos : nil;
	HorizPos : nil;
	END;

   BoiteMrMme2 :
	BEGIN
	Content: Text ', l''expression de mes sinc\350res salutations.';
	VertPos : nil;
	HorizPos : nil;
	END;

   BoiteCollegue1 :
	BEGIN
	Content: Text 'Je vous prie de croire, ';
	VertPos : nil;
	HorizPos : nil;
	END;

   BoiteCollegue2 :
	BEGIN
	Content: Text ', \340 l''assurance de mes sentiments les plus cordiaux.';
	VertPos : nil;
	HorizPos : nil;
	END;

   BoitePresident1 :
	BEGIN
	Content: Text 'Je vous prie d''agr\351er, ';
	VertPos : nil;
	HorizPos : nil;
	END;

   BoitePresident2 :
	BEGIN
	Content: Text ', l''expression de mes sentiments respectueux.';
	VertPos : nil;
	HorizPos : nil;
	END;
#endif

   NumeroNote :
	BEGIN
	Font: Creator =;
	Size : Creator =;
	VertPos : HRef = Next Note . HRef;
	Width : 2;
	Content : NumNote;
	END;

#ifdef PAGE
   EspaceHautPage:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Height: 1.4 cm;
	Width: 1 pt;
	VertPos: Top = Previous PAGE_BREAK . Bottom;
	HorizPos: Left = Previous PAGE_BREAK . Left;
	Content: (Graphics ' ');
	END;

   EspaceBasPage:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Height: 1.4 cm;
	Width: 1 pt;
	VertPos: Bottom = Next PAGE_BREAK . Top;
	HorizPos: Left = Next PAGE_BREAK . Left;
	Content: (Graphics ' ');
	END;

   FiletNote:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Height: 0.5 cm;
	Width: 3 cm;
	VertPos: Top = Enclosing .Top;
	HorizPos: Left = Enclosing .Left;
	Size: 8 pt;
	Content: Graphics 'h';
	END;

   BoiteNotes:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	CreateFirst(FiletNote);
	Content: Note;
	VertPos: Bottom =  Next PAGE_BREAK . Top - 1.3 cm;
	HorizPos: Left = Next PAGE_BREAK . Left;
	Height: Enclosed . Height;
	Width: Next PAGE_BREAK . Width;
	END;

   BasPage:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Height: 0.5 cm;
	VertPos: Bottom = Next PAGE_BREAK . Top;
	HorizPos: VMiddle = Next PAGE_BREAK . VMiddle;
	Content: Text ' ';
	Size: 8 pt;
	END;

   PageCorps:
	BEGIN
#ifdef US_PAPER
	Width: 15 cm;
	Height: 27 cm;
	HorizPos: Left = Enclosing . Left + 2.7 cm;
#else
	Width: 15.6 cm;
	Height: 25.3 cm;
	HorizPos: Left = Enclosing . Left + 3 cm;
#endif
	VertPos: Top = Enclosing . Top + 1 cm;
	IF Not One(CptPageCorps) CreateBefore (BoiteNotes);
	IF Not One(CptPageCorps) CreateBefore (EspaceBasPage);
	IF Not One(CptPageCorps) CreateBefore (BasPage);
	IF Not One(CptPageCorps) CreateAfter (EspaceHautPage);
	END;

#else
   BtExp\351diteur :
	BEGIN
	Style: Bold;
#ifdef ENGLISH
	Content : Text 'Sender: ';
#else
	Content : Text 'Exp\351diteur : ';
#endif
	END;

   BtDestinataire :
	BEGIN
	Style: Bold;
#ifdef ENGLISH
	Content : Text 'Addressee: ';
#else
	Content : Text 'Destinataire : ';
#endif
	END;

   BtDate :
	BEGIN
	Style: Bold;
#ifdef ENGLISH
	Content : Text 'Date: ';
#else
	Content : Text 'Date : ';
#endif
	VertPos : Top = Previous . Bottom + 1 cm;
	HorizPos : Left = Enclosing . Left;
	END;

   BtTitre :
	BEGIN
	Style: Bold;
#ifdef ENGLISH
	Content : Text 'Title: ';
#else
	Content : Text 'Titre : ';
#endif
	END;

   BtTexte :
	BEGIN
	Style: Bold;
#ifdef ENGLISH
	Content : Text 'Text: ';
#else
	Content : Text 'Texte : ';
#endif
	END;

   BtSignature :
	BEGIN
	Style: Bold;
#ifdef ENGLISH
	Content : Text 'Signature:\212';
#else
	Content : Text 'Signature :\212';
#endif
	END;
#endif

RULES

    Lettre:
	BEGIN
#ifdef PAGE
	Page(PageCorps);
	HorizPos : VMiddle = Enclosing . VMiddle;
	Width : Enclosing . Width;
	Font : Times;
	Size : 11 pt;
#else
	HorizPos : Left = Enclosing . Left + 1 cm;
	Width: Enclosing . Width - 2 cm;
	Font: Helvetica;
	Size : 12 pt;
#endif
#ifdef WithLOGO
	CreateFirst(Logo);
#endif
	Style : Roman;
	Visibility: 10;
	Adjust : Left;
	Indent : 2;
	LineSpacing : 1.2;
	Hyphenate: No;
	END;

   Exp\351diteur:
	BEGIN
#ifdef PAGE
	VertPos : Top = Enclosing . Top + 6 cm;
	HorizPos : Left = Enclosing . Left;
#else
	CreateFirst(BtExp\351diteur);
	VertPos : Top = Previous . Bottom + 0.3 cm;
	HorizPos : Left = Enclosing . Left;
#endif
	END;

   Destinataire:
	BEGIN
#ifdef PAGE
	VertPos : Top = Enclosing . Top + 6.2 cm;
#else
	CreateFirst(BtDestinataire);
	VertPos : Top = Exp\351diteur . Top;
#endif
	HorizPos : Right = Enclosing . Right;
	END;

   Date_lettre:
	BEGIN
	HorizPos : Left = Enclosing . Left;
#ifdef PAGE
	VertPos : Top = Enclosing . Top + 9.5 cm;
#else
	CreateBefore(BtDate);
	VertPos : Top = Previous BtDate . Bottom;
#endif
	Width: Enclosing . Width;
	Indent: 0;
	Line;
	END;
	
   Ligne_Adresse:
	BEGIN
	VertPos : Top = Previous . Bottom;
	HorizPos : Left = Enclosing . Left;
	END;

   D\351but :
	BEGIN
#ifdef PAGE
	VertPos : Top = Enclosing . Top + 11 cm;
#else
	CreateFirst(BtTitre);
	VertPos : Top = Date_lettre . Bottom + 1.5;
	Indent: -2;
#endif
	Width : Enclosing . Width - 3 cm;
	Line;
	END;

   Suite_paragraphes :
	BEGIN
#ifdef PAGE
	VertPos : Top = Previous . Bottom + 1.5;
	Justify: Yes;
	Hyphenate: Yes;
#else
	CreateFirst(BtTexte);
	VertPos : Top = Previous . Bottom + 1.5;
	Hyphenate: No;
#endif
	HorizPos : Left = Enclosing . Left;
	Width : Enclosing . Width;
	END;

   Paragr :
	BEGIN
	HorizPos : Left = Enclosing . Left;
	VertPos : Top = Previous . Bottom + 0.5;
	Width : Enclosing . Width;
	END;

   Image :
	BEGIN
	VertPos : Top = Previous . Bottom + 0.5;
	HorizPos : VMiddle = Enclosing . VMiddle;
	Gather : Yes;
	END;

   Remerciements :
	BEGIN
#ifdef ENGLISH
	Visibility: 0;
#else
	Line;
	Width : Enclosing . Width;
	HorizPos : Left = Enclosing . Left;
	VertPos : Top = Previous . Bottom + 0.5;
	NoBreak1 : 2;
	NoBreak2 : 2;
#endif
	END;

   Autre_Nature :
	BEGIN
	VertPos : Top = Previous . Bottom + 0.5;
	HorizPos : VMiddle = Enclosing . VMiddle;
	Gather : Yes;
	END;

   Signature :
	BEGIN
#ifndef PAGE
	CreateFirst(BtSignature);
#endif
	Line;
	Adjust: VMiddle;
	Width: 8 cm;
	Indent: 0;
	HorizPos : Right = Enclosing . Right - 2 cm;
	VertPos : Top = Previous . Bottom + 3.5;
	END;

#ifndef PAGE
   Notes :
	BEGIN
	Style : Roman;
	Font: Helvetica;
	Size : 12 pt;
	Width : Enclosing . Width - 3;
	HorizPos : Left = Enclosing . Left + 1.5;
	VertPos : Top = Enclosing . Top + 0.5;
	Visibility: 10;
	Hyphenate : No;
	END;
#endif

   Note :
	BEGIN
	CreateBefore (NumeroNote);
#ifdef PAGE
	Font: Times;
	Size : Enclosing - 1;
	Hyphenate: Yes;
#endif
	Indent: 0;
	Width : Enclosing . Width - 1.8;
	VertPos : Top = Previous NOT NumeroNote . Bottom + 0.5;
	HorizPos : Left = NumeroNote . Right;
	END;

   Ref_note :
	BEGIN
	Copy (NumeroNote);
	Size : Enclosing - 2 min 6;
	HorizRef : * . Bottom + 0.3;
	HorizPos : Left = Previous . Right;
	VertPos : HRef = Previous . HRef;
	END;

   Indice :
        BEGIN
        PageBreak: No;
        LineBreak: No;
        HorizPos : Left = Previous . Right;
        VertPos : HRef = Previous . HRef;
        HorizRef : Enclosed . HRef - 0.3;
        Size : Enclosing - 2 min 6;
        END;

   Exposant :
        BEGIN
        PageBreak: No;
        LineBreak: No;
        HorizPos : Left = Previous . Right;
        VertPos : HRef = Previous . HRef;
        HorizRef : Enclosed . HRef + 0.4;
        Size : Enclosing - 2 min 6;
        END;

#ifdef PAGE
   PAGE_BREAK:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	HorizOverflow: Yes;
	END;
#endif


ATTRIBUTES
#ifdef WithLOGO
   Labo = IMAG:
	BEGIN
	CreateFirst(BtIMAG);
	CreateFirst(BAdresse);
	CreateFirst(France);
	CreateFirst(Tel);
	END;
   Labo = INRIA:
	BEGIN
	CreateFirst(BtINRIA);
	CreateFirst(BAdresse);
	CreateFirst(France);
	CreateFirst(Tel);
	END;
   Labo = CNRS:
	BEGIN
	CreateFirst(BtCNRS);
	CreateFirst(BAdresse);
	CreateFirst(France);
	CreateFirst(Tel);
	END;
#endif

   Importance = D\351finition :
	Style: Italics;
   Importance = Mot_important :
	Style: Bold;

#ifndef ENGLISH
   Formule = MrouMme :
	BEGIN
	CreateFirst(BoiteMrMme1);
	CreateLast(BoiteMrMme2);
	END;
   Formule = Coll\350gue :
	BEGIN
	CreateFirst(BoiteCollegue1);
	CreateLast(BoiteCollegue2);
	END;
   Formule = Pr\351sident:
	BEGIN
	CreateFirst(BoitePresident1);
	CreateLast(BoitePresident2);
	END;
#endif
END
