        { Ce schema decrit la structure d'un rapport structure'
 
        V. Quint      Juin 1995  }
 
STRUCTURE Rapport;
DEFPRES RapportP;
 
ATTR
   Importance = D\351finition,  Important;
   R\351serv\351 = Integer;
 
STRUCT
   Rapport (ATTR Num\351ro_prem_page = Integer;
		 Num\351ro_prem_section = Integer) =
             BEGIN
	     Entete =
		BEGIN
		Titre_courant       = Contenu;
		Auteurs_courants    = Contenu;
	      ? R\351f\351rence     = Contenu;
	      ? Statut              = Contenu;
	      ? Date_de_mise_a_jour = Contenu;
	        Titre               = Contenu;
	        Auteurs             = LIST OF (Auteur);
	        Affiliations        = LIST OF (Affiliation = Contenu);
	        R\351sum\351        = LIST OF (Paragraphe);
	      ? Mots_cl\351s        = Contenu;
		Heading;
		END;
	     Corps =
		BEGIN
	        Pr\351ambule        = Suite_paragraphes;
	        Suite_sections;
		END;
	     Partie_finale =
		AGGREGATE
	      ? Sections_finales    = LIST OF (Section) - (Suite_sections);
		Bibliographie       = LIST OF (Citation_biblio = RefBib);
	      ? Annexes             = LIST OF (Annexe);
		END;
             END;
 
   Contenu = LIST OF (Unit\351 = UNIT);
   Auteur (ATTR Type_auteur = Auteur_principal, Auteur_secondaire) =
	     Contenu + (Ref_affiliation)
		     - (Ref_figure, Ref_formule, Ref_section, Ref_annexe,
			Ref_groupe_titr\351);
   Ref_affiliation = REFERENCE(Affiliation);

   Heading = BEGIN
	   ? Title    = Contenu with Langue ?= 'English';
	     Abstract = LIST OF (Paragraphe) with Langue ?= 'English';
	   ? Keywords = Contenu with Langue ?= 'English';
	     END;

   Annexe =  BEGIN
             Titre_annexe = Contenu;
	     Titre_courant_annexe = Contenu; 
             Pr\351ambule;
             Suite_sections;
             END;
 
   Suite_sections = LIST [2..*] OF (Section);
 
   Section = BEGIN
             Titre_section = Contenu;
             Suite_paragraphes;
           ? Suite_sections;
             END;
   Suite_paragraphes = LIST OF (Paragr);
 
   Paragr =  CASE OF
             Paragraphe;
	     Groupe_titr\351 =
		BEGIN
		Titre_groupe = Contenu;
		Groupe = LIST OF (Paragr);
		END;
             Image = PICTURE;
             Formule_num\351rot\351e = Math;
	     Figure;
             Autre_nature = NATURE;
             END;

   Figure =  BEGIN
             Illustration = CASE OF
                            Image\240 = PICTURE;
                            Autre_figure = NATURE;
                            END;
             L\351gende_figure = Contenu;
             END;
 
ASSOC
 
   Note = Suite_paragraphes;
 
UNITS
   Indice = TEXT;
   Exposant = TEXT;
   Ref_note = REFERENCE (Note);
   Ref_biblio = REFERENCE (Citation_biblio);
   Ref_figure = REFERENCE (Figure);
   Ref_formule = REFERENCE (Formule_num\351rot\351e);
   Ref_section = REFERENCE (Section);
   Ref_annexe = REFERENCE (Annexe);
   Ref_groupe_titr\351 = REFERENCE (Groupe_titr\351);
   Autre = NATURE;
 
EXPORT
   Titre,
   Citation_biblio With Tout_titre(RefBib),
   Figure With L\351gende_figure,
   Section With Titre_section,
   Paragr With Nothing;
 
EXCEPT

    PICTURE_UNIT:		MoveResize;
    Rapport:			MoveResize;
    Entete:			MoveResize;
    Titre_courant:		MoveResize;
    Auteurs_courants:		MoveResize;
    R\351f\351rence:		MoveResize;
    Statut:			MoveResize;
    Date_de_mise_a_jour:	MoveResize;
    Titre:			MoveResize;
    Auteurs: 			Hidden;
    Affiliations: 		Hidden;
    R\351sum\351:		MoveResize;
    Mots_cl\351s:		MoveResize;
    Corps:			MoveResize;
    Pr\351ambule:		MoveResize;
    Partie_finale:		MoveResize;
    Sections_finales:		MoveResize;
    Bibliographie:		MoveResize;
    Citation_biblio:		MoveResize;
    Auteur:			MoveResize;
    Heading:			MoveResize;
    Title:			MoveResize;
    Abstract:			MoveResize;
    Keywords:			MoveResize;
    Annexes:	 		Hidden;
    Annexe:			MoveResize;
    Titre_annexe:		MoveResize;
    Titre_courant_annexe:	MoveResize;
    Suite_sections: 		Hidden;
    Section: 			ImportParagraph, MoveResize;
    Titre_section: 		NoCut, MoveResize;
    Suite_paragraphes: 		Hidden;
    Paragr:			MoveResize;
    Groupe_titr\351:		MoveResize;
    Titre_groupe:		MoveResize;
    Groupe:	 		Hidden;
    Formule_num\351rot\351e:	MoveResize;
    Autre_nature:		MoveResize;
    Figure:			MoveResize;
    Illustration:		MoveResize;
    Image\240:			MoveResize;
    Autre_figure:		MoveResize;
    L\351gende_figure:		MoveResize;
    Note:			MoveResize;
    
    R\351serv\351: 		Invisible;
   
 
END
