/*
 *
 *  (c) COPYRIGHT MIT and INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/*
 *
 * Author: C. Bourgeois
 *
 */

/* Included files */
#include "thot_gui.h"
#include "thot_sys.h"
#include "application.h"
#include "app.h"
#include "interface.h"
#include "ExtCss.h"
#include "StyleCss.h"
#include "StyleCss_f.h"

/*----------------------------------------------------------------------
   ApplyDocStyleSheets : called when a document is loaded, to apply
        its associated style sheets.
 -----------------------------------------------------------------------*/
#ifdef __STDC__
void ApplyDocStyleSheets (NotifyDialog *event)
#else /* __STDC__*/
void ApplyDocStyleSheets(event)
     NotifyDialog *event;
#endif /* __STDC__*/
{
  Document              doc;
  Element               mainroot;
  SSchema               sheetextension;
  AttributeType         sheetattrtype;
  int                   sheetattrkind;
  Attribute             sheetattr;
  char                 *filenames;
  int                   filenameslength;

  /* code to be written */
#ifdef DEBUG_CSS
  fprintf (stderr, "hello from ApplyDocStyleSheets!\n");
#endif

  /* reads sheets extension to parse sheets associated to the document */
  doc = event->document;
  mainroot = TtaGetMainRoot(doc);
  sheetextension = TtaGetSchemaExtension(doc, SHEET_EXT_NAME);

  if (sheetextension != NULL)
    {
#ifdef DEBUG_CSS
      fprintf (stderr, "found the schema extension\n");
#endif
      TtaGiveAttributeTypeFromName(SHEET_ATTR_NAME, mainroot, &sheetattrtype,
			       &sheetattrkind);
      if (sheetattrkind == 2) /* 2 = String */
	{
	  /* the attribute is a string */
	  sheetattr = TtaGetAttribute(mainroot, sheetattrtype);
	  if (sheetattr == NULL)
	    {
#ifdef DEBUG_CSS
	      fprintf (stderr, "ApplyDocStyleSheets: file must be corrupted: can't get css names\n");
#endif
	      return;
	    }
	  /* attribute exists, read stylesheets */
	  filenameslength = TtaGetTextAttributeLength(sheetattr);
	  filenames = TtaGetMemory(filenameslength);
	  TtaGiveTextAttributeValue(sheetattr, filenames, &filenameslength);
#ifdef DEBUG_CSS
	  fprintf (stderr, "value: %s\n", filenames);
#endif
	  ApplySheetsFromList(doc, filenames);
	}
      
#ifdef DEBUG_CSS
      else
	fprintf (stderr, "ApplyDocStyleSheets: *** kind of sheet attribute isn't text\n");
#endif
    }
#ifdef DEBUG_CSS
  else
    fprintf (stderr, "ApplyDocStyleSheets: no schema extension found\n");
#endif
 


#ifdef DEBUG_CSS
  fprintf (stderr, "bye from ApplyDocStyleSheets!\n");
#endif
}


/*----------------------------------------------------------------------
   SaveStyleOnDocSave : when the user agrees, saves the style sheets
        associated to a document as this document is saved.
 -----------------------------------------------------------------------*/
#ifdef __STDC__
boolean SaveStyleOnDocSave (NotifyDialog *event)
#else /* __STDC__*/
boolean SaveStyleOnDocSave(event)
     NotifyDialog *event;
#endif /* __STDC__*/
{

#ifdef DEBUG_CSS
  fprintf (stderr, "hello from SaveStyleOnDocSave!\n");
#endif

  SetAttributeValue (event->document);
  SaveDocCSS(event->document);
  
#ifdef DEBUG_CSS
  fprintf (stderr, "bye from SaveStyleOnDocSave!\n");
#endif
  return FALSE;
}


/*----------------------------------------------------------------------
   SaveStyleOnClose : when the user agrees, saves the style sheets
        associated to a document as this document is closed.
 -----------------------------------------------------------------------*/
#ifdef __STDC__
boolean SaveStyleOnClose (NotifyDialog *event)
#else /* __STDC__*/
boolean SaveStyleOnClose(event)
     NotifyDialog *event;
#endif /* __STDC__*/
{
  /* code to be written */

  FreeAllCSSForClose (event->document);
#ifdef DEBUG_CSS
  fprintf (stderr, "hello from SaveStyleOnClose!\n");
#endif
  return FALSE; /* let Thot perform normal operation */
}


/*----------------------------------------------------------------------
   ReadDocStyles : called when the list of style files are loaded from
        document, to keep them in memory.
 -----------------------------------------------------------------------*/
#ifdef __STDC__
void ReadDocStyles (NotifyAttribute *event)
#else /* __STDC__*/
void ReadDocStyles(event)
     NotifyAttribute *event;
#endif /* __STDC__*/
{
  /* code to be written */
#ifdef DEBUG_CSS
  fprintf (stderr, "hello from ReadDocStyles!\n");
#endif
}

