/*
 *
 *  (c) COPYRIGHT MIT and INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/*
 *
 * Author: C. Bourgeois
 *
 */

/* Included headerfiles */
#define THOT_EXPORT extern
#include "thot_gui.h"
#include "thot_sys.h"
#include "application.h"
#include "constmedia.h"
#include "dialog.h"
#include "document.h"
#include "interface.h"
#include "message.h"
#include "pschema.h"
#include "thotmsg.h"
#include "view.h"
#include "StyleCss.h"
#include "StyleCss_f.h"
/*#include "StyleParser_f.h"*/
#include "StyleRules_f.h"
#include "CssMsgTable.h"
#include "browser.h"

/* Pictures for style sheet window */
#include "Bup.xpm"
#include "Bdown.xpm"
#include "Priority.xpm"


/* Pictures for style rules window */
#include "Caractere.xpm"
#include "Couleur.xpm"
#include "Traits.xpm"
#include "Presentation.xpm"


#include "UIcss.h"
#include "UIcss_f.h"

/*extern*/ Document            currentDocument;
/*extern*/ int                 cssbasedlg;
extern int                     CssMsgTable;

/* 
 * knowing whether dialogs are displayed,
 * which document or which css they refer to.
 */
#define UNDISPLAYED -1
static Document         sheetsref = UNDISPLAYED;
static Document         egref = UNDISPLAYED;
static Document        rulesref = UNDISPLAYED;
static Document         cssfileref = UNDISPLAYED;

CSSInfoPtr  activecss[DocumentTableLength+1];     /* which sheet is beeing modified */
static CSSRulePtr  targetrule = NULL;                    /* target in rules manipulations */
static CSSInfoPtr  targetcss = NULL;                     /* target in sheet manipulations */
static char       *DirectoryName;
static char       *DefaultDocumentName;
static char       *editedrule = NULL;                    /* string (rule)given by the user */
static boolean     isnewrule = FALSE;        /* tells whether the edited rule is a new one */

/************************************************************************
 *                                                                      *
 *                       CSS DIALOGUES DECLARATION                      *
 *                                                                      *
 ************************************************************************/

/*----------------------------------------------------------------------
   InitSheetsDialog : Initializes the sheets dialog window.
   params :
        doc : the document on which the dialog will act
	view : the view from which the dialog has been called
   NOTE : Since the view isn't used to apply CSS rules, this
        param could be removed at any time.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                InitSheetsDialog (Document doc, View view)
#else
void                InitSheetsDialog (doc, view)
Document            doc;
View                view;

#endif
{
  static Pixmap       moveIcons[] = {0, 0};
  static Pixmap       priorityIcon[] = {0};
  char                menu[MAX_TXT_LEN];
  char               *sheetsnames;
  int                 sheetsnb;

  if (sheetsref != UNDISPLAYED)
    return; /* !!!!! could redisplay the window with right
	       params instead. */

  sheetsref = doc;

  /* creating priority icon */ 
  if (priorityIcon[0] == 0)
    priorityIcon[0] = TtaCreatePixmapLogo (Priority_xpm);

  /* creating 'move' icons */ 
  if (moveIcons[0] == 0)
    moveIcons[0] = TtaCreatePixmapLogo (Bup_xpm);
  if (moveIcons[1] == 0)
    moveIcons[1] = TtaCreatePixmapLogo (Bdown_xpm);

  /* creating buttons captions */
  sprintf (menu, "%s%c%s%c%s", TtaGetMessage (CssMsgTable, UI_DONE), EOS,
	   TtaGetMessage (CssMsgTable, UI_ADD_SHEET), EOS,
	   TtaGetMessage (CssMsgTable, UI_REMOVE_SHEET));

  /* creating sheet */
  TtaNewSheet (cssbasedlg + CSS_SHEETS_DLG, TtaGetViewFrame (doc, 1), 
	       TtaGetMessage (CssMsgTable, UI_SHEETS_DLG), 3, menu,
	       FALSE, 2, 'L', D_CANCEL);

  /* creating priority label */
  TtaNewLabel (cssbasedlg + CSS_PRIORITY_LABEL, cssbasedlg + CSS_SHEETS_DLG,
	       TtaGetMessage(CssMsgTable, UI_PRIORITY));

  /* creating priority buttons */
  TtaNewIconMenu (cssbasedlg + CSS_PRIORITY_ICON, cssbasedlg + CSS_SHEETS_DLG, 0,
		  NULL, 1, priorityIcon, FALSE);

  /* creating sheets label */
  TtaNewLabel (cssbasedlg + CSS_SHEET_LABEL, cssbasedlg + CSS_SHEETS_DLG,
	       TtaGetMessage(CssMsgTable, UI_SHEETS_LIST));

  /* getting sheets number and names */
  sheetsnb = GetSheetsNames(doc, &sheetsnames);

  /* creating sheet selector */
  TtaNewSelector (cssbasedlg + CSS_SHEET_NAME, cssbasedlg + CSS_SHEETS_DLG,
		  NULL, sheetsnb, sheetsnames, 6, NULL, FALSE, TRUE);

  /* creating move label */
  TtaNewLabel (cssbasedlg + CSS_MOVE_LABEL, cssbasedlg + CSS_SHEETS_DLG,
               TtaGetMessage(CssMsgTable, UI_MOVE));

  /* creating move buttons */
  TtaNewIconMenu (cssbasedlg + CSS_MOVE_ICONS, cssbasedlg + CSS_SHEETS_DLG, 0,
                  NULL, 2, moveIcons, FALSE);

  TtaSetDialoguePosition ();
  TtaShowDialogue (cssbasedlg + CSS_SHEETS_DLG, TRUE);
}

/*----------------------------------------------------------------------
   InitEgDialog : Initializes the style-by-example dialog window.
   params :
        doc : the document on which the dialog will act
	view : the view from which the dialog has been called
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                InitEgDialog (Document doc, View view)
#else
void                InitEgDialog (doc, view)
Document            doc;
View                view;

#endif
{
  char               *sheetsnames, rulesnames[1500];
  int                 sheetsnb, rulesnb;

  if (egref != UNDISPLAYED)
    return; /* !!!!! could redisplay the window with right
	       params instead. */

  egref = doc;

  /* creating sheet */
  TtaNewSheet (cssbasedlg + CSS_EG_DLG, TtaGetViewFrame (doc, 1), 
	       TtaGetMessage (CssMsgTable, UI_SHEETS_DLG), 1, 
	       TtaGetMessage (CssMsgTable, UI_DONE),
	       FALSE, 1, 'L', D_CANCEL);

  /* getting rules number and names !!!!! */
  sprintf(rulesnames, "%s%c%s%c%s%c%s%c%s", "Paragraphe { color : LightBlue }",
	  EOS, "Section Paragraphe { color : LightBlue }",
	  EOS, "Section Section Paragraphe { color : LightBlue }",
	  EOS, "Corps Section Section Paragraphe { color : LightBlue }",
	  EOS, "Rapport Corps Section Section Paragraphe { color : LightBlue }");
  rulesnb = 5;

  /* creating rule selector */
  TtaNewSelector (cssbasedlg + CSS_EG_SHEETS, cssbasedlg + CSS_EG_DLG,
		  TtaGetMessage (CssMsgTable, UI_RULES_DLG), rulesnb,
		  rulesnames, 6, NULL, FALSE, TRUE);

  /* getting sheets number and names */
  sheetsnb = GetSheetsNames(doc, &sheetsnames);

  /* creating sheet selector */
  TtaNewSelector (cssbasedlg + CSS_EG_RULES, cssbasedlg + CSS_EG_DLG,
		  TtaGetMessage (CssMsgTable, UI_SHEETS_LIST), sheetsnb,
		  sheetsnames, 6, NULL, FALSE, TRUE);

  /* displaying frame */
  TtaSetDialoguePosition ();
  TtaShowDialogue (cssbasedlg + CSS_EG_DLG, TRUE);
}

/*----------------------------------------------------------------------
   InitRulesDialog : Initializes the rules dialog window.
   params :
        doc : the document on which the dialog will act
	view : the view from which the dialog has been calles
   NOTE : Since the view isn't used to apply CSS rules, this
        param could be removed at any time.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                InitRulesDialog (Document doc, View view)
#else
void                InitRulesDialog (doc, view)
Document            doc;
View                view;

#endif
{
  static Pixmap       styleIcons[] = {0, 0, 0, 0};
  char                menu[MAX_TXT_LEN];
  char               *sheetsnames, *rulesnames;
  int                 sheetsnb, rulesnb;

  if (rulesref != UNDISPLAYED)
    return;
  rulesref = doc;

  /* creating 'style' icons */ 
  if (styleIcons[0] == 0)
    styleIcons[0] = TtaCreatePixmapLogo (Caractere_xpm);
  if (styleIcons[1] == 0)
    styleIcons[1] = TtaCreatePixmapLogo (Couleur_xpm);
  if (styleIcons[2] == 0)
    styleIcons[2] = TtaCreatePixmapLogo (Traits_xpm);
  if (styleIcons[3] == 0)
    styleIcons[3] = TtaCreatePixmapLogo (Presentation_xpm);

  /* creating buttons captions */
  sprintf (menu, "%s%c%s%c%s%c%s%c%s%c%s", 
	        TtaGetMessage (CssMsgTable, UI_APPLY),
	   EOS, TtaGetMessage (CssMsgTable, UI_NEW),
	   EOS, TtaGetMessage (CssMsgTable, UI_DUPLICATE),
	   EOS, TtaGetMessage (CssMsgTable, UI_DELETE),
	   EOS, " ",
	   EOS, TtaGetMessage (CssMsgTable, UI_DONE));

  /* creating sheet */
  TtaNewSheet (cssbasedlg + CSS_RULES_DLG, TtaGetViewFrame (doc, 1), 
	       TtaGetMessage (CssMsgTable, UI_RULES_DLG), 6, menu,
	       FALSE, 2, 'L', D_CANCEL);

  /* creating sheet label */
  TtaNewLabel (cssbasedlg + CSS_TARGET_LABEL, cssbasedlg + CSS_RULES_DLG,
	       TtaGetMessage (CssMsgTable, UI_STYLE_SHEET));

  /* getting sheets number and names */
  sheetsnb = GetSheetsNames(doc, &sheetsnames);

  /* creating sheet selector */
  TtaNewSelector (cssbasedlg + CSS_TARGET_SHEET, cssbasedlg + CSS_RULES_DLG,
		  NULL, sheetsnb, sheetsnames, 7, NULL, FALSE, TRUE);

  /* creating rules label */
  TtaNewLabel (cssbasedlg + CSS_RULES_LABEL, cssbasedlg + CSS_RULES_DLG,
	       TtaGetMessage (CssMsgTable, UI_RULES));

  /* getting rules number and names */
  rulesnb = GetRulesNames(activecss[doc], &rulesnames);

  /* creating rule selector */
  TtaNewSelector (cssbasedlg + CSS_RULES_LIST, cssbasedlg + CSS_RULES_DLG,
		  NULL, rulesnb, rulesnames, 7, NULL, TRUE, TRUE);

  /* creating modifiers label */
  TtaNewLabel (cssbasedlg + CSS_MODIF_LABEL, cssbasedlg + CSS_RULES_DLG,
	       TtaGetMessage (CssMsgTable, UI_MODIFY));

  /* creating modifiers icons */
  TtaNewIconMenu (cssbasedlg + CSS_STYLES_ICONS, cssbasedlg + CSS_RULES_DLG, 0,
		  NULL, 4, styleIcons, FALSE);

  TtaSetDialoguePosition ();
  TtaShowDialogue (cssbasedlg + CSS_RULES_DLG, TRUE);
}



/*----------------------------------------------------------------------
   DisplayCSSFileSelector : displays the css file selector dialog box
   params :
	doc : the document on which will be applied the CSS.
  ----------------------------------------------------------------------*/

#ifdef __STDC__
void            SelectCssFile(Document doc)
#else /* __STDC__*/
char            SelectCssFile(doc)
Document        doc;
#endif /*__STDC__*/
{
  char         *dirs;
  int           nbdirs;


#ifdef DEBUG_CSS
  fprintf (stderr, "DisplayCSSFileSelector enter\n");
#endif

  if (cssfileref != UNDISPLAYED)
    return;
  cssfileref = doc;

  /* creating sheet */
  TtaNewForm (cssbasedlg + CSS_FILE_DLG, TtaGetViewFrame (doc, 1),
	      TtaGetMessage (CssMsgTable, UI_CSS_FILE_DLG), TRUE, 2,
	      'L', D_CANCEL);

  /* predefined directories */
  GetCSSDirectories (EOS, &dirs, &nbdirs);

  /* creating directory selector */
  TtaNewSelector (cssbasedlg + CSS_DIR_LIST, cssbasedlg + CSS_FILE_DLG,
		  TtaGetMessage (CssMsgTable, UI_CSS_DIR_LIST),
		  nbdirs, dirs, 6, NULL, FALSE, TRUE);

  if (nbdirs >= 1)
    /* No current directory, init. with the first in dirs */
    {
      DirectoryName = TtaStrdup (dirs);
      DefaultDocumentName = TtaStrdup (dirs);
      TtaSetSelector (cssbasedlg + CSS_DIR_LIST, 0, NULL);
    }

  /* listing existing files */
  TtaListDirectory (DirectoryName, cssbasedlg + CSS_FILE_DLG, NULL,
		    -1, CSS_FILE_EXTENSION, 
		    TtaGetMessage (CssMsgTable, UI_CSS_FILE_LIST),
		    cssbasedlg + CSS_FILE_LIST);

  /* text zone to get the name of the file */
  TtaNewTextForm (cssbasedlg + CSS_FILE_TEXT_BOX,
		  cssbasedlg + CSS_FILE_DLG,
		  TtaGetMessage (CssMsgTable, UI_CSS_FILE_NAME),
		  50, 1, TRUE);
  TtaSetTextForm (cssbasedlg + CSS_FILE_TEXT_BOX, DefaultDocumentName);
  
  TtaSetDialoguePosition ();
  TtaShowDialogue (cssbasedlg + CSS_FILE_DLG, TRUE);

#ifdef DEBUG_CSS
  fprintf (stderr, "DisplayCSSFileSelector leave\n");
#endif

}

/*----------------------------------------------------------------------
   CSSChangeCharacters:
        User requests to modify the generic character presentation for
	the current rule. Initializes and activates the corresponding form.
   params : 
	doc : the document on which the window depends.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void            CSSChangeCharacters (Document doc)
#else  /* __STDC__ */
void            CSSChangeCharacters (doc)
Document        doc;
#endif /* __STDC__ */
{
  int                 i, nbItems;
  int                 max, bodyRelatSize, bodyPointSize;
  char                string[MAX_TXT_LEN];
  char               *s;

  /* Characters presentation sheet */
  TtaNewForm (cssbasedlg + CSS_CHAR_DLG, TtaGetViewFrame (doc, 1), 
	       TtaGetMessage (CssMsgTable, UI_CHAR_PROP), FALSE, 2,
	      'L', D_DONE);

  /* Characters family submenu text */
  sprintf (string, "%s%c%s%c%s%c%c%s", "BTimes",
	   EOS, "BHelvetica",
	   EOS, "BCourier",
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_UNCHANGED));

  /* Characters family submenu */
  TtaNewSubmenu (cssbasedlg + CSS_CFAMILY_SMENU, cssbasedlg + CSS_CHAR_DLG, 0,
		 TtaGetMessage (CssMsgTable, UI_FONT_FAMILY), 4, string, NULL, TRUE);

  /* Characters family submenu default value */
  TtaSetMenuForm (cssbasedlg + CSS_CFAMILY_SMENU, 3);

  /* Characters style submenu text */
  sprintf (string, "%c%s%c%c%s%c%c%s%c%c%s%c%c%s%c%c%s%c%c%s",
	   'B', TtaGetMessage (CssMsgTable, UI_ROMAN),
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_BOLD),
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_ITALIC),
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_OBLIQUE),
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_BOLD_ITALIC),
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_BOLD_OBLIQUE),
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_UNCHANGED));

  /* Characters style submenu */
  TtaNewSubmenu (cssbasedlg + CSS_CSTYLE_SMENU, cssbasedlg + CSS_CHAR_DLG, 0,
		 TtaGetMessage (CssMsgTable, UI_FONT_STYLE), 7, string, NULL, TRUE);

  /* Characters style submenu */
  TtaSetMenuForm (cssbasedlg + CSS_CSTYLE_SMENU, 6);

  /* Line style sub-menu text */
  sprintf (string, "%c%s%c%c%s%c%c%s%c%c%s",
	   'B', TtaGetMessage (CssMsgTable, UI_NORMAL),
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_UNDERLINE),
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_CROSS_OUT),
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_UNCHANGED));

  /* Line style sub-menu default value */
  TtaNewSubmenu (cssbasedlg + CSS_CLINE_SMENU, cssbasedlg + CSS_CHAR_DLG, 0,
		 TtaGetMessage (CssMsgTable, UI_LINE), 4, string, NULL, TRUE);

  /* Line style sub-menu */
  TtaSetMenuForm (cssbasedlg + CSS_CLINE_SMENU, 3);

  /* Empty spaces... */
  TtaNewLabel (cssbasedlg + CSS_CEMPTY_SPACE, cssbasedlg + CSS_CHAR_DLG, " ");

  /* Available font sizes sub-menu */
  nbItems = 0;
  i = 0;
  max = NumberOfFonts ();
  s = TtaGetMessage (LIB, TMSG_TYPOGRAPHIC_POINTS);
  /* demande au mediateur la valeur en points typographiques de tous */
  /* les corps relatifs successivement */
  for (bodyRelatSize = 0; bodyRelatSize < max && i < MAX_TXT_LEN - 30; bodyRelatSize++)
    {
      bodyPointSize = FontPointSize (bodyRelatSize);
      /* adding this size to sub-menu */
      sprintf (&string[i], "%s%d %s", "B", bodyPointSize, s);
      i += strlen (&string[i]) + 1;
      nbItems++;
    }
  sprintf (&string[i], "%s%s", "B", TtaGetMessage (LIB, TMSG_UNCHANGED));
  nbItems++;
  TtaNewSubmenu (cssbasedlg + CSS_SIZE_SMENU, cssbasedlg + CSS_CHAR_DLG, 0,
		 TtaGetMessage (CssMsgTable, UI_BODY_SIZE_PTS), nbItems,
		 string, NULL, TRUE);
  TtaSetMenuForm (cssbasedlg + CSS_SIZE_SMENU, nbItems-1);


  TtaShowDialogue (cssbasedlg + CSS_CHAR_DLG, TRUE);
}
#if 0
/*----------------------------------------------------------------------
  ModPresentGraphiques
  user requests to modify the specific graphics presentation for the
  view "view" of document pDoc (if Assoc = False) or for the elements
  associated to view number "view" (if Assoc = True).  Initializes
  and activates the corresponding form.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtcChangeGraphics (Document document, View view)
#else  /* __STDC__ */
void                TtcChangeGraphics (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
   int                 i, nbItems;
   PtrDocument         pSelDoc;
   PtrElement          pFirstSel, pLastSel;
   int                 firstChar, lastChar;
   boolean             selectionOK;
   PtrAbstractBox      pAb;
   int                 currentBodySize;
   char                string[MAX_TXT_LEN];
   PtrDocument         pDoc;

   pDoc = LoadedDocument[document - 1];

   /* demande quelle est la selection courante */
   selectionOK = GetCurrentSelection (&pSelDoc, &pFirstSel, &pLastSel, &firstChar, &lastChar);
   if (!selectionOK)
     {
	/* par defaut la racine du document */
	pSelDoc = pDoc;
	pFirstSel = pDoc->DocRootElement;
	selectionOK = TRUE;
     }

   if (selectionOK && pSelDoc == pDoc)
      /* il y a une selection */
     {
	/* recherche le pave concerne */
	if (view > 100)
	   pAb = AbsBoxOfEl (pFirstSel, 1);
	else
	   pAb = AbsBoxOfEl (pFirstSel, view);

	if (pAb != NULL)
	  {
	     /* annule les etats memorises */
	     ResetMenus ();

	     /* feuille de dialogue Presentation Graphiques */
	     TtaNewSheet (NumFormPresGraphics, TtaGetViewFrame (document, view), 
			  TtaGetMessage (LIB, TMSG_GRAPHICS_PRES),
		 1, TtaGetMessage (LIB, TMSG_APPLY), FALSE, 3, 'L', D_DONE);

	     /* sous-menu style des traits */
	     i = 0;
	     sprintf (&string[i], "%s", "Bsssss");	/* Traits_continu */
	     i += strlen (&string[i]) + 1;
	     sprintf (&string[i], "%s", "Bttttt");	/* Traits_tirete */
	     i += strlen (&string[i]) + 1;
	     sprintf (&string[i], "%s", "Buuuuu");	/* Traits_pointilles */
	     i += strlen (&string[i]) + 1;
	     sprintf (&string[i], "%s%s", "B", TtaGetMessage (LIB, TMSG_UNCHANGED));
	     TtaNewSubmenu (NumMenuStrokeStyle, NumFormPresGraphics, 0,
	      TtaGetMessage (LIB, TMSG_LINE_STYLE), 4, string, NULL, TRUE);
	     /* change la police des 3 premieres entrees du style des traits */
	     for (i = 0; i < 3; i++)
		TtaRedrawMenuEntry (NumMenuStrokeStyle, i, "icones", ThotColorNone, -1);
	     /* initialise le sous-menu style des traits */
	     ChngLineStyle = TRUE;
	     StdLineStyle = FALSE;
	     LineStyle = pAb->AbLineStyle;
	     switch (LineStyle)
	       {
	       case 'S':
		 i = 1;	/* trait continu (Solid) */
		 break;
	       case '-':
		 i = 2;	/* tirete' */
		 break;
	       case '.':
		 i = 3;	/* pointille' */
		 break;
	       default:
		 i = 0;
		 break;
	       }
	     TtaSetMenuForm (NumMenuStrokeStyle, i - 1);

	     /* zone de saisie epaisseur des traits */
	     TtaNewNumberForm (NumZoneStrokeWeight, NumFormPresGraphics,
		       TtaGetMessage (LIB, TMSG_LINE_WEIGHT), 0, 72, TRUE);
	     ChngLineWeight = TRUE;
	     StdLineWeight = FALSE;
	     LineWeight = pAb->AbLineWeight;
	     /* Toggle button Epaisseur des traits standard */
	     sprintf (string, "%s%s", "B", TtaGetMessage (LIB, TMSG_UNCHANGED));
	     TtaNewToggleMenu (NumToggleWidthUnchanged, NumFormPresGraphics,
			       NULL, 1, string, NULL, TRUE);
	     /* initialise la zone de saisie epaisseur des traits */
	     if (pAb->AbLineWeightUnit == UnPoint)
		i = LineWeight;
	     else
	       {
	          currentBodySize = PixelToPoint(PixelValue (pAb->AbSize,
							pAb->AbSizeUnit, pAb));
		  i = (currentBodySize * LineWeight) / 10;
		  if ((currentBodySize * i) % 10 >= 5)
		     i++;
	       }
	     TtaSetNumberForm (NumZoneStrokeWeight, i);

	     /* selecteur motif de remplissage */
	     nbItems = MakeMenuPattern (string, MAX_TXT_LEN);
	     if (nbItems > 0)
		/* il y a des motifs de remplissage definis */
		/* on cree un selecteur */
	       {
		  if (nbItems >= 5)
		     i = 5;
		  else
		     i = nbItems;
		  TtaNewSelector (NumSelectPattern, NumFormPresGraphics,
				  TtaGetMessage (LIB, TMSG_FILL_PATTERN),
				  nbItems, string, i, NULL, TRUE, TRUE);
		  /* initialise le selecteur sur sa premiere entree */
		  TtaSetSelector (NumSelectPattern, pAb->AbFillPattern, "");
	       }
	     /* Toggle button Motif de remplissage standard */
	     i = 0;
	     sprintf (&string[i], "%s%s", "B", TtaGetMessage (LIB, TMSG_UNCHANGED));
	     TtaNewToggleMenu (NumTogglePatternUnchanged, NumFormPresGraphics,
			       NULL, 1, string, NULL, TRUE);
	     DocModPresent = pDoc;
	     TtaShowDialogue (NumFormPresGraphics, TRUE);
	  }
     }
}



/*----------------------------------------------------------------------
   CSSChangeFormat : user requests to modify the generic format 
        presentation in the currently edited rule. Initializes
	and activates the corresponding form.
   params :
        
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                CSSChangeFormat (Document doc)
#else  /* __STDC__ */
void                CSSChangeFormat (doc)
Document            document;
#endif /* __STDC__ */
{
  int                 i;
  int                 firstChar, lastChar;
  char                string[MAX_TXT_LEN];

  TtaNewSheet (NumFormPresFormat, TtaGetViewFrame (document, view), 
	       TtaGetMessage (LIB, TMSG_FORMAT),
	       1, TtaGetMessage (LIB, TMSG_APPLY), TRUE, 3, 'L', D_DONE);

  /* Align sub-menu */
  sprintf (string, "%s%c%s%c%c%s", "Bmiidn", EOS, "Bmeiin",EOS, "Bmfogn",
	   EOS, 'B', TtaGetMessage (CssMsgTable, UI_UNCHANGED)); 
  TtaNewSubmenu (NumMenuAlignment, NumFormPresFormat, 0,
		 TtaGetMessage (LIB, TMSG_ALIGN), 4, string, NULL, TRUE);
  /* change la police des 3 premieres entrees */
  for (i = 0; i < 3; i++)
    TtaRedrawMenuEntry (NumMenuAlignment, i, "icones", ThotColorNone, -1);
  /* initialise le menu de cadrage des lignes */
  switch (pAb->AbAdjust)
    {
    case AlignLeft:
      i = 1;
      break;
    case AlignRight:
      i = 2;
      break;
    case AlignCenter:
      i = 3;
      break;
    default:
      i = 1;
      break;
    }
  TtaSetMenuForm (NumMenuAlignment, i - 1);

  /* zone de saisie du renfoncement en points typo */
  TtaNewNumberForm (NumZoneRecess, NumFormPresFormat,
		    TtaGetMessage (LIB, TMSG_INDENT_PTS), 0, 300, TRUE);
  /* initialise la valeur du renfoncement */
  IndentValue = PixelToPoint(PixelValue (abs (pAb->AbIndent),
					 pAb->AbIndentUnit, pAb));
  TtaSetNumberForm (NumZoneRecess, IndentValue);

  /* sous-menu sens de renfoncement */
  i = 0;
  sprintf (&string[i], "%s", "Bm_`an");
  i += strlen (&string[i]) + 1;
  sprintf (&string[i], "%s", "Bmb`an");
  i += strlen (&string[i]) + 1;
  sprintf (&string[i], "%s%s", "B", TtaGetMessage (LIB, TMSG_UNCHANGED));
  TtaNewSubmenu (NumMenuRecessSense, NumFormPresFormat, 0,
		 TtaGetMessage (LIB, TMSG_INDENT), 3, string, NULL, TRUE);
  /* change la police des 3 premieres entrees du sous-menu */
  for (i = 0; i < 2; i++)
    TtaRedrawMenuEntry (NumMenuRecessSense, i, "icones", ThotColorNone, -1);
  /* initialise le sens de renfoncement */
  if (pAb->AbIndent > 0)
    i = 0;
  else
    i = 1;
  TtaSetMenuForm (NumMenuRecessSense, i);

  /* sous-menu de justification */
  i = 0;
  sprintf (&string[i], "%s%s", "B", TtaGetMessage (LIB, TMSG_LIB_YES));
  i += strlen (&string[i]) + 1;
  sprintf (&string[i], "%s%s", "B", TtaGetMessage (LIB, TMSG_LIB_NO));
  i += strlen (&string[i]) + 1;
  sprintf (&string[i], "%s%s", "B", TtaGetMessage (LIB, TMSG_UNCHANGED));
  TtaNewSubmenu (NumMenuJustification, NumFormPresFormat, 0,
		 TtaGetMessage (LIB, TMSG_JUSTIFY), 3, string, NULL, TRUE);
  /* menu de justification */
  if (pAb->AbJustify)
    i = 1;		/* avec justification */
  else
    i = 2;		/* sans justification */
  TtaSetMenuForm (NumMenuJustification, i - 1);

  /* zone de saisie de l'interligne en points typo */
  TtaNewNumberForm (NumZoneLineSpacing, NumFormPresFormat,
		    TtaGetMessage (LIB, TMSG_LINE_SPACING_PTS), 1, 200, TRUE);

  /* sous-menu Interligne (Grandeur) */
  i = 0;
  sprintf (&string[i], "%s", "BmTTTn");	/* 'Normal%' */
  i += strlen (&string[i]) + 1;
  sprintf (&string[i], "%s", "BmWWWn");	/* 'Double%' */
  i += strlen (&string[i]) + 1;
  sprintf (&string[i], "%s", "BmZZZn");	/* 'Triple%' */
  i += strlen (&string[i]) + 1;
  sprintf (&string[i], "%s%s", "B", TtaGetMessage (LIB, TMSG_UNCHANGED));
  TtaNewSubmenu (NumMenuLineSpacing, NumFormPresFormat, 0,
		 TtaGetMessage (LIB, TMSG_LINE_SPACING), 4, string, NULL, TRUE);
  /* change la police des 3 premieres entrees */
  for (i = 0; i < 3; i++)
    TtaRedrawMenuEntry (NumMenuLineSpacing, i, "icones", ThotColorNone, -1);
  /* initialise l'interligne en points typographiques */
  OldLineSp = PixelToPoint(PixelValue (pAb->AbLineSpacing,
				       pAb->AbLineSpacingUnit, pAb));
  TtaSetNumberForm (NumZoneLineSpacing, OldLineSp);

  NormalLineSpacing = PixelToPoint(PixelValue (10, UnRelative, pAb));
  /* saisie de l'interligne par un menu */
  if (OldLineSp < (NormalLineSpacing * 3) / 2)
    i = 0;
  else if (OldLineSp >= NormalLineSpacing * 2)
    i = 2;
  else
    i = 1;
  TtaSetMenuForm (NumMenuLineSpacing, i);
  TtaShowDialogue (NumFormPresFormat, TRUE);
}

#endif

/************************************************************************
 *                                                                      *
 *                      UI REBUILD FOR UPDATE MACROS                    *
 *                                                                      *
 ************************************************************************/

/*----------------------------------------------------------------------
   REBUILD_S_SHEETS : rebuilds the sheets list of the sheets window
  ----------------------------------------------------------------------*/

#define REBUILD_S_SHEETS                                                        \
  if (sheetsref != UNDISPLAYED)                                                 \
    {                                                                           \
      /* getting sheets number and names */                                     \
      sheetsnb = GetSheetsNames(sheetsref, &sheetsnames);                       \
                                                                                \
      /* creating sheet selector */                                             \
      TtaNewSelector (cssbasedlg + CSS_SHEET_NAME, cssbasedlg + CSS_SHEETS_DLG, \
		      NULL, sheetsnb, sheetsnames, 6, NULL, FALSE, TRUE);       \
    }                                                                           \


/*----------------------------------------------------------------------
   REBUILD_R_SHEETS : rebuilds the sheets list of the rules window
  ----------------------------------------------------------------------*/

#define REBUILD_R_SHEETS                                                        \
  if (rulesref != UNDISPLAYED)                                                  \
    {                                                                           \
      /* getting sheets number and names */                                     \
      sheetsnb = GetSheetsNames(rulesref, &sheetsnames);                        \
                                                                                \
      /* creating sheet selector */                                             \
      TtaNewSelector (cssbasedlg + CSS_TARGET_SHEET, cssbasedlg + CSS_RULES_DLG,\
		      NULL, sheetsnb, sheetsnames, 7, NULL, FALSE, TRUE);       \
    }


/*----------------------------------------------------------------------
   REBUILD_R_RULES : rebuilds the rules list of the rules window
  ----------------------------------------------------------------------*/

#define REBUILD_R_RULES                                                         \
  if (rulesref != UNDISPLAYED)                                                  \
    {                                                                           \
      /* getting sheets number and names */                                     \
      rulesnb = GetRulesNames(activecss[rulesref], &rulesnames);           \
                                                                                \
      /* creating sheet selector */                                             \
      TtaNewSelector (cssbasedlg + CSS_RULES_LIST, cssbasedlg + CSS_RULES_DLG,  \
	              NULL, rulesnb, rulesnames, 7, NULL, TRUE, TRUE);          \
    }


/************************************************************************
 *                                                                      *
 *                         CSS CALLBACK HANDLING                        *
 *                                                                      *
 ************************************************************************/

/*----------------------------------------------------------------------
   CSSCallbackHandle : procedure for style dialogue events          
  ----------------------------------------------------------------------*/

#ifdef __STDC__
void                CSSCallbackHandle (int ref, int typedata, char *data)
#else
void                CSSCallbackHandle (ref, typedata, data)
int                 ref;
int                 typedata;
char               *data;

#endif
{
  CSSRulePtr        rule;
  int               i,sheetsnb, rulesnb;
  char             *sheetsnames, *rulesnames;
  char             *documentext, *newdocname;
  int               docnamelen;
  BinFile           cssfile;

#ifdef DEBUG_CSS
   if (typedata == INTEGER_DATA)
      fprintf (stderr, "CSSCallbackHandle(%d,%d) \n",
	       ref, (int) data);
   else
      fprintf (stderr, "CSSCallbackHandle(%d,\"%s\") \n",
	       ref, (char *) data);
#endif

  switch (ref - cssbasedlg)
    {
/*----------------------------------------------------------------------
           handle event from sheets dialog
  ----------------------------------------------------------------------*/
    case CSS_SHEETS_DLG:
      if (typedata == INTEGER_DATA)
	switch ((int)data)
	  {
	  case 0:     /* undo */
	    sheetsref = UNDISPLAYED;
	    break;
	  case 1:     /* ok */
	    sheetsref = UNDISPLAYED;
	    break;
	  case 2:     /* add sheet */
#ifdef DEBUG_CSS
		fprintf(stderr, "CSSCallbackHandle: add sheet");
#endif
	    SelectCssFile(sheetsref);
#ifdef DEBUG_CSS
		fprintf(stderr, "CSSCallbackHandle: call done\n");
#endif
	    break;
	  case 3:     /* remove sheet */
	    /* !!!!! WARNING: this version definitely removes the CSS from
	       the list. No undo possible. */
	    if (targetcss != NULL)
	      {
		/* update sheets and rules windows */
		if (activecss[sheetsref] == targetcss)
		    activecss[sheetsref] =  GetLastCSS(sheetsref);
		targetcss = NULL;
		REBUILD_S_SHEETS
		REBUILD_R_SHEETS
		/* kills the css */
		DeleteCSS(targetcss, sheetsref);
		targetcss = NULL;
	      }
	    else
	      {
		TtaDisplaySimpleMessage (INFO, CssMsgTable, CSS_NO_SHEET_SELECTED);
#ifdef DEBUG_CSS
		fprintf(stderr, "CSSCallbackHandle: no sheet selected\n");
#endif
	      }
	    break;
	  default:
#ifdef DEBUG_CSS
	    fprintf (stderr, "CSSCallbackHandle: undefined button value.\n");
#endif
	    break;
	  }
      break;

    case CSS_SHEET_NAME: /* user selected a new target css */
      if (typedata == STRING_DATA)
	{
	  targetcss = GetCSSFromName((char *)data, sheetsref);
	}
      break;

    case CSS_MOVE_ICONS: /* moving css */
      if ((typedata == INTEGER_DATA) && (targetcss != NULL))
	{
	  if ((int)data == 0)
	    /* move forth */
	    {
	      fprintf (stderr, "avance\n");
	      MoveCSSToNext(targetcss, sheetsref);
	    }
	  else if ((int)data == 1)
	    /* move back */
	    {
	      fprintf (stderr, "recule\n");
	      MoveCSSToPrev(targetcss, sheetsref);
	    }
	  REBUILD_S_SHEETS
	  REBUILD_R_SHEETS
	  REBUILD_R_RULES
	  targetcss = NULL;
	}
      break;

/*----------------------------------------------------------------------
           handle event from by-example dialog
  ----------------------------------------------------------------------*/
    case CSS_EG_DLG:
      break;
      if (typedata == INTEGER_DATA)
	switch ((int)data)
	  {
	  case 0:     /* cancel */
	    egref = UNDISPLAYED;
	    break;
	  case 1:     /* ok */
	    egref = UNDISPLAYED;
	    TtaDestroyDialogue (cssbasedlg + CSS_RULES_DLG);
	    break;
	  default:
#ifdef DEBUG_CSS
	    fprintf (stderr, "CSSCallbackHandle: undefined button value.\n");
#endif
	    break;
	  }
    case CSS_EG_RULES:
      break;
    case CSS_EG_SHEETS:
      break;
/*----------------------------------------------------------------------
           handle event from rules dialog
  ----------------------------------------------------------------------*/
    case CSS_RULES_DLG:
      if (typedata == INTEGER_DATA)
	switch ((int)data)
	  {
	  case 0:     /* undo */
	    rulesref = UNDISPLAYED;
	    break;

	  case 1:     /* apply */
	    if (!isnewrule)
	      DeleteRule(targetrule, activecss[rulesref], rulesref);
	    StyleParser(editedrule, rulesref, TRUE, activecss[rulesref]);
	    REBUILD_R_RULES
	    isnewrule = FALSE;
	    activecss[rulesref]->modified = TRUE;
	    break;

	  case 2:     /* new */
	    isnewrule = TRUE;
	    targetrule = NULL;
	    TtaSetSelector (cssbasedlg + CSS_RULES_LIST, -1, targetrule->rule);
	    break;

	  case 3:     /* duplicate */
	    if (targetrule != NULL)
	      {
		targetrule = CopyRule(targetrule);
		InsertRule(targetrule, activecss[rulesref]);
		REBUILD_R_RULES
		TtaSetSelector (cssbasedlg + CSS_RULES_LIST, -1, targetrule->rule);
	      }
	    break;

	  case 4:     /* delete */
	    if (targetrule != NULL)
	      {
		DeleteRule(targetrule, activecss[rulesref], rulesref);
		targetrule = NULL;
		REBUILD_R_RULES
	      }
	    break;

	  case 5:     /* separator */
	    /* nothing to be done here */
	    break;

	  case 6:     /* ok */
	    targetrule = NULL;
	    TtaDestroyDialogue (cssbasedlg + CSS_RULES_DLG);
	    if (activecss[rulesref]->modified)
	      {
		/* !!!!! update the documents using this CSS */
		for (i=1; i<=DocumentTableLength; i++)
		  if (activecss[rulesref]->documents[i])
		    GetCSSFromName(activecss[rulesref]->name,
				   (Document)i)->modified = TRUE;
	      }
	    rulesref = UNDISPLAYED;
	    break;

	  default:
#ifdef DEBUG_CSS
	    fprintf (stderr, "CSSCallbackHandle: undefined button value.\n");
#endif
	    break;
	  }
      break;

    case CSS_RULES_LABEL:
      /* nothing to be done */
      break;

    case CSS_RULES_LIST:
      if (typedata == STRING_DATA)
	{
	  if ((rule = GetRuleFromName((char *)data, activecss[rulesref])) != NULL)
	    /* a rule is selected */
	    {
	      if ((targetrule != NULL) && (targetrule->rule == NULL)
		  && activecss[rulesref]->ruleslist == targetrule)
		{
		  /* there was an unparsed new rule, we delete it */
		  activecss[rulesref]->ruleslist = targetrule->nextrule;
		  FreeRule(targetrule);
		}
	      targetrule = rule;
	    }
	  if (editedrule != NULL)
	    TtaFreeMemory(editedrule);
	  editedrule = TtaStrdup((char *)data);
	}
      break;

    case CSS_MODIF_LABEL:
      /* nothing to be done */
      break;

    case CSS_STYLES_ICONS:
      if (typedata == INTEGER_DATA)
	switch ((int)data)
	  {
	  case 0:     /* characters */
	    CSSChangeCharacters(rulesref);
	    break;

	  case 1:     /* colors */
	    break;

	  case 2:     /* line style */
	    break;

	  case 3:     /* format */
	    /* CSSChangeFormat(rulesref); */
	    break;

	  default:
#ifdef DEBUG_CSS
	    fprintf (stderr, "CSSCallbackHandle: undefined button value.\n");
#endif
	    break;
	  }
      break;

    case CSS_TARGET_LABEL:
      /* nothing to be done */
      break;

    case CSS_TARGET_SHEET:
      if (typedata == STRING_DATA)
	{
	  /* updating active css */
	  activecss[rulesref] = GetCSSFromName((char *)data, rulesref);
	  REBUILD_R_RULES
	  TtaSetTextForm (cssbasedlg + CSS_TARGET_SHEET, "");
	  targetrule = NULL;
	}
      break;

/*----------------------------------------------------------------------
           handle event from openfile dialog
  ----------------------------------------------------------------------*/
    case CSS_FILE_DLG:
      if (typedata == INTEGER_DATA)
	switch ((int)data)
	  {
	  case 0:     /* cancel */
	    cssfileref = UNDISPLAYED;
	    break;
	  case 1:     /* ok to load/create file */
	    if (DefaultDocumentName != NULL)
	      {
		/* verifying extension */
		documentext = DefaultDocumentName + 
		  strlen(DefaultDocumentName) - strlen(CSS_FILE_EXTENSION);
		if (strcmp (CSS_FILE_EXTENSION, documentext))
		  {
		    docnamelen = strlen(DefaultDocumentName);
		    newdocname = TtaGetMemory(docnamelen + 
					      strlen(CSS_FILE_EXTENSION));
		    strcpy(newdocname, DefaultDocumentName);
		    strcpy(newdocname + docnamelen, CSS_FILE_EXTENSION);
		  }

		/* creating empty file if necessary */
		if (!TtaFileExist(DefaultDocumentName))
		  {
		    cssfile = TtaWriteOpen (DefaultDocumentName);
		    TtaWriteClose (cssfile);
		  }

	         /* now file exists */
		CSSFileParser(cssfileref, DefaultDocumentName, targetcss, FALSE);
	      }
	    REBUILD_S_SHEETS
	    REBUILD_R_SHEETS
	    cssfileref = UNDISPLAYED;
	    break;
	  default:
#ifdef DEBUG_CSS
	    fprintf (stderr, "CSSCallbackHandle: undefined button value.\n");
#endif
	  }
      break;

    case CSS_DIR_LIST:/* user selects another directory. */
		      /*  updating file list */
      if (typedata == STRING_DATA)
	{
	  if (DirectoryName != NULL)
	    TtaFreeMemory(DirectoryName);
	  DirectoryName = TtaStrdup (data);
	  TtaListDirectory (DirectoryName, cssbasedlg + CSS_FILE_DLG, NULL,
		    -1, CSS_FILE_EXTENSION, 
		    TtaGetMessage (CssMsgTable, UI_CSS_FILE_LIST),
		    cssbasedlg + CSS_FILE_LIST);
	  TtaSetTextForm (cssbasedlg + CSS_FILE_TEXT_BOX, DirectoryName);
	}
      break;

    case CSS_FILE_LIST:/* user selects another file. */
		      /*  updating text box content if necessary */
      if (typedata == STRING_DATA)
	{
	  if (DefaultDocumentName != NULL)
	    TtaFreeMemory(DefaultDocumentName);
	  DefaultDocumentName = TtaGetMemory (strlen(DirectoryName)+strlen(data)+2);
	  if (DefaultDocumentName == NULL)
	    {
	      TtaDisplaySimpleMessage (INFO, CssMsgTable, CSS_OUT_OF_MEMORY);
#ifdef DEBUG_CSS
	      fprintf(stderr, "CSSCallbackHandle: out of memory\n");
#endif
	    }
	  else
	    {
	      strcpy(DefaultDocumentName,DirectoryName);
	      DefaultDocumentName[strlen(DirectoryName)] = '/';
	      strcpy(DefaultDocumentName + strlen(DirectoryName) + 1, data);
	    }
	  TtaSetTextForm (cssbasedlg + CSS_FILE_TEXT_BOX, DefaultDocumentName);
	}
      break;

    case CSS_FILE_TEXT_BOX:
      break;

      /* ifever... */
    default:
#ifdef DEBUG_CSS
      fprintf (stderr, "CSSCallbackHandle: undefined callback value.\n");
#endif
      break;

    }
#ifdef DEBUG_CSS
      PrintListCSS(stderr);
#endif
}
