/* definition des types utilises par la transformation de structure */
/* Stephane Bonhomme Apr 96 */
#define MaxSizePat  500
#define MaxWidthPat 50
#define MaxPatterns 50
#define MAXSTACK 500
#define LGBUFFER 5000
#define NAME_LENGTH 25
#define MAXSCH 10
#define TYPE_NUM_PAGE_BREAK 6
#ifndef PPSTANDALONE


/* definition de la structure de l'arbre sujet */
/* liste chainee des symboles correspondant a chaque fils (couplages) */
typedef struct _strmatchchild
{
  struct _SymbDesc *patsymb; /* symbole de la pattern matche */
  struct _Tagnode *node;    /* noeud de l'arbre sujet */
  struct _strmatchchild *next;  
} strmatchchildren;
 
typedef struct _strmatch
{
  struct _SymbDesc *patsymb; /* symbole de la pattern matche */
  struct _Tagnode *node;    /* noeud de l'arbre sujet */
  strmatchchildren *childmatches;
  struct _strmatch *next;  
} strmatch;


/* definition d'un noeud de l'arbre sujet */
typedef struct _Tagnode
{
  ElementType eltype;		
  Element element;
  struct _Tagnode *parent;
  struct _Tagnode *child;
  struct _Tagnode *next;
  struct _Tagnode *prev;
  boolean isTrans;
  struct _SymbDesc *transsymb;
  strmatch *matches;
  /* tableau des symboles candidats au resultat, associes aux symboles */
  /*correspondant a un ss ensemble des fils du noeud */
  struct _ListSymb *inter;
  int depth;
} Tagnode;

typedef Tagnode *TagTree;


#endif
/* environnement de transformation*/

/* descripteur d'attribut */
typedef struct _AttrDesc
{
  char *NameAttr;
  boolean IsTransf;
  union
  {
    char *_Value;
    struct _s0
    {
      char *_TType;
      char *_TAttr;
    }s0;
  }u;
  struct _AttrDesc *next;
}AttrDesc;

#define Value u._Value
#define TransType u.s0._TType
#define TransAttr u.s0._TAttr


/* definition des structures internes des regles de transformation */
typedef struct _NodeDesc
{
  char *NameType;
  AttrDesc *Attributes;
  struct _NodeDesc *next;
} NodeDesc; 

typedef struct _RuleDesc
{
  char *Name;
  NodeDesc *OptNodes;
  NodeDesc *NewNodes;
  struct _RuleDesc *next;
} RuleDesc;


typedef struct _ListElem
{
  Element elem;
  struct _ListElem *next;
} ListElem;

typedef struct _ListChild
{
  Element elemParent;
  ListElem *children;
  struct _ListChild *next;
} ListChild;


typedef struct _ListSymb
{
  struct _SymbDesc *symb;
  struct _ListSymb *next;
} ListSymb;

/* descripteur de symbole de la pattern */
typedef struct _SymbDesc
{
  char *Name;
  char *Tag;
  RuleDesc *Rule;
  boolean Optional;
  boolean ActiveSymb;
  boolean OptChild;
  int depth;
  AttrDesc *Attributes;
  ListSymb *Children;
  ListSymb *Nexts;
  struct _SymbDesc *next; 
} SymbDesc;

/* descripteurs de transformation */
typedef struct _TransDesc
{
  char *NameTrans;  
  char *UseNSchemas[MAXSCH];
  SSchema UseSSchemas[MAXSCH];
  int nbSchemas;
  int nbPatSymb;
  int nbRules;
  int patdepth;
  ListSymb *First;
  SymbDesc *rootdesc;
  SymbDesc *PatSymbs;
  RuleDesc *Rules;
  boolean ActiveTrans;
  char *TagDest;
  struct _TransDesc *next;  
} TransDesc;



/* liste des transformations associees aux schemas */
typedef struct _trans_sch
{ /* descripteurs de transformations */
  TransDesc *Transformations;
  char *nameschema;		/* nom du schema */
  SSchema strschema;
  boolean active;
  /*date de derniere modif du fichier de transformations */
  time_t  timeLastWrite;		
  /* nombre de transformations*/
  int nbTrans;
  /* porfondeur max des patterns */
  int maxdepth;
  struct _trans_sch * next;
} trans_sch;

struct _match_env
{
#ifndef PPSTANDALONE
  TagTree subjecttree;
  ListChild *listSubTrees;
  int maxSelDepth;
#endif
  trans_sch* transSet;
  
} match_env;

#ifndef PPSTANDALONE
/* document auquel est applique la transformation */
Document TransDoc;
/* elements de dialogue et messages */
int TransBaseDialog;
int TRANSDIAL;
#define TR_TRANSFORM 0
#define TRANS_FAILED 1
#define NO_TRANS 2
#define TRANS_PARSE_ERROR 3
#define TRANS_MSG_MAX 4
#define TransMenu 1
#define MAX_TRANS_DLG 2
#endif

#define ISREADABLECHAR(c) ((int)c >= 48 && (int)c <= 57) || ((int)c >= 65 && (int)c <= 90) || ((int)c >= 95 && (int)c <= 122) || ((int)c >= 161 &&  (int)c <= 255)
