.TH mkwrite 1 "24 April 1991"
.fi
.SH NAME
make writeable -- clear the read-only buffer flag
.SH DESCRIPTION
This macro is provided for the times when you have started to edit a
file, which has read-only status. When CRISP reads in a read-only
file, it sets an internal flag on the buffer to stop the user making any
changes to the buffer, to avoid the common \fIvi(1)\fR situation
where you make a whole load of edits, and then find you cannot save the file.
.P
Calling this macro clears the flag and allows you to edit the buffer.
However, it is your responsibility to do whatever is necessary to ensure
that you can actually save the file.
(You can either change the buffer name -- via \f(HB<Alt-O>\fR, or do
a shell escape and do a \fIchmod(1)\fR on the file). Note that when
the file is written away, it will be written away with the same protection
mode as when the file was read in, NOT the protection of the file
at the time of the write.
.SH MENU/KEYS
This macro can be accessed from the CRISP features menu or by typing
\f(HB<Ctrl-A><Ctrl-W>\fR at the command prompt.
.SH BUGS
Writing the buffer away after having done a chmod will cause the file
to not be writeable a second time because the newly written file
will also be read-only.

