/**************************************************************
 *
 *	CRISP - Custom Reduced Instruction Set Programmers Editor
 *
 *	(C) Paul Fox, 1989
 *
 *    Please See COPYRIGHT notice.
 *
 **************************************************************/
# include	"list.h"

int	cm_version = 14;

# if	defined(NOFUNCTIONS)
# define	MACRO(name)	0
# else
# define	MACRO(name)	(void (*)()) name
void	andand(), assign_to_key(), attach_buffer(), autoload(),
	do_access(), exist(), do_chmod(),
	backspace(), beep(), beginning_of_line(), borders(), unimp(),
	call_registered_macro(), car(), color(), get_color(), command_list(),
	compress(), copy(), process_mouse(), delete_bookmark(),
	com_equ(), com_op(), create_buffer(), cre_edge(), create_window(),
	create_tiled_window(), cvt_to_object(),
	del_char(), inq_buffer_flags(), do_mkdir(),
	do_abort(), do_atoi(), do_break(), do_cd(), do_connect(),
	inq_kbd_char(), inq_lines(), lnot(), minusminus(), next_char(), nothing(), 
	plusplus(), read_char(), use_tab_char(), set_font(),
	cdr(), change_window(), do_continue(), cut(), do_date(), 
	do_debug(), declare(), remove_file(), del_block(), del_buffer(), 
	del_edge(), del_line(), del_to_eol(), del_window(), breaksw(),
	do_disconnect(), dist_to_tab(), do_shell(), key_down(), 
	drop_anchor(), drop_bookmark(), set_echo_line(), edit_file(), 
	file_glob(), do_rand(), do_srand(), set_wm_name(), get_mouse_pos(),
	display_windows(), gotoeob(), end_of_line(), end_of_window(), 
	do_error(), exec_cmd(), do_exit(), do_extern(),
	file_pattern(), find_file(), first_time(), get_parm(), 
	gt_characters(), gt_features(), gt_keyboard(), do_getpid(),
	do_getwd(), do_global(), goto_bookmark(), goto_line(), goto_old_line(),
	do_ega(), debug_support(), set_calling_name(),
	do_if(), do_index(), inq_assignment(), inq_buffer(), inq_called(), 
	inq_clock(), inq_cmd_line(), inq_top_left(),
	inq_command(), do_getenv(), inq_idefault(), inq_itime(), inq_keyboard(), inq_line_length(),
	inq_local_keyboard(), inq_macro(), inq_mksize(), inq_marked(), inq_message(), inq_mode(),
	inq_modified(), inq_msg_level(), inq_names(), inq_position(), inq_scrap(), inq_screen_size(),
	inq_system(), inq_views(), inq_w(), inq_window_size(), 
	insert(), ins_mode(), int_to_key(), is_type(),
	key_to_int(), kbd_pop(), kbd_push(), kbd_type(), key_left(), 
	list_length(), load_macro(), do_lower(),
	ltrim(), enter_macro(), mark(), move_edge(),
	make_local_variable(), display_mode(),
	move_rel(), next_buffer(), next_window(),
	nth(), output_file(), page_down(), page_up(),
	paste(), do_pause(), pause_on_error(), playback(), prev_char(), do_printf(),
	process(), do_profile(), put_nth(), put_parm(), 
	quote(), quote_regexp(), raise_anchor(),
	do_read(), read_file(), redraw(), update(), register_macro(), remember(), 
	restore_position(), returns(), re_syntax_fn(),
	key_right(), do_rindex(), save_position(), send_signal(),
	set_process_position(), inq_process_position(), screen_dump(),
	search_list(), macro_list(), sort_buffer(),
	search(), srch_case(), srch_string(), string_count(),
	selfinsert(), set_backup(), set_buffer(), set_buffer_flags(),
	translate_pos(), do_umask(),
	set_msg_level(), set_scrap_info(), inq_window_buf(),
	st_characters(), st_features(), st_keyboard(), set_top_left(),
	do_sscanf(), make_list(),
	set_window(), do_sleep(), do_sprintf(), do_strlen(),
	substr(), swap_anchor(), do_switch(), do_tabs(), do_time(), gotobob(),
	top_of_window(), transfer(), translate(), trim(), typeof(), undo(), 
	unregister_macro(), key_up(), do_upper(), use_local_keyboard(), 
	do_version(), p_wait(), p_wait_for(), do_while(), window_color(),
	inq_window_color(), do_rename(),
	write_block(), oror(), split()
	;
void	post_plusplus();
void	post_minusminus();
void	inq_window_info();
void	do_for();
void	do_do();
# endif
/*--------------------------------------------------*/
/*   Keyword table. Must be in alphabetic order.    */
/*--------------------------------------------------*/

BUILTIN builtin[] = {
{"!", MACRO(lnot), 0, 0,		/* arith */
	1, {ARG_NUM}},

{"!=", MACRO(com_op), 0, NE,		/* arith */
	2, {ARG_ANY, ARG_ANY}},
	
{"%", MACRO(com_op), 0, MODULO,		/* arith */
	2, {ARG_INT, ARG_INT}},

{"%=", MACRO(com_op), 0, MODULO,	/* arith */
	2, {ARG_LVAL | ARG_INT, ARG_INT}},

{"&", MACRO(com_op), 0, BAND,		/* arith */
	2, {ARG_INT, ARG_INT}},

{"&&", MACRO(andand), 0, 0,		/* arith */
	2, {ARG_INT, ARG_COND}},

{"&=", MACRO(com_equ), 0, BAND, 	/* arith */
	2, {ARG_LVAL | ARG_INT, ARG_INT}},

{"*", MACRO(com_op), 0, MULTIPLY,       /* arith */
	2, {ARG_NUM | ARG_STRING, ARG_NUM | ARG_STRING}},

{"*=", MACRO(com_equ), 0, MULTIPLY,	/* arith */
	2, {ARG_LVAL | ARG_NUM, ARG_NUM}},

{"+", MACRO(com_op), 0, PLUS,		/* arith */
	2, {ARG_ANY, ARG_ANY}},

{"++", MACRO(plusplus), 0, 0,		/* arith */
	1, {ARG_LVAL | ARG_NUM}},

{"+=", MACRO(com_equ), 0, PLUS,		/* arith */
	2, {ARG_LVAL | ARG_ANY, ARG_ANY}},

{"-", MACRO(com_op), 0, MINUS,		/* arith */
	2, {ARG_NUM, ARG_NUM}},

{"--", MACRO(minusminus), 0, 0,		/* arith */
	1, {ARG_LVAL | ARG_NUM}},

{"-=", MACRO(com_equ), 0, MINUS,	/* arith */
	2, {ARG_LVAL | ARG_NUM, ARG_NUM}},

{"/", MACRO(com_op), 0, DIVIDE,		/* arith */
	2, {ARG_NUM, ARG_NUM}},

{"/=", MACRO(com_equ), 0, DIVIDE,	/* arith */
	2, {ARG_LVAL | ARG_NUM, ARG_NUM}},

{"<", MACRO(com_op), 0, LT,		/* arith */
	2, {ARG_NUM | ARG_STRING, ARG_NUM | ARG_STRING}},

{"<<", MACRO(com_op), 0, LSHIFT,	/* arith */
	2, {ARG_INT, ARG_INT}},

{"<<=", MACRO(com_equ), 0, LSHIFT,	/* arith */
	2, {ARG_LVAL | ARG_INT, ARG_INT}},

{"<=", MACRO(com_op), 0, LE,		/* arith */
	2, {ARG_NUM | ARG_STRING, ARG_NUM | ARG_STRING}},

{"=", MACRO(com_equ), 0, NOOP,		/* arith */
	2, {ARG_LVAL | ARG_ANY, ARG_OPT | ARG_ANY}},

{"==", MACRO(com_op), 0, EQ,		/* arith */
	2, {ARG_NUM | ARG_STRING, ARG_NUM | ARG_STRING}},

{">", MACRO(com_op), 0, GT,		/* arith */
	2, {ARG_NUM | ARG_STRING, ARG_NUM | ARG_STRING}},

{">=", MACRO(com_op), 0, GE,		/* arith */
	2, {ARG_NUM | ARG_STRING, ARG_NUM | ARG_STRING}},

{">>", MACRO(com_op), 0, RSHIFT,	/* arith */
	2, {ARG_INT, ARG_INT}},

{">>=", MACRO(com_equ), 0, RSHIFT,	/* arith */
	2, {ARG_LVAL | ARG_INT, ARG_INT}},

{"^", MACRO(com_op), 0, BXOR,		/* arith */
	2, {ARG_INT, ARG_INT}},

{"^=", MACRO(com_equ), 0, BXOR, 	/* arith */
	2, {ARG_LVAL | ARG_INT, ARG_INT}},

{"_bad_key", MACRO(nothing), 0, 0,	/* misc */
	0, {0}},

{"abort", MACRO(do_abort), 0, 0,	/* debug */
	0, {0}},

{"above", MACRO(com_op), 0, ABOVE,	/* arith */
	2, {ARG_NUM, ARG_NUM}},

{"above_eq", MACRO(com_op), 0, ABOVE_EQ,/* arith */
	2, {ARG_NUM, ARG_NUM}},

{"access", MACRO(do_access), 0, 0,	/* file */
	2, {ARG_STRING, ARG_OPT | ARG_INT}},

{"acos", MACRO(do_acos), 0, 0,		/* float, arith */
	1, {ARG_FLOAT}},

{"asin", MACRO(do_asin), 0, 0,		/* float, arith */
	1, {ARG_FLOAT}},

{"assign_to_key", MACRO(assign_to_key), B_NOVALUE, 0,	/* kbd */
	2, {ARG_OPT | ARG_STRING, ARG_OPT | ARG_STRING}},

{"atan", MACRO(do_atan), 0, 0,		/* float, arith */
	1, {ARG_FLOAT}},

{"atan2", MACRO(do_atan2), 0, 0,	/* float, arith */
	2, {ARG_FLOAT, ARG_FLOAT}},

{"atoi", MACRO(do_atoi), 0, 0,		/* string */
	2, {ARG_STRING, ARG_OPT | ARG_INT}},

{"attach_buffer", MACRO(attach_buffer), 0, 0,	/* buffer */
	1, {ARG_INT}},

{"autoload", MACRO(autoload), B_NOVALUE, 0,	/* macro */
	2, {ARG_STRING, ARG_REST}},

{"backspace", MACRO(backspace), 0, 0,	/* movement */
	0, {0}},

{"beep", MACRO(beep), 0, 0,		/* misc */
	0, {0}},

{"beginning_of_line", MACRO(beginning_of_line), 0, 0,	/* movement */
	0, {0}},

{"below", MACRO(com_op), 0, BELOW,	/* arith */
	2, {ARG_NUM, ARG_NUM}},

{"below_eq", MACRO(com_op), 0, BELOW_EQ,	/* arith */
	2, {ARG_NUM, ARG_NUM}},

{"bookmark_list", MACRO(bookmark_list), 0, 0,	/* movement */
	0, {0}},

{"borders", MACRO(borders), 0, 0,	/* screen */
	1, {ARG_OPT | ARG_INT}},

{"break", MACRO(do_break), 0, 0,		/* macro */
	0, {0}},

{"breaksw", MACRO(breaksw), 0, 0,		/* macro */
	0, {0}},

{"call_registered_macro", MACRO(call_registered_macro), 0, 0,	/* macro */
	1, {ARG_INT}},

{"car", MACRO(car), 0, 0,		/* list */
	1, {ARG_LIST}},

{"cd", MACRO(do_cd), 0, 0,		/* env */
	1, {ARG_OPT | ARG_STRING}},

{"cdr", MACRO(cdr), 0, 0, 		/* list */
	1, {ARG_LIST}},

{"ceil", MACRO(do_ceil), 0, 0,		/* float, arith */
	1, {ARG_FLOAT}},

{"change_window", MACRO(change_window), 0, 0, 	/* window */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_STRING}},

{"chmod", MACRO(do_chmod), 0, 0,		/* file */
	2, {ARG_INT, ARG_STRING}},

{"color", MACRO(color), 0, 0,			/* screen */
	7, {ARG_OPT | ARG_INT | ARG_STRING, 
	    ARG_OPT | ARG_INT | ARG_STRING,
	    ARG_OPT | ARG_INT | ARG_STRING,
	    ARG_OPT | ARG_INT | ARG_STRING,
	    ARG_OPT | ARG_INT | ARG_STRING,
	    ARG_OPT | ARG_INT | ARG_STRING,
	    ARG_OPT | ARG_STRING}},

{"command_list", MACRO(command_list), 0, 0,	/* list */
	0, {0}},

{"compress", MACRO(compress), 0, 0, 		/* string */
	2, {ARG_STRING, ARG_OPT | ARG_INT}},

{"connect", MACRO(do_connect), 0, 0,		/* proc */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_STRING}},

{"continue", MACRO(do_continue), 0, 0,		/* macro */
	0, {0}},

{"copy", MACRO(copy), 0, 0,			/* scrap */
	1, {ARG_OPT | ARG_INT}},

{"copy_keyboard", MACRO(copy_keyboard), 0, 0,		/* kbd */
	2, {ARG_INT, ARG_REST}},

{"cos", MACRO(do_cos), 0, 0,		/* float, arith */
	1, {ARG_FLOAT}},

{"cosh", MACRO(do_cosh), 0, 0,		/* float, arith */
	1, {ARG_FLOAT}},

{"create_buffer", MACRO(create_buffer), 0, 0,	/* buffer */
	4, {ARG_STRING, ARG_OPT | ARG_STRING, 
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"create_char_map", MACRO(create_char_map), 0, 0, /* buffer, window, env */
	4, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT, 
	    ARG_LIST, ARG_OPT | ARG_LIST}},

{"create_edge", MACRO(cre_edge), 0, 0, 		/* window */
	1, {ARG_OPT | ARG_INT}},

{"create_tiled_window", MACRO(create_tiled_window), 0, 0,	/* window */
	5, {ARG_INT, ARG_INT, ARG_INT, ARG_INT, ARG_OPT | ARG_INT}},

{"create_window", MACRO(create_window), 0, 0,	/* window */
	5, {ARG_INT, ARG_INT, ARG_INT, ARG_INT, ARG_OPT | ARG_STRING}},

{"cut", MACRO(cut), 0, 0,				/* scrap */
	1, {ARG_OPT | ARG_INT}},

{"cvt_to_object", MACRO(cvt_to_object), 0, 0,	/* string, arith */
	2, {ARG_STRING, ARG_OPT | ARG_LVAL | ARG_INT}},

{"date", MACRO(do_date), 0, 0,			/* misc */
	5, {ARG_OPT | ARG_LVAL | ARG_INT,
	   ARG_OPT | ARG_LVAL | ARG_INT,
	   ARG_OPT | ARG_LVAL | ARG_INT,
	   ARG_OPT | ARG_LVAL | ARG_STRING,
	   ARG_OPT | ARG_LVAL | ARG_STRING}},

{"debug", MACRO(do_debug), 0, 0,			/* debug */
	1, {ARG_OPT | ARG_INT}},

{"debug_support", MACRO(debug_support), 0, 0,	/* debug */
	3, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT, ARG_OPT | ARG_STRING}},

{"declare", MACRO(declare), B_NOVALUE, F_POLY,	/* var */
	1, {ARG_REST}},

{"delete_block", MACRO(del_block), 0, 0,		/* scrap */
	0, {0}},

{"delete_bookmark", MACRO(delete_bookmark), 0, 0,		/* movement */
	1, {ARG_INT}},

{"delete_buffer", MACRO(del_buffer), 0, 0,	/* buffer */
	1, {ARG_INT}},

{"delete_char", MACRO(del_char), 0, 0,		/* buffer */
	1, {ARG_OPT | ARG_INT}},

{"delete_edge", MACRO(del_edge), 0, 0,		/* window */
	1, {ARG_OPT | ARG_INT}},

{"delete_line", MACRO(del_line), 0, 0,		/* buffer */
	0, {0}},

{"delete_macro", MACRO(unimp), 0, 0,		/* macro */
	1, {ARG_OPT | ARG_STRING}},

{"delete_to_eol", MACRO(del_to_eol), 0, 0,	/* buffer */
	0, {0}},

{"delete_window", MACRO(del_window), 0, 0,	/* window */
	1, {ARG_OPT | ARG_INT}},

{"disconnect", MACRO(do_disconnect), 0, 0,	/* proc */
	0, {0}},

{"display_mode", MACRO(display_mode), 0, 0,	/* screen */
	1, {ARG_OPT | ARG_INT}},

{"display_windows", MACRO(display_windows), 0, 0,	/* screen */
	1, {ARG_OPT | ARG_INT}},

{"distance_to_tab", MACRO(dist_to_tab), 0, 0,	/* buffer, window */
	0, {0}},

{"do", MACRO(do_do), 0, 0,			/* macro */
	2, {ARG_OPT | ARG_COND, ARG_OPT | ARG_REST}},

{"down", MACRO(key_down), 0, 0,			/* movement */
	1, {ARG_OPT | ARG_INT}},

{"drop_anchor", MACRO(drop_anchor), 0, 0,		/* scrap */
	1, {ARG_OPT | ARG_INT}},

{"drop_bookmark", MACRO(drop_bookmark), 0, 0, 	/* movement */
	5, {ARG_OPT | ARG_INT, ARG_OPT | ARG_STRING, 
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT}},

{"echo_line", MACRO(set_echo_line), 0, 0,		/* screen */
	1, {ARG_OPT | ARG_INT}},

{"edit_file", MACRO(edit_file), 0, 0,		/* file */
	1, {ARG_OPT | ARG_REST}},

{"ega", MACRO(do_ega), 0, 0,			/* screen */
	1, {ARG_OPT | ARG_INT}},

{"end_of_buffer", MACRO(gotoeob), 0, 0,		/* movement */
	0, {0}},

{"end_of_line", MACRO(end_of_line), 0, 0,		/* movement */
	0, {0}},

{"end_of_window", MACRO(end_of_window), 0, 0,	/* movement */
	0, {0}},

{"error", MACRO(do_error), 0, 0,			/* debug */
	5, {ARG_STRING, ARG_OPT | ARG_NUM | ARG_STRING,
	    ARG_OPT | ARG_NUM | ARG_STRING,
	    ARG_OPT | ARG_NUM | ARG_STRING,
	    ARG_OPT | ARG_NUM | ARG_STRING,
	    ARG_OPT | ARG_NUM | ARG_STRING}},

{"eval", 0, 0, 0,				/* arith, macro, string */
	1, {ARG_STRING}},

{"execute_macro", MACRO(exec_cmd), 0, 0,		/* macro */
	2, {ARG_OPT | ARG_STRING, ARG_OPT | ARG_REST}},

{"exist", MACRO(exist), 0, 0,			/* file */
	1, {ARG_STRING}},

{"exit", MACRO(do_exit), 0, 0,			/* macro */
	1, {ARG_OPT | ARG_STRING}},

{"exp", MACRO(do_exp), 0, 0,			/* float, arith */
	1, {ARG_FLOAT}},

{"extern", MACRO(do_extern), 0, 0,		/* var */
	1, {ARG_REST}},

{"fabs", MACRO(do_fabs), 0, 0,			/* float, arith */
	1, {ARG_FLOAT}},

{"file_glob", MACRO(file_glob), 0, 0,		/* file, list */
	1, {ARG_STRING}},

{"file_pattern", MACRO(file_pattern), 0, 0,	/* file */
	1, {ARG_STRING}},

{"find_file", MACRO(find_file), 0, 0,		/* file */
	5, {ARG_OPT | ARG_LVAL | ARG_STRING,
	   ARG_OPT | ARG_LVAL | ARG_INT,
	   ARG_OPT | ARG_LVAL | ARG_INT,
	   ARG_OPT | ARG_LVAL | ARG_INT,
	   ARG_OPT | ARG_LVAL | ARG_INT}},

{"find_macro", MACRO(find_macro), 0, 0,		/* macro, file */
	1, {ARG_STRING}},

{"first_time", MACRO(first_time), 0, 0,		/* macro */
	0, {0}},

{"float", MACRO(declare), B_NOVALUE, F_FLOAT,	/* var, float */
	1, {ARG_REST}},

{"floor", MACRO(do_floor), 0, 0,		/* float, arith */
	1, {ARG_FLOAT}},

{"fmod", MACRO(do_fmod), 0, 0,			/* float, arith */
	2, {ARG_FLOAT, ARG_FLOAT}},

{"for", MACRO(do_for), 0, 0,			/* macro */
	4, {ARG_OPT | ARG_ANY, ARG_OPT | ARG_COND,
	    ARG_OPT | ARG_COND, ARG_OPT | ARG_REST}},

{"frexp", MACRO(do_frexp), 0, 0,		/* float, arith */
	2, {ARG_FLOAT, ARG_LVAL | ARG_INT}},

{"get_color", MACRO(get_color), 0, 0,		/* screen */
	7, {ARG_OPT | ARG_LVAL | ARG_INT, ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT, ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT, ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT}},

{"get_mouse_pos", MACRO(get_mouse_pos), 0, 0,	/* kbd */
	2, {ARG_LVAL | ARG_OPT | ARG_INT, ARG_LVAL | ARG_OPT | ARG_INT}},

{"get_parm", MACRO(get_parm), 0, 0,		/* macro, var */
	5, {ARG_OPT | ARG_INT,
	    ARG_LVAL | ARG_ANY, ARG_OPT | ARG_STRING,
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_ANY}},

{"get_term_characters", MACRO(gt_characters), B_NOVALUE, 0,	/* screen, env */
	1, {ARG_REST}},

{"get_term_features", MACRO(gt_features), B_NOVALUE, 0,	/* screen, env */
	1, {ARG_REST}},

{"get_term_keyboard", MACRO(gt_keyboard), B_NOVALUE, 0,	/* screen, env, kbd */
	1, {ARG_REST}},

{"getenv", MACRO(do_getenv), 0, 0, 		/* env */
	1, {ARG_STRING}},

{"getpid", MACRO(do_getpid), 0, 0,		/* env */
	0, {0}},

{"getwd", MACRO(do_getwd), 0, 0,			/* env */
	2, {ARG_OPT | ARG_STRING, ARG_LVAL | ARG_STRING}},

{"global", MACRO(do_global), B_NOVALUE, 0,	/* var */
	1, {ARG_REST}},

{"goto_bookmark", MACRO(goto_bookmark), 0, 0,	/* buffer */
	4, {ARG_OPT | ARG_INT, ARG_LVAL | ARG_OPT | ARG_INT,
	    ARG_LVAL | ARG_OPT | ARG_INT,
	    ARG_LVAL | ARG_OPT | ARG_INT}},

{"goto_line", MACRO(goto_line), 0, 0,		/* movement */
	1, {ARG_OPT | ARG_INT}},

{"goto_old_line", MACRO(goto_old_line), 0, 0,	/* movement */
	1, {ARG_OPT | ARG_INT}},

{"if", MACRO(do_if), 0, 0,			/* macro */
	3, {ARG_NUM | ARG_STRING, ARG_COND, ARG_OPT | ARG_COND}},

{"index", MACRO(do_index), 0, 0,		/* string */
	2, {ARG_STRING, ARG_STRING}},

{"input_mode", MACRO(input_mode), 0, 0,		/* kbd */
	2, {ARG_INT, ARG_INT}},

{"inq_assignment", MACRO(inq_assignment), 0, 0,	/* kbd */
	2, {ARG_STRING | ARG_INT, ARG_OPT | ARG_INT}},

{"inq_borders", MACRO(unimp), 0, 0,		/* screen */
	0, {0}},

{"inq_brief_level", MACRO(unimp), 0, 0,		/* env */
	0, {0}},

{"inq_buffer", MACRO(inq_buffer), 0, 0,		/* buffer, file */
	1, {ARG_OPT | ARG_STRING}},

{"inq_buffer_flags", MACRO(inq_buffer_flags), 0, 0,	/* buffer */
	1, {ARG_OPT | ARG_INT}},

{"inq_called", MACRO(inq_called), 0, 0,		/* macro */
	0, {0}},

{"inq_char_map", MACRO(inq_char_map), 0, 0, 	/* buffer, env, window */
	1, {ARG_OPT | ARG_INT}},

{"inq_clock", MACRO(inq_clock), 0, 0,		/* misc */
	0, {0}},

{"inq_cmd_line", MACRO(inq_cmd_line), 0, 0,	/* screen */
	0, {0}},

{"inq_command", MACRO(inq_command), 0, 0,	/* screen */
	0, {0}},

{"inq_idle_default", MACRO(inq_idefault), 0, 0,	/* env */
	0, {0}},

{"inq_idle_time", MACRO(inq_itime), 0, 0,		/* env */
	0, {0}},

{"inq_kbd_char", MACRO(inq_kbd_char), 0, 0,	/* kbd */
	0, {0}},

{"inq_keyboard", MACRO(inq_keyboard), 0, 0,	/* kbd */
	0, {0}},

{"inq_keystroke_macro", MACRO(inq_keystroke_macro), 0, 0,	/* kbd */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_LVAL | ARG_INT}},

{"inq_line_length", MACRO(inq_line_length), 0, 0, /* buffer */
	1, {ARG_OPT | ARG_INT}},

{"inq_lines", MACRO(inq_lines), 0, 0,		/* buffer */
	1, {ARG_OPT | ARG_INT}},

{"inq_local_keyboard", MACRO(inq_local_keyboard), 0, 0, /* kbd */
	0, {0}},

{"inq_macro", MACRO(inq_macro), 0, 0,		/* macro */
	1, {ARG_STRING}},

{"inq_mark_size", MACRO(inq_mksize), 0, 0,	/* scrap */
	0, {0}},

{"inq_marked", MACRO(inq_marked), 0, 0,		/* scrap */
	4, {ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT}},

{"inq_message", MACRO(inq_message), 0, 0,		/* screen */
	0, {0}},

{"inq_mode", MACRO(inq_mode), 0, 0,		/* buffer, window */
	0, {0}},

{"inq_modified", MACRO(inq_modified), 0, 0,	/* buffer */
	1, {ARG_OPT | ARG_INT}},

{"inq_msg_level", MACRO(inq_msg_level), 0, 0,	/* macro */
	0, {0}},

{"inq_names", MACRO(inq_names), 0, 0,		/* buffer */
	4, {ARG_OPT | ARG_LVAL | ARG_STRING,
	    ARG_OPT | ARG_LVAL | ARG_STRING,
	    ARG_OPT | ARG_LVAL | ARG_STRING,
	    ARG_OPT | ARG_INT}},

{"inq_position", MACRO(inq_position), 0, 0,	/* window, buffer */
	2, {ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT}},

{"inq_process_position", MACRO(inq_process_position), 0, 0, /* proc, buffer */
	2, {ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT}},

{"inq_scrap", MACRO(inq_scrap), 0, 0, 		/* scrap */
	2, {ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT}},

{"inq_screen_size", MACRO(inq_screen_size), 0, 0, /* screen */
	2, {ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT}},

{"inq_system", MACRO(inq_system), 0, 0,		/* buffer */
	0, {0}},

{"inq_top_left", MACRO(inq_top_left), 0, 0,	/* buffer, window */
	6, {ARG_LVAL | ARG_OPT | ARG_INT,
	    ARG_LVAL | ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT,
	    ARG_LVAL | ARG_OPT | ARG_INT,
	    ARG_LVAL | ARG_OPT | ARG_INT,
	    ARG_LVAL | ARG_OPT | ARG_INT}},

{"inq_views", MACRO(inq_views), 0, 0,		/* buffer, window */
	1, {ARG_OPT | ARG_INT}},

{"inq_window", MACRO(inq_w), 0, 0,		/* window */
	0, {0}},

{"inq_window_buf", MACRO(inq_window_buf), 0, 0,	/* buffer, window */
	1, {ARG_OPT | ARG_INT}},

{"inq_window_color", MACRO(inq_window_color), 0, 0,	/* window, screen */
	1, {ARG_OPT | ARG_INT}},

{"inq_window_info", MACRO(inq_window_info), 0, 0,		/* window */
	6, {ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT}},

{"inq_window_size", MACRO(inq_window_size), 0, 0, /* window, screen */
	3, {ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT}},

{"insert", MACRO(insert), 0, FALSE,		/* buffer, window */
	2, {ARG_INT | ARG_STRING, ARG_OPT | ARG_INT}},

{"insert_mode", MACRO(ins_mode), 0, 0,		/* buffer, window */
	1, {ARG_OPT | ARG_INT}},

{"insert_process", MACRO(insert), 0, TRUE,	/* buffer, window, proc */
	2, {ARG_STRING, ARG_OPT | ARG_INT}},

{"int", MACRO(declare), B_NOVALUE, F_INT,	/* var */
	1, {ARG_REST}},

{"int_to_key", MACRO(int_to_key), 0, 0,		/* kbd */
	1, {ARG_INT}},

{"is_integer", MACRO(is_type), 0, F_INT,	/* var */
	1, {ARG_LVAL | ARG_ANY}},

{"is_list", MACRO(is_type), 0, F_LIST, 		/* var */
	1, {ARG_LVAL | ARG_ANY}},

{"is_null", MACRO(is_type), 0, F_NULL,		/* var */
	1, {ARG_LVAL | ARG_ANY}},

{"is_string", MACRO(is_type), 0, F_STR,		/* var */
	1, {ARG_LVAL | ARG_ANY}},

{"key_list", MACRO(key_list), 0, 0,		/* kbd */
	3, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT}},

{"key_to_int", MACRO(key_to_int), 0, 0,		/* kbd */
	2, {ARG_STRING, ARG_OPT | ARG_INT}},

{"keyboard_flush", MACRO(kbd_flush), 0, 0,	/* kbd */
	0, {0}},

{"keyboard_pop", MACRO(kbd_pop), 0, 0,		/* kbd */
	1, {ARG_OPT | ARG_INT}},

{"keyboard_push", MACRO(kbd_push), 0, 0,	/* kbd */
	1, {ARG_OPT | ARG_INT}},

{"keyboard_typeables", MACRO(kbd_type), 0, 0,	/* kbd */
	0, {0}},

{"ldexp", MACRO(do_ldexp), 0, 0,		/* float, arith */
	2, {ARG_FLOAT, ARG_INT}},

{"left", MACRO(key_left), 0, 0, 		/* movement */
	1, {ARG_OPT | ARG_INT}},
{"length_of_list", MACRO(list_length), 0, 0,/* list */
	1, {ARG_LIST}},

{"list", MACRO(declare), B_NOVALUE, F_LIST,	/* var, list */
	1, {ARG_REST}},

{"load_keystroke_macro", MACRO(load_keystroke_macro), 0, 0,	/* kbd */
	1, {ARG_STRING}},

{"load_macro", MACRO(load_macro), 0, 0,		/* macro */
	1, {ARG_OPT | ARG_STRING}},

{"log", MACRO(do_log), 0, 0,			/* float, arith */
	1, {ARG_FLOAT}},

{"log10", MACRO(do_log10), 0, 0,			/* float, arith */
	1, {ARG_FLOAT}},

{"lower", MACRO(do_lower), 0, 0,		/* string */
	1, {ARG_STRING}},

{"ltrim", MACRO(ltrim), 0, 0,			/* string */
	2, {ARG_STRING, ARG_OPT | ARG_STRING}},

{"macro", MACRO(enter_macro),  B_NOVALUE, 0,	/* macro, */
	2, {ARG_COND, ARG_REST | ARG_OPT}},

{"macro_list", MACRO(macro_list), 0, 0,		/* string, list */
	0, {0}},

{"make_list", MACRO(make_list), 0, 0,		/* list */
	-1, {ARG_OPT | ARG_ANY}},
	
{"make_local_variable", MACRO(make_local_variable), B_NOVALUE, 0,	/* var */
	1, {ARG_REST}},

{"mark", MACRO(mark), 0, 0,			/* scrap */
	1, {ARG_OPT | ARG_INT}},

{"message", MACRO(message), B_NOVALUE, 0,	/* debug */
	-8, {ARG_STRING, 
	   ARG_OPT | ARG_ANY, ARG_OPT | ARG_ANY,
	   ARG_OPT | ARG_ANY, ARG_OPT | ARG_ANY,
	   ARG_OPT | ARG_ANY, ARG_OPT | ARG_ANY, ARG_OPT | ARG_ANY}},

{"mkdir", MACRO(do_mkdir), 0, 0,		/* file */
	2, {ARG_STRING, ARG_OPT | ARG_INT}},

{"modf", MACRO(do_modf), 0, 0,			/* float, arith */
	2, {ARG_FLOAT, ARG_LVAL | ARG_FLOAT}},

{"move_abs", MACRO(move_abs), 0, 0,		/* movement */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"move_edge", MACRO(move_edge), 0, 0,		/* window */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"move_rel", MACRO(move_rel), 0, 0,		/* movement */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"next_buffer", MACRO(next_buffer), 0, 0,	/* buffer */
	2, {ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT}},

{"next_char", MACRO(next_char), 0, 0,		/* movement */
	1, {ARG_OPT | ARG_INT}},

{"next_window", MACRO(next_window), 0, 0,	/* window */
	1, {ARG_OPT | ARG_INT}},

{"nothing", MACRO(nothing), 0, 0,		/* macro */
	0, {0}},

{"nth", MACRO(nth), B_SAFE, 0,			/* list */
	2, {ARG_INT, ARG_LIST}},

{"output_file", MACRO(output_file), 0, 0,	/* file */
	1, {ARG_OPT | ARG_STRING}},

{"page_down", MACRO(page_down), 0, 0,		/* movement */
	0, {0}},

{"page_up", MACRO(page_up), 0, 0,		/* movement */
	0, {0}},

{"paste", MACRO(paste), 0, 0,			/* scrap */
	0, {0}},

{"pause", MACRO(do_pause), 0, 0,		/* kbd */
	0, {0}},

{"pause_on_error", MACRO(pause_on_error), 0, 0,	/* debug */
	1, {ARG_OPT | ARG_INT}},

{"playback", MACRO(playback), 0, 0,		/* kbd */
	1, {ARG_OPT | ARG_INT}},

{"post++", MACRO(post_plusplus), 0, 0,		/* arith */
	1, {ARG_LVAL | ARG_NUM}},

{"post--", MACRO(post_minusminus), 0, 0,	/* arith */
	1, {ARG_LVAL | ARG_NUM}},

{"pow", MACRO(do_pow), 0, 0,			/* float, arith */
	2, {ARG_FLOAT, ARG_FLOAT}},

{"prev_char", MACRO(prev_char), 0, 0,		/* movement */
	1, {ARG_OPT | ARG_INT}},

{"print", MACRO(unimp), 0, 0,			/* debug */
	0, {0}},

{"printf", MACRO(do_printf), 0, 0,		/* debug */
	7, {ARG_STRING, 
	   ARG_OPT | ARG_ANY, ARG_OPT | ARG_ANY,
	   ARG_OPT | ARG_ANY, ARG_OPT | ARG_ANY,
	   ARG_OPT | ARG_ANY, ARG_OPT | ARG_ANY}},

{"process", MACRO(process), 0, 0,		/* kbd */
	0, {0}},

{"process_mouse", MACRO(process_mouse), 0, 0,	/* kbd, misc */
	5, {ARG_INT, ARG_INT, ARG_INT, ARG_INT, ARG_INT}},

{"profile", MACRO(do_profile), 0, 0,		/* debug */
	1, {ARG_OPT | ARG_INT}},

{"push_back", MACRO(push_back), 0, 0,		/* kbd */
	1, {ARG_INT}},

{"put_nth", MACRO(put_nth), 0, 0,		/* list */
	3, {ARG_INT, ARG_LVAL | ARG_LIST, ARG_ANY}},

{"put_parm", MACRO(put_parm), 0, 0,		/* macro, var */
	2, {ARG_INT, ARG_ANY}},

{"quote_list", MACRO(quote), 0, 0,		/* list */
	1, {ARG_REST}},

{"quote_regexp", MACRO(quote_regexp), 0, 0,	/* string, search */
	1, {ARG_STRING}},

{"raise_anchor", MACRO(raise_anchor), 0, 0,	/* scrap */
	0, {0}},

{"rand", MACRO(do_rand), 0, 0,			/* misc */
	1, {ARG_OPT | ARG_INT}},

{"re_search", MACRO(re_search), 0, 0,		/* search */
	5, {ARG_OPT | ARG_INT, ARG_STRING, 
	    ARG_OPT | ARG_LIST | ARG_STRING,
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_LVAL | ARG_INT}},

{"re_syntax", MACRO(re_syntax_fn), 0, 0,	/* search */
	1, {ARG_OPT | ARG_INT}},

{"re_translate", MACRO(re_translate), 0, 0,	/* search */
	4, {ARG_OPT | ARG_INT, 
	    ARG_OPT | ARG_STRING, 
	    ARG_OPT | ARG_STRING,
	    ARG_OPT | ARG_STRING}},

{"read", MACRO(do_read), 0, 0,			/* string */
	1, {ARG_OPT | ARG_INT}},

{"read_char", MACRO(read_char), 0, 0,		/* kbd */
	2, {ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT}},

{"read_file", MACRO(read_file), 0, 0,		/* file */
	1, {ARG_OPT | ARG_STRING}},

{"redraw", MACRO(redraw), 0, 0,			/* screen */
	0, {0}},

{"refresh", MACRO(update), 0, 0,		/* screen */
	0, {0}},

{"register_macro", MACRO(register_macro), 0, 0,	/* macro */
	3, {ARG_INT, ARG_STRING, ARG_OPT | ARG_INT}},

{"remember", MACRO(remember), 0, 0,		/* kbd */
	2, {ARG_OPT | ARG_STRING, ARG_OPT | ARG_INT}},

{"remove", MACRO(remove_file), 0, 0, 		/* file */
	1, {ARG_STRING}},

{"rename", MACRO(do_rename), 0, 0,		/* file */
	2, {ARG_STRING, ARG_STRING}},

{"replacement", MACRO(enter_macro), B_NOVALUE, 0,	/* macro */
	2, {ARG_COND, ARG_REST}},

{"restore_position", MACRO(restore_position), 0, 0, /* movement, macro */
	1, {ARG_OPT | ARG_INT}},

{"return", MACRO(returns), 0, FALSE,		/* macro */
	1, {ARG_OPT | ARG_ANY}},

{"returns", MACRO(returns), 0, TRUE,		/* macro */
	1, {ARG_ANY}},

{"right", MACRO(key_right), 0, 0, 		/* buffer, window */
	1, {ARG_OPT | ARG_INT}},

{"rindex", MACRO(do_rindex), 0, 0,		/* string */
	2, {ARG_STRING, ARG_STRING}},

{"save_keystroke_macro", MACRO(unimp), 0, 0,	/* kbd */
	0, {0}},

{"save_position", MACRO(save_position), 0, 0,	/* movement, macro */
	0, {0}},

{"screen_dump", MACRO(screen_dump), 0, 0,	/* screen */
	1, {ARG_OPT | ARG_STRING}},

{"search_back", MACRO(search), 0, FALSE,	/* movement, search */
	5, {ARG_OPT | ARG_STRING,
	    ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT}},

{"search_case", MACRO(srch_case), 0, 0,		/* search */
	1, {ARG_OPT | ARG_INT}},

{"search_fwd", MACRO(search), 0, TRUE,		/* movement, search */
	5, {ARG_OPT | ARG_STRING,
	    ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT}},

{"search_list", MACRO(search_list), 0, 0, 	/* search, list */
	5, {ARG_OPT | ARG_INT, ARG_STRING, ARG_LIST,
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"search_string", MACRO(srch_string), 0, 0, 	/* search, string */
	5, {ARG_OPT | ARG_STRING, ARG_STRING, ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"self_insert", MACRO(selfinsert), 0, 0, 	/* kbd, buffer, window */
	1, {ARG_OPT | ARG_INT}},

{"send_signal", MACRO(send_signal), 0, 0,	/* proc */
	1, {ARG_INT}},

{"set_backup", MACRO(set_backup), 0, 0, 	/* env */
	1, {ARG_OPT | ARG_INT}},

{"set_binary_size", MACRO(set_binary_size), 0, 0,	/* buffer, file */
	1, {ARG_INT}},

{"set_buffer", MACRO(set_buffer), 0, 0, 	/* buffer */
	1, {ARG_INT}},

{"set_buffer_cmap", MACRO(set_buffer_cmap), 0, 0, /* buffer, env, window */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"set_buffer_flags", MACRO(set_buffer_flags), 0, 0, /* buffer */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"set_calling_name", MACRO(set_calling_name), 0, 0,/* macro */
	1, {ARG_STRING}},

{"set_font", MACRO(set_font), 0, 0,			/* window, env */
	1, {ARG_STRING}},

{"set_idle_default", MACRO(set_idle_default), 0, 0,	/* env */
	1, {ARG_INT}},

{"set_msg_level", MACRO(set_msg_level), 0, 0, /* misc */
	1, {ARG_INT}},

{"set_process_position", MACRO(set_process_position), 0, 0, /* proc, buffer */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"set_scrap_info", MACRO(set_scrap_info), 0, 0, /* scrap */
	3, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"set_term_characters", MACRO(st_characters), B_NOVALUE, 0,	/* screen, env */
	1, {ARG_REST}},

{"set_term_features", MACRO(st_features), B_NOVALUE, 0,	/* screen, env */
	1, {ARG_REST}},

{"set_term_keyboard", MACRO(st_keyboard), B_NOVALUE, 0,	/* screen, env */
	1, {ARG_REST}},

{"set_top_left", MACRO(set_top_left), 0, 0,	/* movement, buffer, window */
	6, {ARG_OPT | ARG_INT, 
	    ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT}},

{"set_window", MACRO(set_window), 0, 0, 	/* window */
	1, {ARG_INT}},

{"set_window_cmap", MACRO(set_window_cmap), 0, 0, /* buffer, env, window */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"set_wm_name", MACRO(set_wm_name), 0, 0,	/* env, window */
	2, {ARG_OPT | ARG_STRING, ARG_OPT | ARG_STRING}},

{"shell", MACRO(do_shell), 0, 0, 		/* env, proc */
	3, {ARG_OPT | ARG_STRING, ARG_OPT | ARG_INT, ARG_OPT | ARG_STRING}},

{"sin", MACRO(do_sin), 0, 0,			/* float, arith */
	1, {ARG_FLOAT}},

{"sinh", MACRO(do_sinh), 0, 0,			/* float, arith */
	1, {ARG_FLOAT}},

{"sleep", MACRO(do_sleep), 0, 0,		/* proc */
	1, {ARG_OPT | ARG_INT}},

{"sort_buffer", MACRO(sort_buffer), 0, 0,	/* buffer */
	1, {ARG_OPT | ARG_INT}},

{"split", MACRO(split), 0, 0,			/* string */
	3, {ARG_STRING, ARG_STRING, ARG_OPT | ARG_INT}},

{"sprintf", MACRO(do_sprintf), B_NOVALUE, 0,	/* string */
	-8, {ARG_LVAL | ARG_STRING, ARG_STRING, 
	   ARG_OPT | ARG_ANY, ARG_OPT | ARG_ANY,
	   ARG_OPT | ARG_ANY, ARG_OPT | ARG_ANY,
	   ARG_OPT | ARG_ANY, ARG_OPT | ARG_ANY}},

{"sqrt", MACRO(do_sqrt), 0, 0,			/* float, arith */
	1, {ARG_FLOAT}},

{"srand", MACRO(do_srand), 0, 0,		/* misc */
	1, {ARG_OPT | ARG_INT}},

{"sscanf", MACRO(do_sscanf), 0, 0,		/* string */
	-8, {ARG_STRING, ARG_STRING, 
	   ARG_LVAL | ARG_OPT | ARG_ANY, ARG_LVAL | ARG_OPT | ARG_ANY,
	   ARG_LVAL | ARG_OPT | ARG_ANY, ARG_LVAL | ARG_OPT | ARG_ANY,
	   ARG_LVAL | ARG_OPT | ARG_ANY, ARG_LVAL | ARG_OPT | ARG_ANY}},

{"string", MACRO(declare), B_NOVALUE, F_STR,	/* var */
	1, {ARG_REST}},

{"string_count", MACRO(string_count), 0, 0, 	/* string */
	2, {ARG_STRING, ARG_STRING}},

{"strlen", MACRO(do_strlen), 0, 0,		/* string, list */
	2, {ARG_STRING | ARG_LIST, ARG_OPT | ARG_INT}},

{"substr", MACRO(substr), 0, 0,			/* string */
	3, {ARG_STRING, ARG_INT, ARG_OPT | ARG_INT}},

{"suspend", MACRO(suspend), 0, 0,			/* process */
	0, {0}},

{"swap_anchor", MACRO(swap_anchor), 0, 0,	/* scrap, movement */
	0, {0}},

{"switch", MACRO(do_switch), 0, 0,		/* macro */
	2, {ARG_NUM | ARG_STRING, ARG_REST}},

{"tabs", MACRO(do_tabs), 0, 0,			/* buffer */
	6, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"tan", MACRO(do_tan), 0, 0,			/* float, arith */
	1, {ARG_FLOAT}},

{"tanh", MACRO(do_tanh), 0, 0,			/* float, arith */
	1, {ARG_FLOAT}},

{"time", MACRO(do_time), 0, 0,			/* misc */
	3, {ARG_OPT | ARG_LVAL | ARG_INT,
	   ARG_OPT | ARG_LVAL | ARG_INT,
	   ARG_OPT | ARG_LVAL | ARG_INT}},

{"top_of_buffer", MACRO(gotobob), 0, 0,		/* movement */
	0, {0}},

{"top_of_window", MACRO(top_of_window), 0, 0,	/* movement */
	0, {0}},

{"transfer", MACRO(transfer), 0, 0, 		/* scrap */
	5, {ARG_INT, ARG_INT, ARG_INT, ARG_INT, ARG_INT}},

{"translate", MACRO(translate), 0, 0, 		/* search */
	7, {ARG_OPT | ARG_STRING, ARG_OPT | ARG_STRING,
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT}},

{"translate_pos", MACRO(translate_pos), 0, 0,	/* kbd, window */
	5, {ARG_INT, ARG_INT, 
	    ARG_LVAL | ARG_OPT | ARG_INT,
	    ARG_LVAL | ARG_OPT | ARG_INT,
	    ARG_LVAL | ARG_OPT | ARG_INT}},

{"trim", MACRO(trim), 0, 0, 			/* string */
	2, {ARG_STRING, ARG_OPT | ARG_STRING}},

{"typeof", MACRO(typeof), 0, 0,			/* var */
	1, {ARG_OPT | ARG_ANY}},

{"umask", MACRO(do_umask), 0, 0,		/* file */
	1, {ARG_OPT | ARG_INT}},

{"undo", MACRO(undo), 0, 0,			/* kbd, misc */
	3, {ARG_OPT | ARG_INT, ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"unregister_macro", MACRO(unregister_macro), 0, 0, /* macro */
	3, {ARG_INT, ARG_STRING, ARG_OPT | ARG_INT}},

{"up", MACRO(key_up), 0, 0,			/* buffer, window */
	1, {ARG_OPT | ARG_INT}},

{"upper", MACRO(do_upper), 0, 0,			/* string */
	1, {ARG_STRING}},

{"use_local_keyboard", MACRO(use_local_keyboard), 0, 0, /* kbd */
	1, {ARG_INT}},

{"use_tab_char", MACRO(use_tab_char), 0, 0,	/* env, screen */
	1, {ARG_OPT | ARG_STRING | ARG_INT}},

{"version", MACRO(do_version), 0, 0,		/* misc */
	3, {ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT,
	    ARG_OPT | ARG_LVAL | ARG_INT}},

{"wait", MACRO(p_wait), 0, 0,			/* proc */
	1, {ARG_OPT | ARG_LVAL | ARG_INT}},

{"wait_for", MACRO(p_wait_for), 0, 0,		/* proc */
	2, {ARG_OPT | ARG_INT, ARG_OPT | ARG_STRING | ARG_LIST}},

{"watch", MACRO(unimp), 0, 0,			/* debug */
	0, {0}},

{"while", MACRO(do_while), 0, 0,			/* macro */
	2, {ARG_COND, ARG_OPT | ARG_REST}},

{"window_color", MACRO(window_color), 0, 0,	/* window, screen */
	2, {ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT}},

{"write_block", MACRO(write_block), 0, 0,		/* file, scrap */
	4, {ARG_OPT | ARG_STRING, ARG_OPT | ARG_INT,
	    ARG_OPT | ARG_INT, ARG_OPT | ARG_INT}},

{"write_buffer", MACRO(write_buffer), 0, 0,		/* file, buffer */
	2, {ARG_OPT | ARG_STRING, ARG_OPT | ARG_INT}},

{"|", MACRO(com_op), 0, BOR,			/* arith */
	2, {ARG_INT, ARG_INT}},

{"|=", MACRO(com_equ), 0, BOR, 			/* arith */
	2, {ARG_LVAL | ARG_INT, ARG_INT}},

{"||", MACRO(oror), 0, 0, 			/* arith */
	2, {ARG_INT, ARG_COND}},

{"~", MACRO(com_op), 0, BNOT,			/* arith */
	1, {ARG_INT}}
	};

int	sizeof_builtin = sizeof builtin / sizeof (BUILTIN);

void
init_builtin()
{	register int	i;
	register BUILTIN *bp = builtin;
	static LIST f_halt = F_HALT;

	for (i = 0; i < sizeof_builtin; i++, bp++)
		bp->argv = &f_halt;
}
int
b_compare(b1, b2)
register char	*b1;
BUILTIN	*b2;
{	register char	*t = b2->name;
	for ( ; *b1 == *t; b1++, t++)
		if (*b1 == 0)
			return 0;
	return *b1 - *t;
}
BUILTIN *
lookup_builtin(str)
char	*str;
{	

	return (BUILTIN *) bsearch(str, (char *) builtin, 
			sizeof_builtin, sizeof (BUILTIN), b_compare);
}
/**********************************************************************/
/*   Return index of a builtin primitive -- used by crunch.	      */
/**********************************************************************/
int
builtin_index(str)
char	*str;
{
	BUILTIN *bp = lookup_builtin(str);
	if (bp)
		return bp - builtin;
	return -1;
}

